/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.metamodel.element;

import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.metamodel.element.Field;
import org.technologybrewery.fermenter.mda.metamodel.element.Validatable;

public interface Relation
extends Validatable {
    public String getPackage();

    public String getType();

    public String getDocumentation();

    public Multiplicity getMultiplicity();

    public FetchMode getFetchMode();

    public Field getParentIdentifier(String var1);

    public static enum FetchMode {
        EAGER("eager"),
        LAZY("lazy");

        private String value;

        private FetchMode(String value) {
            this.value = value;
        }

        public static FetchMode fromString(String value) {
            FetchMode matchedFetchMode = null;
            if (StringUtils.isNotBlank((CharSequence)value)) {
                String lowerCasedValue = value.toLowerCase();
                if (EAGER.toString().equals(lowerCasedValue)) {
                    matchedFetchMode = EAGER;
                } else if (LAZY.toString().equals(lowerCasedValue)) {
                    matchedFetchMode = LAZY;
                }
            }
            return matchedFetchMode;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        public String toUpperCase() {
            return this.value.toUpperCase();
        }

        public static String options() {
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (FetchMode mode : FetchMode.values()) {
                if (!isFirst) {
                    sb.append(", ");
                }
                sb.append(mode.toString());
                isFirst = false;
            }
            return sb.toString();
        }
    }

    public static enum Multiplicity {
        ONE_TO_MANY("1-M"),
        ONE_TO_ONE("1-1"),
        MANY_TO_MANY("M-M");

        private String value;

        private Multiplicity(String value) {
            this.value = value;
        }

        public static Multiplicity fromString(String value) {
            Multiplicity matchedMultiplicity = null;
            if (StringUtils.isNotBlank((CharSequence)value)) {
                String lowerCasedValue = value.toLowerCase();
                if (ONE_TO_MANY.toString().equalsIgnoreCase(lowerCasedValue) || "one-to-many".equals(lowerCasedValue) || "one-many".equals(lowerCasedValue)) {
                    matchedMultiplicity = ONE_TO_MANY;
                } else if (ONE_TO_ONE.toString().equalsIgnoreCase(lowerCasedValue) || "one-to-one".equals(lowerCasedValue) || "one-one".equals(lowerCasedValue)) {
                    matchedMultiplicity = ONE_TO_ONE;
                } else if (MANY_TO_MANY.toString().equalsIgnoreCase(lowerCasedValue) || "many-to-many".equals(lowerCasedValue) || "many-many".equals(lowerCasedValue)) {
                    matchedMultiplicity = MANY_TO_MANY;
                }
            }
            return matchedMultiplicity;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        public static String options() {
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (Multiplicity mode : Multiplicity.values()) {
                if (!isFirst) {
                    sb.append(", ");
                }
                sb.append(mode.toString());
                isFirst = false;
            }
            return sb.toString();
        }
    }
}

