/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.metamodel.element;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.MoreObjects;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.metamodel.DefaultModelInstanceRepository;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceRepositoryManager;
import org.technologybrewery.fermenter.mda.metamodel.element.Entity;
import org.technologybrewery.fermenter.mda.metamodel.element.Field;
import org.technologybrewery.fermenter.mda.metamodel.element.ForeignKeyFieldElement;
import org.technologybrewery.fermenter.mda.metamodel.element.Relation;
import org.technologybrewery.fermenter.mda.util.MessageTracker;

@JsonPropertyOrder(value={"type", "package", "multiplicity"})
public class RelationElement
implements Relation {
    @JsonIgnore
    private static MessageTracker messageTracker = MessageTracker.getInstance();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="package")
    protected String packageName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String documentation;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected Relation.Multiplicity multiplicity;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected Relation.FetchMode fetchMode;

    @Override
    public String getPackage() {
        return this.packageName;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    @Override
    public Relation.Multiplicity getMultiplicity() {
        return this.multiplicity;
    }

    @Override
    public Relation.FetchMode getFetchMode() {
        return this.fetchMode;
    }

    @Override
    public void validate() {
        if (this.multiplicity == null) {
            this.multiplicity = Relation.Multiplicity.ONE_TO_MANY;
        }
        if (this.fetchMode == null) {
            this.fetchMode = Relation.FetchMode.EAGER;
        }
    }

    public void setPackage(String packageName) {
        this.packageName = packageName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public void setMultiplicity(String multiplicityAsString) {
        this.multiplicity = Relation.Multiplicity.fromString(multiplicityAsString);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{multiplicityAsString}) && this.multiplicity == null) {
            messageTracker.addErrorMessage("Could not map multiplicity '" + multiplicityAsString + "' to one of the known multiplicity types! (" + Relation.Multiplicity.options() + ") ");
        }
    }

    public void setFetchMode(String fetchModeAsString) {
        this.fetchMode = Relation.FetchMode.fromString(fetchModeAsString);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fetchModeAsString}) && this.fetchMode == null) {
            messageTracker.addErrorMessage("Could not map fetch mode '" + fetchModeAsString + "' to one of the known fetch mode types! (" + Relation.FetchMode.options() + ") ");
        }
    }

    @Override
    public Field getParentIdentifier(String parentEntityName) {
        DefaultModelInstanceRepository metadataRepository = ModelInstanceRepositoryManager.getMetamodelRepository(DefaultModelInstanceRepository.class);
        Map<String, Entity> entities = metadataRepository.getEntities(this.getPackage());
        Entity parentEntity = entities.get(parentEntityName);
        Field parentIdentifier = parentEntity.getIdentifier();
        ForeignKeyFieldElement newId = new ForeignKeyFieldElement();
        newId.setType(this.getType());
        newId.setColumn(parentIdentifier.getColumn());
        newId.setParentColumn(parentIdentifier.getColumn());
        return newId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).toString();
    }
}

