/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.metamodel.element;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.technologybrewery.fermenter.mda.metamodel.element.NamespacedMetamodelElement;
import org.technologybrewery.fermenter.mda.metamodel.element.Operation;
import org.technologybrewery.fermenter.mda.metamodel.element.Rule;

@JsonPropertyOrder(value={"package", "name"})
public class RuleElement
extends NamespacedMetamodelElement
implements Rule {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String documentation;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String defaultStatement;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String defaultProcessing;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String ruleGroup;
    @JsonProperty(required=true)
    protected List<Operation> operations = new ArrayList<Operation>();

    @Override
    public String getDefaultStatement() {
        return this.defaultStatement;
    }

    @Override
    public String getDefaultProcessing() {
        return this.defaultProcessing;
    }

    @Override
    public String getRuleGroup() {
        return this.ruleGroup;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    @Override
    public List<Operation> getOperations() {
        return this.operations;
    }

    @Override
    public void validate() {
        super.validate();
        if (CollectionUtils.isEmpty(this.operations)) {
            messageTracker.addWarningMessage("Rule " + this.getName() + " does NOT contain any operations!");
        }
        for (Operation operation : this.operations) {
            operation.validate();
        }
    }

    @Override
    public String getSchemaFileName() {
        System.out.println("fermenter-2-rule-schema.json reqested");
        return "fermenter-2-rule-schema.json";
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public void setOperations(List<Operation> operations) {
        this.operations = operations;
    }
}

