/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.metamodel.element;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.technologybrewery.fermenter.mda.metamodel.element.NamespacedMetamodelElement;
import org.technologybrewery.fermenter.mda.metamodel.element.Operation;
import org.technologybrewery.fermenter.mda.metamodel.element.Service;

@JsonPropertyOrder(value={"package", "name"})
public class ServiceElement
extends NamespacedMetamodelElement
implements Service {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String documentation;
    @JsonProperty(required=true)
    protected List<Operation> operations = new ArrayList<Operation>();

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    @Override
    public List<Operation> getOperations() {
        return this.operations;
    }

    @Override
    public void validate() {
        super.validate();
        if (CollectionUtils.isEmpty(this.operations)) {
            messageTracker.addWarningMessage("Service " + this.getName() + " does NOT contain any operations!");
        }
        for (Operation operation : this.operations) {
            operation.validate();
        }
    }

    @Override
    public String getSchemaFileName() {
        return "fermenter-2-service-schema.json";
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public void setOperations(List<Operation> operations) {
        this.operations = operations;
    }
}

