/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.metamodel.element;

import java.util.HashMap;
import java.util.Map;

public enum Transaction {
    REQUIRED("Required"),
    REQUIRES_NEW("RequiresNew"),
    MANDATORY("Mandatory"),
    NOT_SUPPORTED("NotSupported"),
    SUPPORTS("Supports"),
    NEVER("Never");

    private String jtaName;
    private static Map<String, Transaction> jtaNameMap;

    private Transaction(String jtaName) {
        this.jtaName = jtaName;
    }

    public String toString() {
        return this.jtaName;
    }

    public static boolean isValidTransaction(String transactionName) {
        return jtaNameMap.containsKey(transactionName);
    }

    public static Transaction getTransactionByJtaName(String transactionName) {
        return jtaNameMap.get(transactionName);
    }

    private static Map<String, Transaction> getJtaNameMap() {
        if (jtaNameMap == null) {
            jtaNameMap = new HashMap<String, Transaction>();
            for (Transaction transaction : Transaction.values()) {
                jtaNameMap.put(transaction.jtaName, transaction);
            }
        }
        return jtaNameMap;
    }

    static {
        jtaNameMap = Transaction.getJtaNameMap();
    }
}

