/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.metamodel.element;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.metamodel.element.NamespacedMetamodel;

public interface Validation
extends NamespacedMetamodel {
    public String getDocumentation();

    public Boolean isEnumerationType();

    public Integer getMaxLength();

    public Integer getMinLength();

    public String getMaxValue();

    public String getMinValue();

    public Integer getScale();

    public Collection<String> getFormats();

    public static enum BaseType {
        STRING("string"),
        FLOAT("float"),
        DATE("date"),
        TIMESTAMP("timestamp"),
        LONG("long"),
        DOUBLE("double"),
        INTEGER("integer"),
        SHORT("short"),
        NUMERIC_BOOLEAN("numeric_boolean"),
        BOOLEAN("boolean"),
        BIG_DECIMAL("big_decimal"),
        CHARACTER("character"),
        BLOB("blob"),
        GEOSPATIAL_POINT("geospatial_point"),
        UUID("uuid");

        private String value;

        private BaseType(String value) {
            this.value = value;
        }

        public static BaseType fromString(String value) {
            BaseType matchedType = null;
            for (BaseType type : BaseType.values()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)type.value, (CharSequence)value)) continue;
                matchedType = type;
                break;
            }
            return matchedType;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        public static String options() {
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (BaseType type : BaseType.values()) {
                if (!isFirst) {
                    sb.append(", ");
                }
                sb.append(type.toString());
                isFirst = false;
            }
            return sb.toString();
        }

        public static Boolean isSimpleType(String typeName) {
            return BaseType.fromString(typeName) != null;
        }
    }
}

