/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.notification;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.technologybrewery.fermenter.mda.notification.Notification;
import org.technologybrewery.fermenter.mda.notification.NotificationService;

public final class NotificationCollector {
    private static final ThreadLocal<Map<String, Map<String, Notification>>> NOTIFICATIONS = ThreadLocal.withInitial(ConcurrentHashMap::new);

    private NotificationCollector() {
    }

    public static void cleanup() {
        NOTIFICATIONS.remove();
    }

    public static Map<String, Map<String, Notification>> getNotifications() {
        return NOTIFICATIONS.get();
    }

    public static void addNotification(String targetFile, Notification notification) {
        Map<String, Map<String, Notification>> notificationsByFilenameMap = NotificationCollector.getNotifications();
        NotificationService.addNotificationToPassedMap(targetFile, notification, notificationsByFilenameMap);
    }
}

