/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.notification;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.mda.generator.GenerationException;
import org.technologybrewery.fermenter.mda.notification.Notification;
import org.technologybrewery.fermenter.mda.notification.NotificationCollector;
import org.technologybrewery.fermenter.mda.notification.NotificationUtils;
import org.technologybrewery.fermenter.mda.notification.SimpleNotification;
import org.technologybrewery.fermenter.mda.notification.VelocityNotification;

@Named
@Singleton
public class NotificationService
extends AbstractMavenLifecycleParticipant {
    public static final String JSON = "json";
    private static final Logger logger = LoggerFactory.getLogger(NotificationService.class);
    private static final String NOTIFICATION_DIR_NAME = "manual-action-notifications";
    static final String NOTIFICATION_DIRECTORY_PATH = "target/manual-action-notifications/";
    public static final String GROUP = "group://";
    private MavenSession session;
    private boolean hideManualActions = false;
    private boolean displayMessageKeys = false;
    private static ObjectMapper objectMapper = new ObjectMapper();

    @Inject
    public NotificationService(MavenSession session) {
        this.session = session;
    }

    public void afterSessionEnd(MavenSession session) {
        this.session = session;
        String rawHideManualActions = session.getUserProperties().getProperty("fermenter.hide.manual.actions");
        String displayMessageKeys = session.getUserProperties().getProperty("fermenter.display.message.keys");
        if (rawHideManualActions != null) {
            this.hideManualActions = Boolean.parseBoolean(rawHideManualActions);
        }
        if (displayMessageKeys != null) {
            this.displayMessageKeys = Boolean.parseBoolean(displayMessageKeys);
        }
        try {
            this.displayNotifications();
        }
        catch (IOException e) {
            throw new GenerationException("Could not emit manual action notifications! Check target directories for more details.", e);
        }
    }

    static void addNotificationToPassedMap(String targetFile, Notification notification, Map<String, Map<String, Notification>> notificationsByFilenameMap) {
        String notificationKey;
        Map notificationsForFile = notificationsByFilenameMap.computeIfAbsent(targetFile, k -> new ConcurrentHashMap());
        if (!notificationsForFile.containsKey(notificationKey = notification.getKey())) {
            notificationsForFile.put(notificationKey, notification);
        } else {
            ((Notification)notificationsForFile.get(notificationKey)).addItems(notification.getItems());
        }
    }

    public void recordNotifications(MavenProject project, List<String> suppressedMessages) {
        int manualActionCount = 0;
        File projectParentFile = new File(project.getBasedir(), NOTIFICATION_DIRECTORY_PATH);
        Map<String, Map<String, Notification>> collectorNotifications = NotificationCollector.getNotifications();
        for (Map.Entry<String, Map<String, Notification>> entry : collectorNotifications.entrySet()) {
            String fileName = entry.getKey();
            Map<String, Notification> notificationsForFile = entry.getValue();
            boolean i = false;
            for (Map.Entry<String, Notification> subMapEntry : notificationsForFile.entrySet()) {
                Notification notification = subMapEntry.getValue();
                if (suppressedMessages != null && suppressedMessages.contains(subMapEntry.getValue().getKey())) continue;
                File notificationParentFile = this.getNotificationParentFile(projectParentFile, subMapEntry.getValue());
                File outputFile = new File(notificationParentFile, FilenameUtils.getName((String)(fileName + "-" + UUID.randomUUID().toString() + ".json")));
                try {
                    FileUtils.forceMkdir((File)notificationParentFile);
                    FileUtils.write((File)outputFile, (CharSequence)NotificationService.getNotificationJson(notification), (Charset)Charset.defaultCharset());
                    if (notification instanceof VelocityNotification) {
                        VelocityNotification velocityNotification = (VelocityNotification)notification;
                        velocityNotification.writeExternalVelocityContextProperties(project.getBasedir());
                    }
                    ++manualActionCount;
                }
                catch (IOException e) {
                    throw new GenerationException("Could not write manual action notification to disk!", e);
                }
            }
            if (manualActionCount <= 0) continue;
            logger.warn("{} manual action notification encountered - details written to {}", (Object)manualActionCount, (Object)projectParentFile.getAbsoluteFile());
        }
        NotificationCollector.cleanup();
    }

    private File getNotificationParentFile(File projectParentFile, Notification notification) {
        String group = notification.getGroup();
        File result = StringUtils.isBlank((String)group) ? projectParentFile : new File(projectParentFile, FilenameUtils.getName((String)group));
        return result;
    }

    private void displayNotifications() throws IOException {
        if (this.hideManualActions) {
            logger.debug("Hiding manual actions");
        } else if (logger.isWarnEnabled()) {
            this.emitNotifications();
        }
    }

    private void emitNotifications() throws IOException {
        Map<String, Set<Notification>> notificationMap = this.findNotificationForDisplay();
        GroupNotificationOutput notificationOutput = this.groupNotifications(notificationMap);
        if (MapUtils.isNotEmpty(notificationOutput.groupedNotificationMap)) {
            int i = 1;
            logger.warn("Manual action steps were detected by fermenter-mda in {} module(s)", (Object)notificationMap.size());
            logger.warn("");
            for (Map.Entry<String, List<Notification>> entry : notificationOutput.groupedNotificationMap.entrySet()) {
                String key = entry.getKey();
                if (key.startsWith(GROUP)) {
                    NotificationService.denoteNewManualAction(i);
                    String groupName = key.replace(GROUP, "");
                    this.outputGroupNotification(entry, notificationOutput.groupedNotificationVelocityContextMap.get(groupName), groupName);
                } else {
                    for (Notification notification : entry.getValue()) {
                        NotificationService.denoteNewManualAction(i);
                        if (this.displayMessageKeys) {
                            logger.warn("Message Key: " + key + "\n" + notification.getNotificationAsString());
                            continue;
                        }
                        logger.warn(notification.getNotificationAsString());
                    }
                }
                ++i;
            }
            logger.warn("To disable these messages, please use -Dfermenter.hide.manual.actions=true");
            logger.warn("To disable specific messages, please add their message keys to the suppressedMessages list. See the Fermenter docs for more info: https://github.com/TechnologyBrewery/fermenter");
        }
    }

    private static void denoteNewManualAction(int i) {
        logger.warn("------------------------------------------------------------------------");
        logger.warn("Manual Action #{}", (Object)i);
        logger.warn("------------------------------------------------------------------------");
    }

    private Map<String, Set<Notification>> findNotificationForDisplay() {
        HashMap<String, Set<Notification>> resultMap = new HashMap<String, Set<Notification>>();
        List projects = this.session.getAllProjects();
        for (MavenProject project : projects) {
            File[] fileArray;
            File projectBaseDirectory = project.getBasedir();
            File projectNotificationDirectory = new File(projectBaseDirectory, NOTIFICATION_DIRECTORY_PATH);
            if (!projectNotificationDirectory.exists() || (fileArray = projectNotificationDirectory.listFiles()) == null) continue;
            IOFileFilter txtFileFilter = FileFilterUtils.suffixFileFilter((String)JSON);
            Collection files = FileUtils.listFiles((File)projectNotificationDirectory, (IOFileFilter)txtFileFilter, (IOFileFilter)FileFilterUtils.directoryFileFilter());
            for (File notificationJsonFile : files) {
                try {
                    SimpleNotification notification = (SimpleNotification)objectMapper.readValue(notificationJsonFile, SimpleNotification.class);
                    Set notifications = resultMap.computeIfAbsent(notification.getKey(), l -> new HashSet());
                    notification.setFile(notificationJsonFile);
                    notifications.add(notification);
                }
                catch (IOException e) {
                    throw new GenerationException("Could not read notification!", e);
                }
            }
        }
        return resultMap;
    }

    private GroupNotificationOutput groupNotifications(Map<String, Set<Notification>> notificationMap) {
        GroupNotificationOutput groupedNotifications = new GroupNotificationOutput();
        for (Map.Entry<String, Set<Notification>> entry : notificationMap.entrySet()) {
            for (Notification notification : entry.getValue()) {
                Object key = notification.getKey();
                String group = notification.getGroup();
                if (notification.hasGroup()) {
                    key = GROUP + group;
                    this.loadGroupVelocityContextProperties(notification, groupedNotifications);
                }
                List notificationList = groupedNotifications.groupedNotificationMap.computeIfAbsent((String)key, l -> new ArrayList());
                notificationList.add(notification);
            }
        }
        return groupedNotifications;
    }

    private void loadGroupVelocityContextProperties(Notification notification, GroupNotificationOutput groupedNotifications) {
        String sourceGroupPropertiesName = FilenameUtils.getName((String)String.format("group-%s.properties", notification.getGroup()));
        File sourceGroupPropertiesFile = new File(notification.getFile().getParentFile(), sourceGroupPropertiesName);
        if (sourceGroupPropertiesFile.exists()) {
            Properties targetGroupProperties = groupedNotifications.groupedNotificationVelocityContextMap.computeIfAbsent(notification.getGroup(), p -> new Properties());
            NotificationUtils.mergeExistingAndNewProperties(sourceGroupPropertiesFile, targetGroupProperties);
        }
    }

    private void outputGroupNotification(Map.Entry<String, List<Notification>> entry, Properties groupProperties, String groupName) throws IOException {
        String templateName = "templates/notifications/group-" + groupName + ".vm";
        HashSet<String> groupItems = new HashSet<String>();
        for (Notification notification : entry.getValue()) {
            if (this.displayMessageKeys) {
                logger.warn("Message Key: " + notification.getKey() + "\n" + notification.getNotificationAsString());
                continue;
            }
            groupItems.add(notification.getNotificationAsString());
        }
        VelocityNotification groupNotification = new VelocityNotification(groupName, groupName, groupItems, templateName);
        if (groupProperties != null) {
            for (String groupPropertyKey : groupProperties.stringPropertyNames()) {
                String value = groupProperties.getProperty(groupPropertyKey);
                groupNotification.addToVelocityContext(groupPropertyKey, value);
            }
        }
        if (!this.displayMessageKeys) {
            logger.warn(groupNotification.getNotificationAsString());
        }
    }

    protected static String getNotificationJson(Notification notification) {
        try {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)notification);
        }
        catch (JsonProcessingException e) {
            throw new GenerationException("Could not transform notification to json!", e);
        }
    }

    private static class GroupNotificationOutput {
        Map<String, List<Notification>> groupedNotificationMap = new HashMap<String, List<Notification>>();
        Map<String, Properties> groupedNotificationVelocityContextMap = new HashMap<String, Properties>();

        private GroupNotificationOutput() {
        }
    }
}

