/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.notification;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.mda.generator.GenerationException;
import org.technologybrewery.fermenter.mda.notification.AbstractNotification;
import org.technologybrewery.fermenter.mda.notification.NotificationUtils;

public class VelocityNotification
extends AbstractNotification {
    private static final Logger logger = LoggerFactory.getLogger(VelocityNotification.class);
    protected String velocityTemplate;
    protected VelocityContext context;
    protected Properties groupVelocityContextValues;
    protected static VelocityEngine velocityEngine = new VelocityEngine();

    public VelocityNotification(String key, Set<String> items, String velocityTemplate) {
        super(key, items);
        this.init(key, items, velocityTemplate);
    }

    public VelocityNotification(String key, String group, Set<String> items, String velocityTemplate) {
        super(key, group, items);
        this.init(key, items, velocityTemplate);
        this.context.put("group", (Object)group);
    }

    private void init(String key, Set<String> items, String velocityTemplate) {
        this.velocityTemplate = velocityTemplate;
        this.context = new VelocityContext();
        this.context.put("key", (Object)key);
        this.context.put("items", items);
    }

    public void addToVelocityContext(String velocityContextKey, Object value) {
        this.context.put(velocityContextKey, value);
    }

    public void addToExternalVelocityContextProperties(String key, String value) {
        this.validateExternalVelocityContextProperties();
        this.groupVelocityContextValues.put(key, value);
    }

    private void validateExternalVelocityContextProperties() {
        if (this.groupVelocityContextValues == null) {
            if (StringUtils.isBlank((String)this.group)) {
                throw new GenerationException("External Velocity Context Properties can ONLY be used when group is set!");
            }
            this.groupVelocityContextValues = new Properties();
        }
    }

    private Properties getExternalVelocityContextProperties() {
        this.validateExternalVelocityContextProperties();
        return this.groupVelocityContextValues;
    }

    void writeExternalVelocityContextProperties(File parentFile) {
        if (this.hasGroup()) {
            Properties externalVelocityContextValues = this.getExternalVelocityContextProperties();
            File propertiesFile = this.getGroupVelocityContenctPropertiesFile(parentFile);
            try {
                if (propertiesFile.exists()) {
                    NotificationUtils.mergeExistingAndNewProperties(propertiesFile, externalVelocityContextValues);
                } else {
                    FileUtils.forceMkdirParent((File)propertiesFile);
                }
                try (BufferedWriter writer = Files.newBufferedWriter(propertiesFile.toPath(), Charset.defaultCharset(), new OpenOption[0]);){
                    externalVelocityContextValues.store(writer, null);
                }
            }
            catch (IOException e) {
                throw new GenerationException("Error writing group velocity context properties!", e);
            }
        }
    }

    File getGroupVelocityContenctPropertiesFile(File parentFile) {
        String propertiesFileName = FilenameUtils.getName((String)String.format("group-%s.properties", this.group));
        File parentDirectory = new File(parentFile, "target/manual-action-notifications/" + this.group);
        return new File(parentDirectory, propertiesFileName);
    }

    @Override
    public String getNotificationAsString() {
        Object notificationString = "";
        if (StringUtils.isBlank((String)this.velocityTemplate)) {
            throw new GenerationException("Template location MUST be provided!");
        }
        Template template = velocityEngine.getTemplate(this.velocityTemplate);
        if (template == null) {
            String error = String.format("No template found at %s!", this.velocityTemplate);
            logger.error(error);
            notificationString = error;
        } else {
            try (StringWriter writer = new StringWriter();){
                template.merge((Context)this.context, (Writer)writer);
                notificationString = (String)notificationString + ((Object)writer).toString();
            }
            catch (IOException e) {
                throw new GenerationException("Could not process notification of manual action!", e);
            }
        }
        return notificationString;
    }

    static {
        velocityEngine.setProperty("resource.loaders", (Object)"classpath");
        velocityEngine.setProperty("resource.loader.classpath.class", (Object)ClasspathResourceLoader.class.getName());
        velocityEngine.init();
    }
}

