/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.reporting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class FileStats {
    private final String filePath;
    private long size;
    private long lineCount;

    @JsonCreator
    public FileStats(@JsonProperty(value="filePath") String filePath) {
        this.filePath = filePath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public long getSize() {
        return this.size;
    }

    public long getLineCount() {
        return this.lineCount;
    }

    public void addBytesWritten(long bytesWritten) {
        this.size += bytesWritten;
    }

    public void addLinesWritten(long lines) {
        this.lineCount += lines;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileStats fileStats = (FileStats)o;
        return new EqualsBuilder().append(this.size, fileStats.size).append(this.lineCount, fileStats.lineCount).append((Object)this.filePath, (Object)fileStats.filePath).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.filePath).toHashCode();
    }

    public static Aggregate aggregate(Collection<FileStats> statsToAggregate) {
        int fileCount = statsToAggregate.size();
        long totalSize = 0L;
        long totalLines = 0L;
        for (FileStats eachFileStats : statsToAggregate) {
            totalSize += eachFileStats.getSize();
            totalLines += eachFileStats.getLineCount();
        }
        return new Aggregate(fileCount, totalSize, totalLines);
    }

    public static final class Aggregate {
        private final int fileCount;
        private final long totalSize;
        private final long totalLines;

        public Aggregate(int fileCount, long totalSize, long totalLines) {
            this.fileCount = fileCount;
            this.totalSize = totalSize;
            this.totalLines = totalLines;
        }

        public int getFileCount() {
            return this.fileCount;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public long getTotalLines() {
            return this.totalLines;
        }
    }
}

