/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.reporting;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.execution.MavenSession;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.mda.reporting.FileStats;
import org.technologybrewery.fermenter.mda.reporting.StatsCollectingWriter;

@Named
@Singleton
public final class StatisticsService
extends AbstractMavenLifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(StatisticsService.class);
    private static final String STATS_KEY = "fermenter.generationStats";
    private static final String ENABLE_STATS = "fermenter.enableStatistics";
    private final MavenSession session;
    private final String uuid;
    private boolean statsReportingEnabled;

    @Inject
    public StatisticsService(MavenSession aSession) {
        this.session = aSession;
        String enabledString = (String)this.session.getSystemProperties().getOrDefault((Object)ENABLE_STATS, "false");
        this.statsReportingEnabled = "true".equalsIgnoreCase(enabledString);
        this.uuid = UUID.randomUUID().toString();
    }

    public void afterSessionEnd(MavenSession session) {
        if (!session.getResult().hasExceptions() && this.statsReportingEnabled) {
            FileStats.Aggregate totals = this.calculateFinalStats();
            logger.info("****************************************************************************");
            logger.info("*                        Fermenter Execution Report                        *");
            logger.info("*");
            logger.info("*   Files generated:            " + totals.getFileCount() + " files");
            logger.info("*   Size of generated files:    " + totals.getTotalSize() + " bytes");
            logger.info("*   Lines generated :           " + totals.getTotalLines() + " lines");
            logger.info("*");
            logger.info("*");
            logger.info("* Note: to find the real size of your project in bytes");
            logger.info("*   1. Delete build artifacts (e.g. `mvn clean`)");
            logger.info("*   2. Delete any package lock files (e.g. `find . -name poetry.lock -delete`)");
            logger.info("*   3. Run `ls -lR | grep -E '^-' | awk '{sum+=$5;} END{print sum}'`");
            logger.info("****************************************************************************");
        }
    }

    public void recordStats(Template template, File destinationFile, VelocityContext vc) {
        if (this.isStatsReportingEnabled()) {
            StatsCollectingWriter fw = new StatsCollectingWriter(this, destinationFile);
            template.merge((Context)vc, (Writer)fw);
            fw.close();
        }
    }

    public boolean isStatsReportingEnabled() {
        return this.statsReportingEnabled;
    }

    public void setStatsReportingEnabled(boolean statsReportingEnabled) {
        this.statsReportingEnabled = statsReportingEnabled;
    }

    synchronized void updateGeneratedFileStats(FileStats newStats) {
        List<FileStats> allStats = this.readStatsFromSession(STATS_KEY + this.uuid);
        if (!allStats.contains(newStats)) {
            allStats.add(newStats);
        } else {
            logger.warn("Duplicate generation for " + newStats.getFilePath());
        }
        this.writeStatsToSession(STATS_KEY + this.uuid, allStats);
    }

    FileStats.Aggregate calculateFinalStats() {
        ArrayList<FileStats> allStats = new ArrayList<FileStats>();
        for (Object eachKey : this.session.getUserProperties().keySet()) {
            if (!(eachKey instanceof String) || !((String)eachKey).startsWith(STATS_KEY)) continue;
            allStats.addAll(this.readStatsFromSession((String)eachKey));
        }
        return FileStats.aggregate(allStats);
    }

    private List<FileStats> readStatsFromSession(String key) {
        List<FileStats> sessionStats;
        block3: {
            sessionStats = new ArrayList<FileStats>();
            try {
                ObjectMapper mapper = new ObjectMapper();
                String json = (String)this.session.getUserProperties().get(key);
                if (!StringUtils.isEmpty((CharSequence)json)) {
                    sessionStats = (List)mapper.readValue(json, (TypeReference)new TypeReference<List<FileStats>>(){});
                }
            }
            catch (JsonProcessingException e) {
                if (!this.isStatsReportingEnabled()) break block3;
                throw new RuntimeException("Unable to get generation stats from maven session", e);
            }
        }
        return sessionStats;
    }

    private void writeStatsToSession(String key, List<FileStats> stats) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            String json = mapper.writeValueAsString(stats);
            this.session.getUserProperties().setProperty(key, json);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to persist updated generation statistics", e);
        }
    }
}

