/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.reporting;

import java.io.File;
import java.io.Writer;
import org.technologybrewery.fermenter.mda.reporting.FileStats;
import org.technologybrewery.fermenter.mda.reporting.StatisticsService;

public final class StatsCollectingWriter
extends Writer {
    private final StatisticsService statisticsService;
    private final FileStats stats;

    public StatsCollectingWriter(StatisticsService statisticsService, File destination) {
        this.statisticsService = statisticsService;
        this.stats = new FileStats(destination.getAbsolutePath());
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        this.stats.addBytesWritten(len);
        long lines = 0L;
        for (int i = 0; i < len; ++i) {
            char c = cbuf[i + off];
            if (c != '\n') continue;
            ++lines;
        }
        this.stats.addLinesWritten(lines);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.statisticsService.updateGeneratedFileStats(this.stats);
    }
}

