/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.fge.jsonschema.SchemaVersion;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.main.JsonValidator;
import java.io.File;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.technologybrewery.fermenter.mda.element.ValidatedElement;
import org.technologybrewery.fermenter.mda.generator.GenerationException;
import org.technologybrewery.fermenter.mda.metamodel.element.Enum;
import org.technologybrewery.fermenter.mda.metamodel.element.EnumElement;
import org.technologybrewery.fermenter.mda.metamodel.element.Field;
import org.technologybrewery.fermenter.mda.metamodel.element.FieldElement;
import org.technologybrewery.fermenter.mda.metamodel.element.Message;
import org.technologybrewery.fermenter.mda.metamodel.element.MessageElement;
import org.technologybrewery.fermenter.mda.metamodel.element.MessageGroup;
import org.technologybrewery.fermenter.mda.metamodel.element.MessageGroupElement;
import org.technologybrewery.fermenter.mda.metamodel.element.Operation;
import org.technologybrewery.fermenter.mda.metamodel.element.OperationElement;
import org.technologybrewery.fermenter.mda.metamodel.element.Parameter;
import org.technologybrewery.fermenter.mda.metamodel.element.ParameterElement;
import org.technologybrewery.fermenter.mda.metamodel.element.Parent;
import org.technologybrewery.fermenter.mda.metamodel.element.ParentElement;
import org.technologybrewery.fermenter.mda.metamodel.element.Reference;
import org.technologybrewery.fermenter.mda.metamodel.element.ReferenceElement;
import org.technologybrewery.fermenter.mda.metamodel.element.Relation;
import org.technologybrewery.fermenter.mda.metamodel.element.RelationElement;
import org.technologybrewery.fermenter.mda.metamodel.element.Return;
import org.technologybrewery.fermenter.mda.metamodel.element.ReturnElement;
import org.technologybrewery.fermenter.mda.metamodel.element.Validation;
import org.technologybrewery.fermenter.mda.metamodel.element.ValidationElement;

public final class JsonUtils {
    private static final Log LOG = LogFactory.getLog(JsonUtils.class);
    private static final JsonUtils singletonInstance = new JsonUtils();
    private ObjectMapper cachedObjectMapper;

    private JsonUtils() {
    }

    public static <T extends ValidatedElement> T readAndValidateJsonByUrl(URL jsonUrl, Class<T> type) {
        try {
            ObjectMapper objectMapper = JsonUtils.singletonInstance.cachedObjectMapper;
            ValidatedElement instance = (ValidatedElement)objectMapper.readValue(jsonUrl, type);
            boolean valid = JsonUtils.isValid(objectMapper.readTree(jsonUrl), instance, new File(jsonUrl.getFile()));
            if (!valid) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)objectMapper.writeValueAsString((Object)instance));
                }
                throw new GenerationException(jsonUrl.toExternalForm() + " contained validation errors!");
            }
            return (T)instance;
        }
        catch (Exception e) {
            throw new GenerationException("Problem reading json file: " + jsonUrl.toExternalForm(), e);
        }
    }

    public static <T extends ValidatedElement> T readAndValidateJson(File jsonFile, Class<T> type) {
        try {
            ObjectMapper objectMapper = JsonUtils.singletonInstance.cachedObjectMapper;
            ValidatedElement instance = (ValidatedElement)objectMapper.readValue(jsonFile, type);
            boolean valid = JsonUtils.isValid(objectMapper.readTree(jsonFile), instance, jsonFile);
            if (!valid) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)objectMapper.writeValueAsString((Object)instance));
                }
                throw new GenerationException(jsonFile.getName() + " contained validation errors!");
            }
            return (T)instance;
        }
        catch (Exception e) {
            throw new GenerationException("Problem reading json file: " + jsonFile, e);
        }
    }

    private static <T extends ValidatedElement> boolean isValid(JsonNode jsonInstance, T instance, File jsonFile) throws Exception {
        URL targetSchemaUrl;
        JsonNode targetSchemaAsJsonNode;
        ProcessingReport report = null;
        ObjectMapper objectMapper = JsonUtils.singletonInstance.cachedObjectMapper;
        ValidationConfiguration cfg = ValidationConfiguration.newBuilder().setDefaultVersion(SchemaVersion.DRAFTV4).freeze();
        JsonValidator validator = JsonSchemaFactory.newBuilder().setValidationConfiguration(cfg).freeze().getValidator();
        report = validator.validate(targetSchemaAsJsonNode = objectMapper.readTree(targetSchemaUrl = instance.getJsonSchemaUrl()), jsonInstance);
        if (!report.isSuccess()) {
            for (ProcessingMessage processingMessage : report) {
                LOG.error((Object)(" " + jsonFile.getName() + " contains the following error:\n" + processingMessage));
            }
        }
        return report.isSuccess();
    }

    public static void setObjectMapper(ObjectMapper objectMapper) {
        JsonUtils.singletonInstance.cachedObjectMapper = objectMapper;
    }

    public static ObjectMapper getObjectMapper() {
        if (JsonUtils.singletonInstance.cachedObjectMapper == null) {
            SimpleModule module = new SimpleModule();
            module.addAbstractTypeMapping(Enum.class, EnumElement.class);
            module.addAbstractTypeMapping(Operation.class, OperationElement.class);
            module.addAbstractTypeMapping(Return.class, ReturnElement.class);
            module.addAbstractTypeMapping(Parameter.class, ParameterElement.class);
            module.addAbstractTypeMapping(Parent.class, ParentElement.class);
            module.addAbstractTypeMapping(Field.class, FieldElement.class);
            module.addAbstractTypeMapping(Validation.class, ValidationElement.class);
            module.addAbstractTypeMapping(Reference.class, ReferenceElement.class);
            module.addAbstractTypeMapping(Relation.class, RelationElement.class);
            module.addAbstractTypeMapping(MessageGroup.class, MessageGroupElement.class);
            module.addAbstractTypeMapping(Message.class, MessageElement.class);
            ObjectMapper localMapper = new ObjectMapper();
            localMapper.registerModule((Module)module);
            JsonUtils.singletonInstance.cachedObjectMapper = localMapper;
        }
        return JsonUtils.singletonInstance.cachedObjectMapper;
    }
}

