/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.technologybrewery.fermenter.mda.GenerateSourcesHelper;

public class MessageTracker {
    private static ThreadLocal<MessageTracker> threadBoundInstance = ThreadLocal.withInitial(MessageTracker::new);
    boolean hasErrors;
    private List<Message> orderedMessages = new ArrayList<Message>();

    private MessageTracker() {
    }

    public static MessageTracker getInstance() {
        return threadBoundInstance.get();
    }

    public static void cleanUp() {
        threadBoundInstance.remove();
    }

    public void clear() {
        this.hasErrors = false;
        this.orderedMessages.clear();
    }

    public void addErrorMessage(String errorMessage) {
        this.orderedMessages.add(new ErrorMessage(errorMessage));
        this.hasErrors = true;
    }

    public void addWarningMessage(String warningMessage) {
        this.orderedMessages.add(new WarningMessage(warningMessage));
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public void emitMessages(Log log) {
        for (Message message : this.orderedMessages) {
            message.log(log);
        }
    }

    public void emitMessages(GenerateSourcesHelper.LoggerDelegate loggerDelegate) {
        for (Message message : this.orderedMessages) {
            message.log(loggerDelegate);
        }
    }

    class ErrorMessage
    extends Message {
        public ErrorMessage(String value) {
            super(value);
        }

        @Override
        void log(Log log) {
            log.error((Object)this.value);
        }

        @Override
        void log(GenerateSourcesHelper.LoggerDelegate log) {
            log.log(GenerateSourcesHelper.LoggerDelegate.LogLevel.ERROR, this.value);
        }
    }

    class WarningMessage
    extends Message {
        public WarningMessage(String value) {
            super(value);
        }

        @Override
        void log(Log log) {
            log.warn((Object)this.value);
        }

        @Override
        void log(GenerateSourcesHelper.LoggerDelegate log) {
            log.log(GenerateSourcesHelper.LoggerDelegate.LogLevel.WARN, this.value);
        }
    }

    abstract class Message {
        protected String value;

        public Message(String value) {
            this.value = value;
        }

        abstract void log(Log var1);

        abstract void log(GenerateSourcesHelper.LoggerDelegate var1);
    }
}

