/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.util;

import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.execution.MavenSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.mda.util.PriorityMessage;
import org.technologybrewery.fermenter.mda.util.PriorityMessageService;

@Named
@Singleton
public class PriorityMessageExecution
extends AbstractMavenLifecycleParticipant {
    private static final Logger logger = LoggerFactory.getLogger(PriorityMessageExecution.class);
    private static final String PRIORITYMESSAGES = "PriorityMessages";
    private static final String DIVIDER = "***********************************************************************\n";
    private static final String HEADER = "*** Fermenter High Priority Messages                                ***\n";
    private static final String EMPTY_LINE = "\n";

    public void afterSessionEnd(MavenSession session) {
        List<PriorityMessage> messages = PriorityMessageService.getPriorityMessages(session);
        if (messages.size() > 0) {
            StringBuilder logMessage = new StringBuilder();
            logMessage.append(EMPTY_LINE);
            logMessage.append(DIVIDER);
            logMessage.append(HEADER);
            logMessage.append(DIVIDER);
            messages.stream().map(Object::toString).forEach(message -> {
                logMessage.append((String)message);
                logMessage.append(EMPTY_LINE);
            });
            logMessage.append(DIVIDER);
            logMessage.append(DIVIDER);
            logger.warn(logMessage.toString());
            session.getUserProperties().put(PRIORITYMESSAGES, "");
        }
    }
}

