/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.internal.DefaultLegacySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.mda.util.PriorityMessage;

public class PriorityMessageService {
    private static final Logger logger = LoggerFactory.getLogger(PriorityMessageService.class);
    private static final String PRIORITYMESSAGES = "PriorityMessages";
    private MavenSession session;

    public PriorityMessageService() {
        this.session = new DefaultLegacySupport().getSession();
    }

    public PriorityMessageService(MavenSession session) {
        this.session = session;
    }

    public void addPriorityMessage(PriorityMessage priorityMessage) {
        try {
            List<PriorityMessage> messages = PriorityMessageService.getPriorityMessages(this.session);
            messages.add(priorityMessage);
            ObjectMapper mapper = new ObjectMapper();
            String json = mapper.writeValueAsString(messages);
            this.session.getUserProperties().put(PRIORITYMESSAGES, json);
        }
        catch (JsonProcessingException e) {
            logger.error("Unable to set priority message", (Throwable)e);
        }
    }

    public static List<PriorityMessage> getPriorityMessages(MavenSession session) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            String json = (String)session.getUserProperties().get(PRIORITYMESSAGES);
            if (!StringUtils.isEmpty((CharSequence)json)) {
                return (List)mapper.readValue(json, (TypeReference)new TypeReference<List<PriorityMessage>>(){});
            }
        }
        catch (JsonProcessingException e) {
            logger.error("Unable to get priority messages", (Throwable)e);
        }
        return new ArrayList<PriorityMessage>();
    }
}

