/*
 * Decompiled with CFR 0.152.
 */
package org.technologybrewery.fermenter.mda.xml;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LoggingErrorHandler
implements ErrorHandler {
    private Log log = LogFactory.getLog(LoggingErrorHandler.class);
    private String fileName;

    public LoggingErrorHandler() {
    }

    public LoggingErrorHandler(Log logInstance) {
        if (this.log != null) {
            this.log = logInstance;
        }
    }

    @Override
    public void error(SAXParseException spe) throws SAXException {
        if (this.log.isErrorEnabled()) {
            String msg = this.createLogMessage(spe);
            this.log.error((Object)msg);
        }
    }

    @Override
    public void fatalError(SAXParseException spe) throws SAXException {
        if (this.log.isFatalEnabled()) {
            String msg = this.createLogMessage(spe);
            this.log.fatal((Object)msg, (Throwable)spe);
        }
    }

    @Override
    public void warning(SAXParseException spe) throws SAXException {
        if (this.log.isWarnEnabled()) {
            String msg = this.createLogMessage(spe);
            this.log.warn((Object)msg);
        }
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    protected String createLogMessage(SAXParseException spe) {
        int lineNumber = spe.getLineNumber();
        int columnNumber = spe.getColumnNumber();
        String message = spe.getMessage();
        StringBuffer sb = new StringBuffer(150);
        sb.append("A parsing error occurred ");
        if (!StringUtils.isBlank((CharSequence)this.fileName)) {
            sb.append("in file '").append(this.fileName).append("' ");
        }
        sb.append("on line '").append(lineNumber).append("' and column number '").append(columnNumber).append("' - ").append(message);
        return sb.toString();
    }
}

