/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cache.caffeine;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.teiid.cache.Cache;
import org.teiid.cache.CacheFactory;

public class CaffeineCacheFactory
implements CacheFactory {
    private Map<String, Cache> map = new HashMap<String, Cache>();

    public <K, V> Cache<K, V> get(String name) {
        this.map.put(name, new CaffeineCache(name, 512));
        return this.map.get(name);
    }

    public void destroy() {
        HashSet<String> keys = new HashSet<String>(this.map.keySet());
        keys.forEach(k -> this.map.get(k).clear());
        this.map.clear();
    }

    static class CaffeineCache<K, V>
    implements Cache<K, V> {
        private String name;
        private Map<K, ExpiringValue<V>> delegate;

        CaffeineCache(String cacheName, int maxSize) {
            this.name = cacheName;
            this.delegate = Caffeine.newBuilder().maximumSize((long)maxSize).expireAfter(new Expiry<K, ExpiringValue<V>>(){

                public long expireAfterCreate(@NonNull K key, @NonNull ExpiringValue<V> value, long currentTime) {
                    if (value.ttl == null) {
                        return Long.MAX_VALUE;
                    }
                    return TimeUnit.MILLISECONDS.toNanos(value.ttl);
                }

                public long expireAfterRead(@NonNull K key, @NonNull ExpiringValue<V> value, long currentTime, @NonNegative long currentDuration) {
                    return currentDuration;
                }

                public long expireAfterUpdate(@NonNull K key, @NonNull ExpiringValue<V> value, long currentTime, @NonNegative long currentDuration) {
                    long nanos;
                    if (value.ttl != null && (nanos = TimeUnit.MILLISECONDS.toNanos(value.ttl)) < currentDuration) {
                        return nanos;
                    }
                    return currentDuration;
                }
            }).build().asMap();
        }

        public V put(K key, V value, Long ttl) {
            ExpiringValue<V> existing = this.delegate.put(key, new ExpiringValue<V>(value, ttl));
            if (existing != null) {
                return (V)((ExpiringValue)existing).value;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public boolean isTransactional() {
            return false;
        }

        public V get(K key) {
            ExpiringValue<V> value = this.delegate.get(key);
            if (value != null) {
                return (V)((ExpiringValue)value).value;
            }
            return null;
        }

        public V remove(K key) {
            ExpiringValue<V> v = this.delegate.remove(key);
            if (v != null) {
                return (V)((ExpiringValue)v).value;
            }
            return null;
        }

        public int size() {
            return Math.toIntExact(this.delegate.size());
        }

        public void clear() {
            this.delegate.clear();
        }

        public Set<K> keySet() {
            return this.delegate.keySet();
        }
    }

    static class ExpiringValue<V> {
        private V value;
        private Long ttl;

        public ExpiringValue(V value, Long ttl) {
            this.value = value;
            this.ttl = ttl;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof ExpiringValue) {
                return this.value.equals(((ExpiringValue)obj).value);
            }
            return this.value.equals(obj);
        }
    }
}

