/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.file.JavaVirtualFile;
import org.teiid.file.VirtualFile;
import org.teiid.file.VirtualFileConnection;
import org.teiid.translator.TranslatorException;

public class JavaVirtualFileConnection
implements VirtualFileConnection {
    protected File parentDirectory;

    public JavaVirtualFileConnection(String parentDirectory) {
        this.parentDirectory = new File(parentDirectory);
    }

    @Override
    public void add(InputStream in, String path) throws TranslatorException {
        try {
            ObjectConverterUtil.write((InputStream)in, (File)this.getFile(path));
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    @Override
    public boolean remove(String path) throws TranslatorException {
        File f = this.getFile(path);
        if (!f.exists()) {
            return false;
        }
        return f.delete();
    }

    @Override
    public VirtualFile[] getFiles(String location) throws TranslatorException {
        File datafile = this.getFile(location);
        Path parentPath = this.parentDirectory.toPath();
        ArrayList<String> globParts = new ArrayList<String>();
        while (!datafile.exists() && !datafile.equals(parentPath)) {
            String name = datafile.getName();
            String globPath = this.parseGlob(name);
            globParts.add(0, globPath);
            datafile = datafile.getParentFile();
        }
        if (globParts.isEmpty()) {
            if (datafile.isDirectory()) {
                return this.convert(datafile.listFiles(), parentPath);
            }
            if (datafile.exists()) {
                return new VirtualFile[]{this.pathToVirtualFile(parentPath, datafile.toPath())};
            }
        }
        try {
            int size;
            LinkedList<DirectoryStream<Path>> toProcess = new LinkedList<DirectoryStream<Path>>();
            toProcess.add(Files.newDirectoryStream(datafile.toPath(), (String)globParts.get(0)));
            for (int i = 1; i < globParts.size() && (size = toProcess.size()) != 0; ++i) {
                for (int j = 0; j < size; ++j) {
                    Iterable paths = (Iterable)toProcess.remove(0);
                    for (Path p : paths) {
                        if (Files.isRegularFile(p, new LinkOption[0])) continue;
                        toProcess.add(Files.newDirectoryStream(p, (String)globParts.get(i)));
                    }
                }
            }
            ArrayList<JavaVirtualFile> result = new ArrayList<JavaVirtualFile>();
            for (Iterable iterable : toProcess) {
                for (Path p : iterable) {
                    JavaVirtualFile f = this.pathToVirtualFile(parentPath, p);
                    result.add(f);
                }
            }
            return result.toArray(new VirtualFile[result.size()]);
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    private JavaVirtualFile pathToVirtualFile(Path parentPath, Path p) {
        Path subpath = p;
        if (p.startsWith(parentPath)) {
            subpath = p.subpath(parentPath.getNameCount(), p.getNameCount());
        }
        JavaVirtualFile f = new JavaVirtualFile(p.toFile(), subpath.toString());
        return f;
    }

    VirtualFile[] convert(File[] files, Path parentPath) {
        VirtualFile[] result = new VirtualFile[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = this.pathToVirtualFile(parentPath, files[i].toPath());
        }
        return result;
    }

    public File getFile(String path) throws TranslatorException {
        if (path == null) {
            return this.parentDirectory;
        }
        return this.relativeFile(path);
    }

    protected File relativeFile(String path) throws TranslatorException {
        return new File(this.parentDirectory, path);
    }

    public void close() {
    }

    private String parseGlob(String location) {
        StringBuilder part = new StringBuilder();
        for (int i = 0; i < location.length(); ++i) {
            char c = location.charAt(i);
            switch (c) {
                case '?': 
                case '[': 
                case '\\': 
                case '{': {
                    part.append('\\');
                    break;
                }
                case '*': {
                    if (i >= location.length() - 1 || location.charAt(i + 1) != '*') break;
                    part.append('\\');
                    ++i;
                }
            }
            part.append(c);
        }
        return part.toString();
    }
}

