/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.teiid.core.types.InputStreamFactory;

public interface VirtualFile {
    public String getName();

    public boolean isDirectory();

    public String getPath();

    default public InputStreamFactory createInputStreamFactory() {
        InputStreamFactory isf = new InputStreamFactory(){

            public InputStream getInputStream() throws IOException {
                return VirtualFile.this.openInputStream(true);
            }

            public InputStreamFactory.StorageMode getStorageMode() {
                return VirtualFile.this.getStorageMode();
            }
        };
        isf.setSystemId(this.getName());
        isf.setLength(this.getSize());
        return isf;
    }

    default public InputStreamFactory.StorageMode getStorageMode() {
        return InputStreamFactory.StorageMode.OTHER;
    }

    public InputStream openInputStream(boolean var1) throws IOException;

    public OutputStream openOutputStream(boolean var1) throws IOException;

    public long getLastModified();

    public long getCreationTime();

    public long getSize();
}

