/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.file;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.teiid.connector.DataPlugin;
import org.teiid.file.VirtualFile;
import org.teiid.resource.api.Connection;
import org.teiid.translator.TranslatorException;

public interface VirtualFileConnection
extends Connection {
    public VirtualFile[] getFiles(String var1) throws TranslatorException;

    default public void add(InputStream in, String path, FileMetadata fileMetadata) throws TranslatorException {
        this.add(in, path);
    }

    public void add(InputStream var1, String var2) throws TranslatorException;

    public boolean remove(String var1) throws TranslatorException;

    default public boolean areFilesUsableAfterClose() {
        return true;
    }

    public static class Util {
        public static VirtualFile[] getFiles(String location, VirtualFileConnection fc, boolean exceptionIfFileNotFound, boolean includeDirectories) throws TranslatorException {
            Collection filtered;
            VirtualFile[] files = fc.getFiles(location);
            if (!includeDirectories && files != null && (filtered = (Collection)Arrays.asList(files).stream().filter(f -> !f.isDirectory()).collect(Collectors.toList())).size() != files.length) {
                files = filtered.toArray(new VirtualFile[filtered.size()]);
            }
            if (exceptionIfFileNotFound && (files == null || files.length == 0)) {
                throw new TranslatorException(DataPlugin.Util.gs("file_not_found", new Object[]{location}));
            }
            return files;
        }
    }

    public static class FileMetadata {
        private Long size;

        public Long size() {
            return this.size;
        }

        public FileMetadata size(Long s) {
            this.size = s;
            return this;
        }
    }
}

