/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.mongodb;

import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public interface MongoDBConfiguration {
    public static final String STANDARD_PREFIX = "mongodb://";
    public static final String SEEDLIST_PREFIX = "mongodb+srv://";

    public Boolean getSsl();

    public String getRemoteServerList();

    public String getUsername();

    public String getPassword();

    public String getDatabase();

    public String getSecurityType();

    public String getAuthDatabase();

    default public MongoCredential getCredential() {
        MongoCredential credential = null;
        if (this.getSecurityType().equals(SecurityType.SCRAM_SHA_256.name())) {
            credential = MongoCredential.createScramSha256Credential((String)this.getUsername(), (String)(this.getAuthDatabase() == null ? this.getDatabase() : this.getAuthDatabase()), (char[])this.getPassword().toCharArray());
        } else if (this.getSecurityType().equals(SecurityType.SCRAM_SHA_1.name())) {
            credential = MongoCredential.createScramSha1Credential((String)this.getUsername(), (String)(this.getAuthDatabase() == null ? this.getDatabase() : this.getAuthDatabase()), (char[])this.getPassword().toCharArray());
        } else if (this.getSecurityType().equals(SecurityType.MONGODB_CR.name())) {
            credential = MongoCredential.createMongoCRCredential((String)this.getUsername(), (String)(this.getAuthDatabase() == null ? this.getDatabase() : this.getAuthDatabase()), (char[])this.getPassword().toCharArray());
        } else if (this.getSecurityType().equals(SecurityType.Kerberos.name())) {
            credential = MongoCredential.createGSSAPICredential((String)this.getUsername());
        } else if (this.getSecurityType().equals(SecurityType.X509.name())) {
            credential = MongoCredential.createMongoX509Credential((String)this.getUsername());
        } else if (!this.getSecurityType().equals(SecurityType.None.name()) && this.getUsername() != null && this.getPassword() != null) {
            credential = MongoCredential.createMongoCRCredential((String)this.getUsername(), (String)(this.getAuthDatabase() == null ? this.getDatabase() : this.getAuthDatabase()), (char[])this.getPassword().toCharArray());
        }
        return credential;
    }

    default public MongoClientOptions getOptions() {
        MongoClientOptions.Builder builder = MongoClientOptions.builder();
        if (Boolean.TRUE.equals(this.getSsl())) {
            builder.sslEnabled(true);
        }
        return builder.build();
    }

    default public List<ServerAddress> getServers() {
        String serverlist = this.getRemoteServerList();
        if (!serverlist.startsWith(STANDARD_PREFIX) && !serverlist.startsWith(SEEDLIST_PREFIX)) {
            ArrayList<ServerAddress> addresses = new ArrayList<ServerAddress>();
            StringTokenizer st = new StringTokenizer(serverlist, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int idx = token.indexOf(58);
                if (idx < 0) {
                    addresses.add(new ServerAddress(token));
                    continue;
                }
                addresses.add(new ServerAddress(token.substring(0, idx), Integer.valueOf(token.substring(idx + 1)).intValue()));
            }
            return addresses;
        }
        return null;
    }

    public static enum SecurityType {
        None,
        SCRAM_SHA_256,
        SCRAM_SHA_1,
        MONGODB_CR,
        Kerberos,
        X509;

    }
}

