/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.data.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import java.io.IOException;
import org.teiid.spring.data.BaseConnectionFactory;
import org.teiid.spring.data.ConnectionFactoryConfiguration;
import org.teiid.spring.data.mongodb.MongoDBConfiguration;
import org.teiid.spring.data.mongodb.MongoDBConnection;

@ConnectionFactoryConfiguration(alias="mongodb", translatorName="mongodb")
public class MongoDBConnectionFactory
implements BaseConnectionFactory<MongoDBConnection> {
    private volatile MongoClient mongoClient;
    private volatile boolean closed;
    private MongoDBConfiguration config;

    public MongoDBConnectionFactory(MongoDBConfiguration mongoDBConfiguration) {
        this.config = mongoDBConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MongoDBConnection getConnection() throws Exception {
        if (this.mongoClient == null) {
            MongoDBConnectionFactory mongoDBConnectionFactory = this;
            synchronized (mongoDBConnectionFactory) {
                if (this.mongoClient == null) {
                    if (this.closed) {
                        throw new IllegalStateException("Connection factory is closed");
                    }
                    if (this.config.getUri() != null) {
                        MongoClientURI uri = new MongoClientURI(this.config.getUri());
                        this.mongoClient = new MongoClient(uri);
                    }
                    this.mongoClient = this.config.getCredential() == null ? new MongoClient(this.config.getServers(), this.config.getOptions()) : new MongoClient(this.config.getServers(), this.config.getCredential(), this.config.getOptions());
                }
            }
        }
        return new MongoDBConnection(this.mongoClient, this.config.getDatabase());
    }

    public synchronized void close() throws IOException {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }
}

