/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.odata;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import org.springframework.transaction.TransactionStatus;
import org.teiid.core.TeiidProcessingException;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.odbc.ODBCServerRemoteImpl;
import org.teiid.olingo.service.LocalClient;
import org.teiid.spring.autoconfigure.TeiidServer;

public class SpringClient
extends LocalClient {
    private String vdbName;
    private String vdbVersion;
    private ConnectionImpl connection;
    private Properties properties;
    private TeiidServer server;
    private TransactionStatus status;

    public SpringClient(String vdbName, String vdbVersion, Properties properties, TeiidServer server, Map<Object, Future<Boolean>> loading) {
        super(vdbName, vdbVersion, properties, loading);
        this.properties = properties;
        this.vdbName = vdbName;
        this.vdbVersion = vdbVersion;
        this.server = server;
    }

    public Connection open() throws SQLException, TeiidProcessingException {
        this.connection = SpringClient.buildConnection((TeiidDriver)this.server.getDriver(), (String)this.vdbName, (String)this.vdbVersion, (Properties)this.properties);
        ODBCServerRemoteImpl.setConnectionProperties((ConnectionImpl)this.connection);
        ODBCServerRemoteImpl.setConnectionProperties((ConnectionImpl)this.connection, (Properties)this.properties);
        this.getVDB();
        return this.connection;
    }

    public void close() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public ConnectionImpl getConnection() {
        return this.connection;
    }

    public String startTransaction() throws SQLException {
        if (this.server.isUsingPlatformTransactionManager()) {
            this.status = this.server.getPlatformTransactionManagerAdapter().getOrCreateTransaction((boolean)true).status;
            return "anyid";
        }
        return super.startTransaction();
    }

    public void commit(String txnId) throws SQLException {
        if (this.server.isUsingPlatformTransactionManager()) {
            this.server.getPlatformTransactionManagerAdapter().commit(this.status);
        } else {
            super.commit(txnId);
        }
    }

    public void rollback(String txnId) throws SQLException {
        if (this.server.isUsingPlatformTransactionManager()) {
            this.server.getPlatformTransactionManagerAdapter().rollback(this.status);
        } else {
            super.rollback(txnId);
        }
    }
}

