/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.odata;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.olingo.server.api.ODataHttpHandler;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.metadata.Schema;
import org.teiid.odata.api.Client;
import org.teiid.olingo.service.OlingoBridge;
import org.teiid.olingo.web.OpenApiHandler;
import org.teiid.olingo.web.ProxyHttpServletRequest;
import org.teiid.spring.autoconfigure.TeiidServer;
import org.teiid.spring.odata.SpringClient;
import org.teiid.vdb.runtime.VDBKey;

public class SpringODataFilter
implements HandlerInterceptor {
    static final String CONTEXT_PATH = "__CONTEXT_PATH__";
    static final String REQUEST = "__REQUEST__";
    private TeiidServer server;
    private VDBMetaData vdb;
    protected OpenApiHandler openApiHandler;
    protected SoftReference<OlingoBridge> clientReference = null;
    protected Properties connectionProperties;
    private Map<Object, Future<Boolean>> loadingQueries = new ConcurrentHashMap<Object, Future<Boolean>>();

    public SpringODataFilter(Properties props, TeiidServer server, VDBMetaData vdb, ServletContext servletContext) {
        this.connectionProperties = props;
        this.server = server;
        this.vdb = vdb;
        try {
            this.openApiHandler = new OpenApiHandler(servletContext);
        }
        catch (ServletException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object contentHandler) throws Exception {
        String contextPath;
        HttpServletRequest httpRequest = request;
        HttpServletResponse httpResponse = response;
        String uri = (httpRequest = ProxyHttpServletRequest.handleProxiedRequest((HttpServletRequest)httpRequest)).getRequestURI();
        if (uri.startsWith(contextPath = httpRequest.getContextPath() + "/odata") && (uri = uri.substring(contextPath.length())).isEmpty()) {
            uri = "/";
        }
        String subContext = null;
        if (uri.startsWith("/") && uri.indexOf(47, 1) != -1) {
            int idx = uri.indexOf(47, 1);
            subContext = uri.substring(1, idx);
        }
        if (subContext != null) {
            contextPath = contextPath.isEmpty() ? subContext : contextPath + "/" + subContext;
        }
        VDBMetaData requestVDB = this.vdb;
        String vdbName = this.vdb.getName();
        String vdbVersion = this.vdb.getVersion();
        boolean implicitVdb = Boolean.valueOf(this.vdb.getPropertyValue("implicit"));
        String modelName = this.modelName(subContext, requestVDB, implicitVdb);
        if (modelName == null || modelName.isEmpty()) {
            httpResponse.sendError(404, "Wrong Model/Schema name defined in the URL");
            return false;
        }
        OlingoBridge context = null;
        if (this.clientReference != null) {
            context = this.clientReference.get();
        }
        if (context == null) {
            context = new OlingoBridge("odata");
            this.clientReference = new SoftReference<OlingoBridge>(context);
        }
        VDBKey key = new VDBKey(vdbName, (Object)vdbVersion);
        Client client = this.buildClient(vdbName, vdbVersion, this.connectionProperties);
        client.open();
        OlingoBridge.HandlerInfo handlerInfo = context.getHandlers(httpRequest.getContextPath(), client, modelName);
        ODataHttpHandler handler = handlerInfo.oDataHttpHandler;
        if (this.openApiHandler.processOpenApiMetadata(httpRequest, key, httpRequest.getRequestURI(), modelName, (ServletResponse)response, handlerInfo.serviceMetadata, null)) {
            return false;
        }
        httpRequest.setAttribute(ODataHttpHandler.class.getName(), (Object)handler);
        httpRequest.setAttribute(Client.class.getName(), (Object)client);
        httpRequest.setAttribute(REQUEST, (Object)httpRequest);
        httpRequest.setAttribute(CONTEXT_PATH, (Object)contextPath);
        return true;
    }

    public String modelName(String path, VDBMetaData vdb, boolean implicitVdb) {
        Schema schema;
        String defaultSchema;
        if (path != null && path.isEmpty()) {
            path = null;
        }
        if ((defaultSchema = vdb.getPropertyValue("default_odata_schema")) == null && implicitVdb) {
            defaultSchema = "teiid";
        }
        if (defaultSchema != null && (schema = this.server.getSchema(vdb, defaultSchema)) != null) {
            return defaultSchema;
        }
        for (Model m : vdb.getModels()) {
            if (!m.isVisible()) continue;
            if (path != null) {
                if (!path.equalsIgnoreCase(m.getName())) continue;
                return m.getName();
            }
            return m.getName();
        }
        return null;
    }

    public Client buildClient(String vdbName, String version, Properties props) {
        return new SpringClient(vdbName, version, props, this.server, this.loadingQueries);
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable ModelAndView modelAndView) throws Exception {
        Client client = (Client)request.getAttribute(Client.class.getName());
        if (client != null) {
            client.close();
        }
    }
}

