/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.odata;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.commons.api.format.ContentType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.json.simple.JSONParser;
import org.teiid.olingo.ODataPlugin;

@RestController
@RequestMapping(value={"/static"})
public class StaticContentController {
    @RequestMapping(value={"org.apache.olingo.v1.xml", "org.teiid.v1.xml"})
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathInfo = request.getRequestURI();
        try {
            int idx = pathInfo.indexOf("/static");
            pathInfo = pathInfo.substring(idx + 7);
            InputStream contents = this.getClass().getResourceAsStream(pathInfo);
            if (contents != null) {
                this.writeContent(response, contents);
                response.flushBuffer();
                return;
            }
            throw new TeiidProcessingException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16055, new Object[]{pathInfo}));
        }
        catch (TeiidProcessingException e) {
            StaticContentController.writeError((ServletRequest)request, e.getCode(), e.getMessage(), response, 404);
            return;
        }
    }

    private void writeContent(HttpServletResponse response, InputStream contents) throws IOException {
        ObjectConverterUtil.write((OutputStream)response.getOutputStream(), (InputStream)contents, (int)-1);
    }

    static void writeError(ServletRequest request, String code, String message, HttpServletResponse httpResponse, int statusCode) throws IOException {
        httpResponse.setStatus(statusCode);
        String format = request.getParameter("$format");
        if (format == null) {
            ContentType contentType = ContentType.parse((String)request.getContentType());
            format = contentType == null || contentType.isCompatible(ContentType.APPLICATION_JSON) ? "json" : "xml";
        }
        PrintWriter writer = httpResponse.getWriter();
        if (code == null) {
            code = "";
        }
        if (message == null) {
            message = "";
        }
        if (format.equalsIgnoreCase("json")) {
            httpResponse.setHeader("Content-Type", ContentType.APPLICATION_JSON.toContentTypeString());
            writer.write("{ \"error\": { \"code\": \"");
            JSONParser.escape((CharSequence)code, (Appendable)writer);
            writer.write("\", \"message\": \"");
            JSONParser.escape((CharSequence)message, (Appendable)writer);
            writer.write("\" } }");
        } else {
            try {
                httpResponse.setHeader("Content-Type", ContentType.APPLICATION_XML.toContentTypeString());
                XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(writer);
                xmlStreamWriter.writeStartElement("m", "error", "http://docs.oasis-open.org/odata/ns/metadata");
                xmlStreamWriter.writeNamespace("m", "http://docs.oasis-open.org/odata/ns/metadata");
                xmlStreamWriter.writeStartElement("m", "code", "http://docs.oasis-open.org/odata/ns/metadata");
                xmlStreamWriter.writeCharacters(code);
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeStartElement("m", "message", "http://docs.oasis-open.org/odata/ns/metadata");
                xmlStreamWriter.writeCharacters(message);
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.flush();
            }
            catch (XMLStreamException x) {
                throw new IOException(x);
            }
        }
        writer.close();
    }
}

