/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.odata;

import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.filter.CommonsRequestLoggingFilter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.spring.autoconfigure.TeiidServer;
import org.teiid.spring.identity.SpringSecurityHelper;
import org.teiid.spring.odata.SpringODataFilter;

@EnableWebMvc
@Configuration
@PropertySource(value={"classpath:odata.properties"})
public class WebConfig
implements WebMvcConfigurer {
    private static String BATCH_SIZE = "batch-size";
    private static String BATCH_SIZE_VALUE = "256";
    private static String SKIPTOKEN_CACHE_TIME = "skiptoken-cache-time";
    private static String SKIPTOKEN_CACHE_TIME_VALUE = "300000";
    @Autowired
    ApplicationContext context;
    @Autowired
    TeiidServer server;
    @Autowired
    VDBMetaData vdb;
    @Autowired
    ServletContext servletContext;
    @Autowired
    SpringSecurityHelper securityHelper;
    private Properties props = new Properties();

    @PostConstruct
    private void init() {
        this.addProperty(BATCH_SIZE, BATCH_SIZE_VALUE);
        this.addProperty(SKIPTOKEN_CACHE_TIME, SKIPTOKEN_CACHE_TIME_VALUE);
    }

    private void addProperty(String key, String defalt) {
        String value = this.context.getEnvironment().getProperty("spring.teiid.odata." + key, defalt);
        this.props.setProperty(key, value);
    }

    @Bean
    SpringODataFilter getOdataFilter() {
        return new SpringODataFilter(this.props, this.server, this.vdb, this.servletContext);
    }

    @Bean
    public CommonsRequestLoggingFilter requestLoggingFilter() {
        CommonsRequestLoggingFilter loggingFilter = new CommonsRequestLoggingFilter();
        loggingFilter.setIncludeClientInfo(true);
        loggingFilter.setIncludeQueryString(true);
        loggingFilter.setIncludePayload(true);
        loggingFilter.setIncludeHeaders(true);
        return loggingFilter;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.getOdataFilter()).addPathPatterns(new String[]{"/odata/**"});
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedMethods(new String[]{"GET,POST,PUT,PATCH,DELETE"}).allowedHeaders(new String[]{"Content-Type,Accept,Origin,Authorization"}).allowCredentials(true).maxAge(1800L);
    }
}

