/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.teiid.connector.DataPlugin;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.metadata.MetadataException;

public class NamespaceContainer
implements Serializable {
    static final String TEIID_RESERVED = "teiid_";
    private static final String TEIID_SF = "teiid_sf";
    private static final String TEIID_RELATIONAL = "teiid_rel";
    private static final String TEIID_WS = "teiid_ws";
    private static final String TEIID_MONGO = "teiid_mongo";
    private static final String TEIID_ODATA = "teiid_odata";
    private static final String TEIID_ACCUMULO = "teiid_accumulo";
    private static final String TEIID_EXCEL = "teiid_excel";
    private static final String TEIID_PARQUET = "teiid_parquet";
    private static final String TEIID_JPA = "teiid_jpa";
    private static final String TEIID_HBASE = "teiid_hbase";
    private static final String TEIID_SPATIAL = "teiid_spatial";
    private static final String TEIID_LDAP = "teiid_ldap";
    private static final String TEIID_REST = "teiid_rest";
    private static final String TEIID_PI = "teiid_pi";
    private static final String TEIID_COUCHBASE = "teiid_couchbase";
    private static final String TEIID_INFINISPAN = "teiid_ispn";
    public static final String SF_PREFIX = "teiid_sf:";
    public static final String WS_PREFIX = "teiid_ws:";
    public static final String MONGO_PREFIX = "teiid_mongo:";
    public static final String ODATA_PREFIX = "teiid_odata:";
    public static final String ACCUMULO_PREFIX = "teiid_accumulo:";
    public static final String EXCEL_PREFIX = "teiid_excel:";
    public static final String PARQUET_PREFIX = "teiid_parquet:";
    public static final String JPA_PREFIX = "teiid_jpa:";
    public static final String HBASE_PREFIX = "teiid_hbase:";
    public static final String SPATIAL_PREFIX = "teiid_spatial:";
    public static final String LDAP_PREFIX = "teiid_ldap:";
    public static final String REST_PREFIX = "teiid_rest:";
    public static final String PI_PREFIX = "teiid_pi:";
    public static final String COUCHBASE_PREFIX = "teiid_couchbase:";
    public static final String INFINISPAN_PREFIX = "teiid_ispn:";
    public static final String RELATIONAL_PREFIX = "teiid_rel:";
    private static final Map<String, String> BUILTIN = new HashMap<String, String>(){

        @Override
        public String put(String key, String value) {
            super.put(value.substring(0, value.length() - 1), key);
            return super.put(key, value);
        }
    };

    public void addNamespace(String prefix, String uri) {
        if (uri == null || uri.indexOf(125) != -1) {
            throw new MetadataException((BundleUtil.Event)DataPlugin.Event.TEIID60018, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60018, new Object[]{uri}));
        }
        if (StringUtil.startsWithIgnoreCase((String)prefix, (String)TEIID_RESERVED)) {
            String validURI = BUILTIN.get(prefix);
            if (validURI == null || !uri.equals(validURI.substring(1, validURI.length() - 1))) {
                throw new MetadataException((BundleUtil.Event)DataPlugin.Event.TEIID60017, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60017, new Object[]{prefix}));
            }
            return;
        }
        throw new MetadataException((BundleUtil.Event)DataPlugin.Event.TEIID60037, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60037, new Object[]{prefix, uri}));
    }

    public static String resolvePropertyKey(String key) {
        String uri_prefix;
        String prefix;
        int index = key.indexOf(125);
        if (index > 0 && index < key.length() && key.charAt(0) == '{' && (prefix = BUILTIN.get(uri_prefix = key.substring(0, index + 1))) != null) {
            key = prefix + key.substring(index + 1, key.length());
        }
        return key;
    }

    public static String getLegacyKey(String key) {
        String uri_prefix;
        int index = key.indexOf(58);
        if (index > 0 && index < key.length() && (uri_prefix = BUILTIN.get(key.substring(0, index))) != null) {
            return uri_prefix + key.substring(index + 1, key.length());
        }
        return null;
    }

    static {
        BUILTIN.put("{http://www.teiid.org/ext/relational/2012}", RELATIONAL_PREFIX);
        BUILTIN.put("{http://www.teiid.org/translator/salesforce/2012}", SF_PREFIX);
        BUILTIN.put("{http://www.teiid.org/translator/ws/2012}", WS_PREFIX);
        BUILTIN.put("{http://www.teiid.org/translator/mongodb/2013}", MONGO_PREFIX);
        BUILTIN.put("{http://www.jboss.org/teiiddesigner/ext/odata/2012}", ODATA_PREFIX);
        BUILTIN.put("{http://www.teiid.org/translator/accumulo/2013}", ACCUMULO_PREFIX);
        BUILTIN.put("{http://www.teiid.org/translator/excel/2014}", EXCEL_PREFIX);
        BUILTIN.put("{http://www.teiid.org/translator/jpa/2014}", JPA_PREFIX);
        BUILTIN.put("{http://www.teiid.org/translator/hbase/2014}", HBASE_PREFIX);
        BUILTIN.put("{http://www.teiid.org/translator/spatial/2015}", SPATIAL_PREFIX);
        BUILTIN.put("{http://www.teiid.org/translator/ldap/2015}", LDAP_PREFIX);
        BUILTIN.put("{http://teiid.org/rest}", REST_PREFIX);
        BUILTIN.put("{http://www.teiid.org/translator/pi/2016}", PI_PREFIX);
        BUILTIN.put("{http://www.teiid.org/translator/couchbase/2017}", COUCHBASE_PREFIX);
        BUILTIN.put("{http://www.teiid.org/translator/infinispan/2017}", INFINISPAN_PREFIX);
    }
}

