/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.security.auth.Subject;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.client.security.SessionToken;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.dqp.message.RequestID;
import org.teiid.jdbc.LocalProfile;
import org.teiid.logging.LogManager;
import org.teiid.metadata.MetadataFactory;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.security.SecurityHelper;

public class DQPWorkContext
implements Serializable {
    private static final String TEIID_VDB = "teiid-vdb";
    private static final String TEIID_SESSION = "teiid-session";
    private static final long serialVersionUID = -6389893410233192977L;
    private static final boolean longDatesTimes = (Boolean)PropertiesUtils.getHierarchicalProperty((String)"org.teiid.longDatesTimes", (Object)false, Boolean.class);
    private static ThreadLocal<DQPWorkContext> CONTEXTS = new ThreadLocal<DQPWorkContext>(){

        @Override
        protected DQPWorkContext initialValue() {
            return new DQPWorkContext();
        }
    };
    private volatile SessionMetadata session = new SessionMetadata();
    private String clientAddress;
    private String clientHostname;
    private SecurityHelper securityHelper;
    private HashMap<String, DataPolicy> policies;
    private boolean useCallingThread;
    private Version clientVersion = Version.latest();
    private boolean admin;
    private MetadataFactory metadataFactory;
    private transient LocalProfile connectionProfile;
    private boolean local = true;
    private boolean derived;

    public static DQPWorkContext getWorkContext() {
        return CONTEXTS.get();
    }

    public static void setWorkContext(DQPWorkContext context) {
        LogManager.removeMdc((String)TEIID_SESSION);
        LogManager.removeMdc((String)TEIID_VDB);
        if (context == null) {
            CONTEXTS.remove();
        } else {
            if (context.session != null) {
                LogManager.putMdc((String)TEIID_SESSION, (String)context.session.getSessionId());
                if (context.session.getVdb() != null) {
                    LogManager.putMdc((String)TEIID_VDB, (String)context.session.getVdb().getFullName());
                }
            }
            CONTEXTS.set(context);
        }
    }

    public boolean useCallingThread() {
        return this.useCallingThread;
    }

    public void setUseCallingThread(boolean useCallingThread) {
        this.useCallingThread = useCallingThread;
    }

    public SessionMetadata getSession() {
        return this.session;
    }

    public void setSession(SessionMetadata session) {
        this.session = session;
        this.policies = null;
    }

    public void setSecurityHelper(SecurityHelper securityHelper) {
        this.securityHelper = securityHelper;
    }

    public SecurityHelper getSecurityHelper() {
        return this.securityHelper;
    }

    public String getUserName() {
        return this.session.getUserName();
    }

    public Subject getSubject() {
        return this.session.getSubject();
    }

    public String getVdbName() {
        return this.session.getVDBName();
    }

    public String getVdbVersion() {
        return this.session.getVDBVersion();
    }

    public String getSessionId() {
        return this.session.getSessionId();
    }

    public String getAppName() {
        return this.session.getApplicationName();
    }

    public RequestID getRequestID(long exeuctionId) {
        return new RequestID(this.getSessionId(), exeuctionId);
    }

    public SessionToken getSessionToken() {
        return this.session.getSessionToken();
    }

    public void setClientAddress(String clientAddress) {
        this.clientAddress = clientAddress;
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public void setClientHostname(String clientHostname) {
        this.clientHostname = clientHostname;
    }

    public String getClientHostname() {
        return this.clientHostname;
    }

    public String getSecurityDomain() {
        return this.session.getSecurityDomain();
    }

    public Object getSecurityContext() {
        return this.session.getSecurityContext();
    }

    public void setSecurityContext(Object securityContext) {
        this.session.setSecurityContext(securityContext);
    }

    public VDBMetaData getVDB() {
        return this.session.getVdb();
    }

    public <V> V runInContext(Callable<V> callable) throws Throwable {
        FutureTask<V> task = new FutureTask<V>(callable);
        this.runInContext(task);
        try {
            return task.get();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInContext(Runnable runnable) {
        DQPWorkContext previous = DQPWorkContext.getWorkContext();
        DQPWorkContext.setWorkContext(this);
        Object previousSecurityContext = null;
        if (this.securityHelper != null) {
            previousSecurityContext = this.securityHelper.associateSecurityContext(this.getSecurityContext());
        }
        try {
            runnable.run();
        }
        finally {
            if (this.securityHelper != null) {
                this.securityHelper.associateSecurityContext(previousSecurityContext);
            }
            DQPWorkContext.setWorkContext(previous);
        }
    }

    public HashMap<String, DataPolicy> getAllowedDataPolicies() {
        if (this.policies == null) {
            this.policies = new HashMap();
            Set<String> userRoles = this.getUserRoles();
            VDBMetaData vdb = this.getVDB();
            TransformationMetadata metadata = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
            Collection<Object> allPolicies = null;
            allPolicies = metadata == null ? vdb.getDataPolicies() : metadata.getPolicies().values();
            if (allPolicies != null) {
                for (DataPolicy dataPolicy : allPolicies) {
                    if (!this.matchesPrincipal(userRoles, dataPolicy)) continue;
                    this.policies.put(dataPolicy.getName(), dataPolicy);
                }
            }
        }
        return this.policies;
    }

    public void setPolicies(HashMap<String, DataPolicy> policies) {
        this.policies = policies;
    }

    private boolean matchesPrincipal(Set<String> userRoles, DataPolicy policy) {
        if (policy.isAnyAuthenticated() && this.getSubject() != null) {
            return true;
        }
        return !Collections.disjoint(policy.getMappedRoleNames(), userRoles);
    }

    private Set<String> getUserRoles() {
        return DQPWorkContext.getUserRoles(this.getSubject());
    }

    public static Set<String> getUserRoles(Subject subject) {
        if (subject == null) {
            return Collections.emptySet();
        }
        HashSet<String> roles = new HashSet<String>();
        Set<Principal> principals = subject.getPrincipals();
        for (Principal p : principals) {
            if (!(p instanceof Group) || !p.getName().equals("Roles")) continue;
            Group g = (Group)p;
            Enumeration rolesPrinciples = g.members();
            while (rolesPrinciples.hasMoreElements()) {
                roles.add(((Principal)rolesPrinciples.nextElement()).getName());
            }
        }
        return roles;
    }

    public Version getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(Version clientVersion) {
        this.clientVersion = clientVersion;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public MetadataFactory getTempMetadataFactory() {
        if (this.metadataFactory == null) {
            this.metadataFactory = new MetadataFactory("temp", (Object)1, "temp", SystemMetadata.getInstance().getRuntimeTypeMap(), null, null);
        }
        return this.metadataFactory;
    }

    public void setConnectionProfile(LocalProfile connectionProfile) {
        this.connectionProfile = connectionProfile;
    }

    public LocalProfile getConnectionProfile() {
        if (this.connectionProfile == null) {
            try {
                this.connectionProfile = (LocalProfile)ReflectionHelper.create((String)"org.teiid.jdbc.jboss.ModuleLocalProfile", null, (ClassLoader)this.getClass().getClassLoader());
            }
            catch (TeiidException e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
        }
        return this.connectionProfile;
    }

    public boolean isLocal() {
        return this.local;
    }

    public DQPWorkContext local(boolean b) {
        this.local = b;
        return this;
    }

    public void setDerived(boolean b) {
        this.derived = b;
    }

    public boolean isDerived() {
        return this.derived;
    }

    static /* synthetic */ boolean access$000() {
        return longDatesTimes;
    }

    public static enum Version {
        EIGHT_0("08.00", (byte)(!DQPWorkContext.access$000() ? 1 : 0)),
        EIGHT_2("08.02", 2),
        EIGHT_4("08.04.00.CR3", 2),
        EIGHT_6("08.06.00.Beta3", 3),
        EIGHT_7("08.07.00.Beta2", 3),
        EIGHT_10("08.10.00.Alpha3", 4),
        ELEVEN_2("11.02", 5);

        private String string;
        private byte clientSerializationVersion;
        private static TreeMap<String, Version> versionMap;

        private Version(String string2, byte clientSerializationVersion) {
            this.string = string2;
            this.clientSerializationVersion = clientSerializationVersion;
        }

        public byte getClientSerializationVersion() {
            return this.clientSerializationVersion;
        }

        public String toString() {
            return this.string;
        }

        public static Version getVersion(String version) {
            Map.Entry<String, Version> v = versionMap.floorEntry(version);
            if (v == null) {
                return EIGHT_0;
            }
            return v.getValue();
        }

        public static Version latest() {
            return versionMap.lastEntry().getValue();
        }

        static {
            versionMap = new TreeMap();
            for (Version v : Version.values()) {
                versionMap.put(v.toString(), v);
            }
        }
    }
}

