/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.sql.Blob;
import java.sql.SQLException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.types.AbstractGeospatialType;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.GeographyType;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.function.GeometryUtils;
import org.teiid.query.function.TeiidFunction;
import org.teiid.query.util.CommandContext;

public class GeographyFunctionMethods {
    @TeiidFunction(name="st_asewkt", category="Geography", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static ClobType asEwkt(GeographyType geometry) throws FunctionExecutionException {
        return GeometryUtils.geometryToClob((AbstractGeospatialType)geometry, true);
    }

    @TeiidFunction(name="st_asbinary", category="Geography", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static BlobType asBlob(GeographyType geometry) {
        Blob b = (Blob)geometry.getReference();
        return new BlobType(b);
    }

    @TeiidFunction(name="st_geogfromtext", category="Geography", nullOnNull=true)
    public static GeographyType geogFromText(CommandContext ctx, ClobType wkt) throws FunctionExecutionException {
        return GeometryUtils.getGeographyType(GeometryUtils.geometryFromClob(wkt, null, true), ctx);
    }

    @TeiidFunction(name="st_geogfromwkb", category="Geography", nullOnNull=true)
    public static GeographyType geogFromBlob(CommandContext context, BlobType wkb) throws FunctionExecutionException, SQLException {
        return GeometryUtils.geographyFromEwkb(context, wkb.getBinaryStream());
    }

    @TeiidFunction(name="st_setsrid", category="Geography", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static GeographyType setSrid(GeographyType geog, int srid) {
        GeographyType gt = new GeographyType();
        gt.setReference(geog.getReference());
        gt.setSrid(srid);
        return gt;
    }

    @TeiidFunction(name="st_srid", category="Geography", nullOnNull=true, pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN)
    public static int getSrid(GeographyType geog) {
        return geog.getSrid();
    }

    @TeiidFunction(name="st_intersects", category="Geography", nullOnNull=true, pushdown=FunctionMethod.PushDown.MUST_PUSHDOWN)
    public static Boolean intersects(GeographyType geog1, GeographyType geog2) throws FunctionExecutionException {
        throw new UnsupportedOperationException();
    }

    @TeiidFunction(name="st_distance", category="Geography", nullOnNull=true, pushdown=FunctionMethod.PushDown.MUST_PUSHDOWN)
    public static Double distance(GeographyType geog1, GeographyType geog2) throws FunctionExecutionException {
        throw new UnsupportedOperationException();
    }

    @TeiidFunction(name="st_length", category="Geography", nullOnNull=true, pushdown=FunctionMethod.PushDown.MUST_PUSHDOWN)
    public static Double length(GeographyType geog) throws FunctionExecutionException {
        throw new UnsupportedOperationException();
    }
}

