/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import org.teiid.common.buffer.AutoCleanupUtil;
import org.teiid.query.metadata.NioVirtualFile;

public class NioZipFileSystem {
    public static NioVirtualFile mount(URL url) throws IOException, URISyntaxException {
        URI uri = new URI("jar:" + url.toURI().toString());
        return NioZipFileSystem.mount(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NioVirtualFile mount(URI uri) throws IOException {
        Class<NioZipFileSystem> clazz = NioZipFileSystem.class;
        synchronized (NioZipFileSystem.class) {
            try {
                FileSystem zipfs = FileSystems.getFileSystem(uri);
                zipfs.close();
            }
            catch (FileSystemNotFoundException zipfs) {
                // empty catch block
            }
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("create", "true");
            final FileSystem zipfs = FileSystems.newFileSystem(uri, env);
            Path root = zipfs.getPath("/", new String[0]);
            AutoCleanupUtil.setCleanupReference(root, new AutoCleanupUtil.Removable(){

                @Override
                public void remove() {
                    try {
                        zipfs.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new NioVirtualFile(root);
        }
    }
}

