/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.parser;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teiid.core.util.StringUtil;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.DataWrapper;
import org.teiid.metadata.Database;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.MetadataException;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Server;
import org.teiid.metadata.Table;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.parser.SQLParserUtil;

public class OptionsUtil {
    static final Pattern udtPattern = Pattern.compile("(\\w+)\\s*\\(\\s*(\\d+),\\s*(\\d+),\\s*(\\d+)\\)");

    private static void setProcedureOptions(Procedure proc) {
        Map props = proc.getProperties();
        OptionsUtil.setCommonProperties((AbstractMetadataRecord)proc, props);
        String value = (String)props.remove("UPDATECOUNT");
        if (value != null) {
            proc.setUpdateCount(Integer.parseInt(value));
        }
    }

    public static void removeOption(AbstractMetadataRecord record, String key) {
        if (record instanceof Table) {
            OptionsUtil.removeTableOption(key, (Table)record);
        }
        if (record instanceof Procedure) {
            OptionsUtil.removeProcedureOption(key, (Procedure)record);
        }
        if (record instanceof BaseColumn) {
            OptionsUtil.removeColumnOption(key, (BaseColumn)record);
        }
        if (record instanceof Schema) {
            OptionsUtil.removeSchemaOption(key, (Schema)record);
        }
        record.getProperties().remove(key);
    }

    public static void setOptions(AbstractMetadataRecord record) {
        if (record instanceof Table) {
            OptionsUtil.setTableOptions((Table)record);
        }
        if (record instanceof Procedure) {
            OptionsUtil.setProcedureOptions((Procedure)record);
        }
        if (record instanceof BaseColumn) {
            OptionsUtil.setColumnOptions((BaseColumn)record);
        }
        if (record instanceof Schema) {
            OptionsUtil.setSchemaOptions((Schema)record);
        }
        if (record instanceof Database || record instanceof DataWrapper || record instanceof Server) {
            Map props = record.getProperties();
            OptionsUtil.setCommonProperties(record, props);
        }
    }

    private static void setSchemaOptions(Schema schema) {
        Map props = schema.getProperties();
        OptionsUtil.setCommonProperties((AbstractMetadataRecord)schema, props);
    }

    private static void removeSchemaOption(String key, Schema schema) {
        if (schema.getProperty(key, false) != null) {
            schema.setProperty(key, null);
        }
        OptionsUtil.removeCommonProperty(key, (AbstractMetadataRecord)schema);
    }

    private static void removeColumnOption(String key, BaseColumn c) throws MetadataException {
        if (c.getProperty(key, false) != null) {
            c.setProperty(key, null);
        }
        OptionsUtil.removeCommonProperty(key, (AbstractMetadataRecord)c);
        if (key.equals("RADIX")) {
            c.setRadix(0);
        } else if (key.equals("NATIVE_TYPE")) {
            c.setNativeType(null);
        } else if (c instanceof Column) {
            OptionsUtil.removeColumnOption(key, (Column)c);
        }
    }

    private static void removeColumnOption(String key, Column c) {
        if (key.equals("CASE_SENSITIVE")) {
            c.setCaseSensitive(false);
        } else if (key.equals("SELECTABLE")) {
            c.setSelectable(true);
        } else if (key.equals("UPDATABLE")) {
            c.setUpdatable(false);
        } else if (key.equals("SIGNED")) {
            c.setSigned(false);
        } else if (key.equals("CURRENCY")) {
            c.setSigned(false);
        } else if (key.equals("FIXED_LENGTH")) {
            c.setFixedLength(false);
        } else if (key.equals("SEARCHABLE")) {
            c.setSearchType(null);
        } else if (key.equals("MIN_VALUE")) {
            c.setMinimumValue(null);
        } else if (key.equals("MAX_VALUE")) {
            c.setMaximumValue(null);
        } else if (key.equals("CHAR_OCTET_LENGTH")) {
            c.setCharOctetLength(0);
        } else if (key.equals("NULL_VALUE_COUNT")) {
            c.setNullValues(-1);
        } else if (key.equals("DISTINCT_VALUES")) {
            c.setDistinctValues(-1);
        } else if (key.equals("UDT")) {
            c.setDatatype(null, false, c.getArrayDimensions());
            c.setLength(0);
            c.setPrecision(0);
            c.setScale(0);
        }
    }

    private static void removeProcedureOption(String key, Procedure proc) {
        if (proc.getProperty(key, false) != null) {
            proc.setProperty(key, null);
        }
        OptionsUtil.removeCommonProperty(key, (AbstractMetadataRecord)proc);
        if (key.equals("UPDATECOUNT")) {
            proc.setUpdateCount(1);
        }
    }

    public static void setCommonProperties(AbstractMetadataRecord c, Map<String, String> props) {
        String v = props.remove("UUID");
        if (v != null) {
            c.setUUID(v);
        }
        if ((v = props.remove("ANNOTATION")) != null) {
            c.setAnnotation(v);
        }
        if ((v = props.remove("NAMEINSOURCE")) != null) {
            c.setNameInSource(v);
        }
    }

    private static void removeCommonProperty(String key, AbstractMetadataRecord c) {
        if (key.equals("UUID")) {
            c.setUUID(null);
        } else if (key.equals("ANNOTATION")) {
            c.setAnnotation(null);
        } else if (key.equals("NAMEINSOURCE")) {
            c.setNameInSource(null);
        }
    }

    private static void setTableOptions(Table table) {
        Map props = table.getProperties();
        OptionsUtil.setCommonProperties((AbstractMetadataRecord)table, props);
        String value = (String)props.remove("MATERIALIZED");
        if (value != null) {
            table.setMaterialized(OptionsUtil.isTrue(value));
        }
        if ((value = (String)props.remove("MATERIALIZED_TABLE")) != null) {
            Table mattable = new Table();
            mattable.setName(value);
            table.setMaterializedTable(mattable);
        }
        if ((value = (String)props.remove("UPDATABLE")) != null) {
            table.setSupportsUpdate(OptionsUtil.isTrue(value));
        }
        if ((value = (String)props.remove("CARDINALITY")) != null) {
            table.setCardinality(Long.valueOf(value).longValue());
        }
    }

    private static void removeTableOption(String key, Table table) {
        if (table.getProperty(key, false) != null) {
            table.setProperty(key, null);
        }
        OptionsUtil.removeCommonProperty(key, (AbstractMetadataRecord)table);
        if (key.equals("MATERIALIZED")) {
            table.setMaterialized(false);
        }
        if (key.equals("MATERIALIZED_TABLE")) {
            table.setMaterializedTable(null);
        }
        if (key.equals("UPDATABLE")) {
            table.setSupportsUpdate(false);
        }
        if (key.equals("CARDINALITY")) {
            table.setCardinality(-1);
        }
    }

    private static boolean isTrue(String text) {
        return Boolean.valueOf(text);
    }

    private static void setColumnOptions(BaseColumn c) throws MetadataException {
        Map props = c.getProperties();
        OptionsUtil.setCommonProperties((AbstractMetadataRecord)c, props);
        String v = (String)props.remove("RADIX");
        if (v != null) {
            c.setRadix(Integer.parseInt(v));
        }
        if ((v = (String)props.remove("NATIVE_TYPE")) != null) {
            c.setNativeType(v);
        }
        if (c instanceof Column) {
            OptionsUtil.setColumnOptions((Column)c, props);
        }
    }

    private static void setColumnOptions(Column c, Map<String, String> props) throws MetadataException {
        String v = props.remove("CASE_SENSITIVE");
        if (v != null) {
            c.setCaseSensitive(OptionsUtil.isTrue(v));
        }
        if ((v = props.remove("SELECTABLE")) != null) {
            c.setSelectable(OptionsUtil.isTrue(v));
        }
        if ((v = props.remove("UPDATABLE")) != null) {
            c.setUpdatable(OptionsUtil.isTrue(v));
        }
        if ((v = props.remove("SIGNED")) != null) {
            c.setSigned(OptionsUtil.isTrue(v));
        }
        if ((v = props.remove("CURRENCY")) != null) {
            c.setSigned(OptionsUtil.isTrue(v));
        }
        if ((v = props.remove("FIXED_LENGTH")) != null) {
            c.setFixedLength(OptionsUtil.isTrue(v));
        }
        if ((v = props.remove("SEARCHABLE")) != null) {
            c.setSearchType((Column.SearchType)StringUtil.caseInsensitiveValueOf(Column.SearchType.class, (String)v));
        }
        if ((v = props.remove("MIN_VALUE")) != null) {
            c.setMinimumValue(v);
        }
        if ((v = props.remove("MAX_VALUE")) != null) {
            c.setMaximumValue(v);
        }
        if ((v = props.remove("CHAR_OCTET_LENGTH")) != null) {
            c.setCharOctetLength(Integer.parseInt(v));
        }
        if ((v = props.remove("NULL_VALUE_COUNT")) != null) {
            c.setNullValues(Integer.parseInt(v));
        }
        if ((v = props.remove("DISTINCT_VALUES")) != null) {
            c.setDistinctValues(Integer.parseInt(v));
        }
        if ((v = props.remove("UDT")) != null) {
            Matcher matcher = udtPattern.matcher(v);
            List<Datatype> datatypes = SystemMetadata.getInstance().getDataTypes();
            Datatype match = null;
            if (matcher.matches()) {
                for (Datatype dt : datatypes) {
                    if (!dt.getName().equalsIgnoreCase(matcher.group(1))) continue;
                    match = dt;
                    break;
                }
            }
            if (match != null) {
                c.setDatatype(match, false, c.getArrayDimensions());
                c.setLength(Integer.parseInt(matcher.group(2)));
                SQLParserUtil.ParsedDataType pdt = new SQLParserUtil.ParsedDataType(matcher.group(1), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), true);
                c.setScale(Integer.parseInt(matcher.group(4)));
                SQLParserUtil.setTypeInfo(pdt, (BaseColumn)c);
            } else {
                throw new MetadataException(QueryPlugin.Util.getString("udt_format_wrong", new Object[]{c.getName()}));
            }
        }
    }
}

