/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process.multisource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.dqp.internal.process.multisource.MultiSourceElement;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Table;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.BasicQueryMetadataWrapper;
import org.teiid.query.metadata.QueryMetadataInterface;

public class MultiSourceMetadataWrapper
extends BasicQueryMetadataWrapper {
    public static final String MULTISOURCE_COLUMN_NAME = "multisource.columnName";
    public static final String MULTISOURCE_PARTITIONED_PROPERTY = "teiid_rel:multisource.partitioned";
    private Map<String, String> multiSourceModels;
    private Map<Object, MultiSourceGroup> groups = new ConcurrentHashMap<Object, MultiSourceGroup>();

    public static Map<String, String> getMultiSourceModels(VDBMetaData vdb) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (ModelMetaData mmd : vdb.getModelMetaDatas().values()) {
            if (!mmd.isSupportsMultiSourceBindings()) continue;
            String columnName = mmd.getPropertyValue(MULTISOURCE_COLUMN_NAME);
            if (columnName == null) {
                columnName = "SOURCE_NAME";
            }
            result.put(mmd.getName(), columnName);
        }
        return result;
    }

    public MultiSourceMetadataWrapper(QueryMetadataInterface actualMetadata, Map<String, String> multiSourceModels) {
        super(actualMetadata);
        this.multiSourceModels = multiSourceModels;
    }

    public MultiSourceMetadataWrapper(QueryMetadataInterface metadata, Set<String> multiSourceModels) {
        this(metadata, new HashMap<String, String>());
        for (String string : multiSourceModels) {
            this.multiSourceModels.put(string, "SOURCE_NAME");
        }
    }

    @Override
    public List<?> getElementIDsInGroupID(Object groupID) throws TeiidComponentException, QueryMetadataException {
        MultiSourceGroup msg = this.getMultiSourceGroup(groupID);
        if (msg != null) {
            return msg.columns;
        }
        return this.actualMetadata.getElementIDsInGroupID(groupID);
    }

    public MultiSourceGroup getMultiSourceGroup(Object groupID) throws TeiidComponentException, QueryMetadataException {
        MultiSourceGroup msg = this.groups.get(groupID);
        if (msg != null) {
            return msg;
        }
        if (this.isVirtualGroup(groupID)) {
            return null;
        }
        Object modelId = this.getModelID(groupID);
        String multiSourceElementName = this.multiSourceModels.get(this.getFullName(modelId));
        if (multiSourceElementName == null) {
            return null;
        }
        ArrayList<MultiSourceElement> elements = this.actualMetadata.getElementIDsInGroupID(groupID);
        MultiSourceElement mse = null;
        for (int i = 0; i < elements.size() && mse == null; ++i) {
            Object elemID = elements.get(i);
            if (!this.actualMetadata.getName(elemID).equalsIgnoreCase(multiSourceElementName)) continue;
            if (!this.actualMetadata.getElementRuntimeTypeName(elemID).equalsIgnoreCase("string")) {
                throw new QueryMetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31128, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31128, new Object[]{multiSourceElementName, groupID}));
            }
            mse = (MultiSourceElement)((Object)elemID);
        }
        if (mse == null) {
            ArrayList<MultiSourceElement> result = new ArrayList<MultiSourceElement>(elements);
            MultiSourceElement e = new MultiSourceElement();
            e.setName(multiSourceElementName);
            e.setParent((ColumnSet)((Table)groupID));
            e.setPosition(elements.size() + 1);
            e.setRuntimeType("string");
            MultiSourceMetadataWrapper.setMultiSourceElementMetadata(e);
            result.add(e);
            mse = e;
            elements = result;
        }
        msg = new MultiSourceGroup();
        msg.columns = elements;
        msg.multiSourceElement = mse;
        this.groups.put(groupID, msg);
        return msg;
    }

    public static void setMultiSourceElementMetadata(Column e) {
        e.setNullValues(0);
        e.setNullType(BaseColumn.NullType.No_Nulls);
        e.setSearchType(Column.SearchType.Searchable);
        e.setUpdatable(true);
        e.setLength(255);
    }

    @Override
    public Object getElementID(String elementName) throws TeiidComponentException, QueryMetadataException {
        try {
            return super.getElementID(elementName);
        }
        catch (QueryMetadataException e) {
            int index = elementName.lastIndexOf(46);
            if (index <= 0 || elementName.length() <= index) {
                throw e;
            }
            String group = elementName.substring(0, index);
            elementName = elementName.substring(index + 1, elementName.length());
            MultiSourceGroup msg = this.getMultiSourceGroup(this.getGroupID(group));
            if (msg != null && elementName.equalsIgnoreCase(this.getName(msg.multiSourceElement))) {
                return msg.multiSourceElement;
            }
            throw e;
        }
    }

    @Override
    public boolean isMultiSource(Object modelId) throws QueryMetadataException, TeiidComponentException {
        return this.multiSourceModels.containsKey(this.getFullName(modelId));
    }

    @Override
    public boolean isMultiSourceElement(Object elementId) throws QueryMetadataException, TeiidComponentException {
        if (elementId instanceof MultiSourceElement) {
            return true;
        }
        Object gid = this.getGroupIDForElementID(elementId);
        if (this.isVirtualGroup(gid)) {
            return false;
        }
        Object modelID = this.getModelID(gid);
        String modelName = this.getFullName(modelID);
        String multiSourceColumnName = this.multiSourceModels.get(modelName);
        if (multiSourceColumnName == null) {
            return false;
        }
        return multiSourceColumnName.equalsIgnoreCase(this.getName(elementId));
    }

    @Override
    protected QueryMetadataInterface createDesignTimeMetadata() {
        return new MultiSourceMetadataWrapper(this.actualMetadata.getDesignTimeMetadata(), this.multiSourceModels);
    }

    @Override
    public boolean isPseudo(Object elementId) {
        if (elementId instanceof MultiSourceElement) {
            return true;
        }
        return this.actualMetadata.isPseudo(elementId);
    }

    private static class MultiSourceGroup {
        Object multiSourceElement;
        List<?> columns;

        private MultiSourceGroup() {
        }
    }
}

