/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.eval;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.client.SourceWarning;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.BundleUtil;
import org.teiid.core.ComponentNotFoundException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.BaseClobType;
import org.teiid.core.types.BaseLob;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.JsonType;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.Sequencable;
import org.teiid.core.types.Streamable;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.XMLType;
import org.teiid.core.types.basic.StringToSQLXMLTransform;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.language.Like;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.JSONFunctionMethods;
import org.teiid.query.function.source.XMLHelper;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.AbstractSetCriteria;
import org.teiid.query.sql.lang.CollectionValueIterator;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.ExpressionCriteria;
import org.teiid.query.sql.lang.IsDistinctCriteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.proc.ExceptionExpression;
import org.teiid.query.sql.symbol.Array;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.DerivedExpression;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.JSONObject;
import org.teiid.query.sql.symbol.QueryString;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.TextLine;
import org.teiid.query.sql.symbol.XMLCast;
import org.teiid.query.sql.symbol.XMLElement;
import org.teiid.query.sql.symbol.XMLExists;
import org.teiid.query.sql.symbol.XMLForest;
import org.teiid.query.sql.symbol.XMLNamespaces;
import org.teiid.query.sql.symbol.XMLParse;
import org.teiid.query.sql.symbol.XMLQuery;
import org.teiid.query.sql.symbol.XMLSerialize;
import org.teiid.query.sql.util.ValueIterator;
import org.teiid.query.sql.util.ValueIteratorSource;
import org.teiid.query.sql.util.VariableContext;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.util.CommandContext;
import org.teiid.util.WSUtil;

public class Evaluator {
    public static final char[] REGEX_RESERVED = new char[]{'$', '(', ')', '*', '+', '.', '?', '[', '\\', ']', '^', '{', '|', '}'};
    private static final MatchCriteria.PatternTranslator LIKE_TO_REGEX = new MatchCriteria.PatternTranslator(new char[]{'%', '_'}, new String[]{".*", "."}, REGEX_RESERVED, '\\', 32);
    private static final char[] SIMILAR_REGEX_RESERVED = new char[]{'$', '.', '\\', '^'};
    public static final MatchCriteria.PatternTranslator SIMILAR_TO_REGEX = new MatchCriteria.PatternTranslator(new char[]{'%', '(', ')', '*', '?', '+', '[', ']', '_', '{', '|', '}'}, new String[]{"([a]|[^a])*", "(", ")", "*", "?", "+", "[", "]", "([a]|[^a])", "{", "|", "}"}, SIMILAR_REGEX_RESERVED, '\\', 0);
    protected Map elements;
    protected ProcessorDataManager dataMgr;
    protected CommandContext context;
    private static TextLine.ValueExtractor<NameValuePair<Object>> defaultExtractor = new TextLine.ValueExtractor<NameValuePair<Object>>(){

        @Override
        public Object getValue(NameValuePair<Object> t) {
            return t.value;
        }
    };

    public static boolean evaluate(Criteria criteria) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        return new Evaluator(Collections.emptyMap(), null, null).evaluate(criteria, Collections.emptyList());
    }

    public static Object evaluate(Expression expression) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        return new Evaluator(Collections.emptyMap(), null, null).evaluate(expression, Collections.emptyList());
    }

    public Evaluator(Map elements, ProcessorDataManager dataMgr, CommandContext context) {
        this.context = context;
        this.dataMgr = dataMgr;
        this.elements = elements;
    }

    public void initialize(CommandContext context, ProcessorDataManager dataMgr) {
        this.context = context;
        this.dataMgr = dataMgr;
    }

    public boolean evaluate(Criteria criteria, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        return Boolean.TRUE.equals(this.evaluateTVL(criteria, tuple));
    }

    public Boolean evaluateTVL(Criteria criteria, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        return this.internalEvaluateTVL(criteria, tuple);
    }

    private Boolean internalEvaluateTVL(Criteria criteria, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        if (criteria instanceof CompoundCriteria) {
            return this.evaluate((CompoundCriteria)criteria, tuple);
        }
        if (criteria instanceof NotCriteria) {
            return this.evaluate((NotCriteria)criteria, tuple);
        }
        if (criteria instanceof CompareCriteria) {
            return this.evaluate((CompareCriteria)criteria, tuple);
        }
        if (criteria instanceof MatchCriteria) {
            return this.evaluate((MatchCriteria)criteria, tuple);
        }
        if (criteria instanceof AbstractSetCriteria) {
            return this.evaluate((AbstractSetCriteria)criteria, tuple);
        }
        if (criteria instanceof IsNullCriteria) {
            return this.evaluate((IsNullCriteria)criteria, tuple);
        }
        if (criteria instanceof SubqueryCompareCriteria) {
            return this.evaluate((SubqueryCompareCriteria)criteria, tuple);
        }
        if (criteria instanceof ExistsCriteria) {
            return this.evaluate((ExistsCriteria)criteria, tuple);
        }
        if (criteria instanceof ExpressionCriteria) {
            return (Boolean)this.evaluate(((ExpressionCriteria)criteria).getExpression(), tuple);
        }
        if (criteria instanceof XMLExists) {
            return (Boolean)this.evaluateXMLQuery(tuple, ((XMLExists)criteria).getXmlQuery(), true);
        }
        if (criteria instanceof IsDistinctCriteria) {
            return this.evaluateIsDistinct((IsDistinctCriteria)criteria, tuple);
        }
        throw new ExpressionEvaluationException((BundleUtil.Event)QueryPlugin.Event.TEIID30311, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30311, new Object[]{criteria}));
    }

    private Boolean evaluateIsDistinct(IsDistinctCriteria idc, List<?> tuple) throws AssertionError, ExpressionEvaluationException, BlockedException, TeiidComponentException {
        RowValue left = this.getRowValue(tuple, idc.getLeftRowValue());
        RowValue right = this.getRowValue(tuple, idc.getRightRowValue());
        if (left.length() != right.length()) {
            return !idc.isNegated();
        }
        boolean result = false;
        for (int i = 0; i < left.length(); ++i) {
            Object l = left.get(i);
            Object r = right.get(i);
            if (l == null) {
                if (r == null) continue;
                result = true;
                break;
            }
            if (r == null) {
                result = true;
                break;
            }
            try {
                Boolean b = Evaluator.compare(1, l, r);
                if (b == null || b.booleanValue()) continue;
                result = true;
            }
            catch (Exception e) {
                result = true;
            }
            break;
        }
        if (idc.isNegated()) {
            return !result;
        }
        return result;
    }

    private RowValue getRowValue(final List<?> tuple, final LanguageObject lo) {
        if (lo instanceof GroupSymbol) {
            final GroupSymbol leftRowValue = (GroupSymbol)lo;
            TempMetadataID id = (TempMetadataID)leftRowValue.getMetadataID();
            final VariableContext vc = this.context.getVariableContext();
            final List<TempMetadataID> cols = id.getElements();
            return new RowValue(){

                @Override
                public int length() {
                    return cols.size();
                }

                @Override
                public Object get(int index) {
                    return vc.getValue(new ElementSymbol(((TempMetadataID)cols.get(index)).getName(), leftRowValue));
                }
            };
        }
        return new RowValue(){

            @Override
            public int length() {
                return 1;
            }

            @Override
            public Object get(int index) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
                return Evaluator.this.internalEvaluate((Expression)lo, tuple);
            }
        };
    }

    private Boolean evaluate(CompoundCriteria criteria, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        List<Criteria> subCrits = criteria.getCriteria();
        boolean and = criteria.getOperator() == 0;
        Boolean result = and ? Boolean.TRUE : Boolean.FALSE;
        for (int i = 0; i < subCrits.size(); ++i) {
            Criteria subCrit = subCrits.get(i);
            Boolean value = this.internalEvaluateTVL(subCrit, tuple);
            if (value == null) {
                result = null;
                continue;
            }
            if (!value.booleanValue()) {
                if (!and) continue;
                return Boolean.FALSE;
            }
            if (and) continue;
            return Boolean.TRUE;
        }
        return result;
    }

    private Boolean evaluate(NotCriteria criteria, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        Criteria subCrit = criteria.getCriteria();
        Boolean result = this.internalEvaluateTVL(subCrit, tuple);
        if (result == null) {
            return null;
        }
        if (result.booleanValue()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean evaluate(CompareCriteria criteria, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        Object leftValue = null;
        try {
            leftValue = this.evaluate(criteria.getLeftExpression(), tuple);
        }
        catch (ExpressionEvaluationException e) {
            throw new ExpressionEvaluationException(QueryPlugin.Event.TEIID30312, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30312, new Object[]{"left", criteria}));
        }
        if (leftValue == null) {
            return null;
        }
        Object rightValue = null;
        try {
            rightValue = this.evaluate(criteria.getRightExpression(), tuple);
        }
        catch (ExpressionEvaluationException e) {
            throw new ExpressionEvaluationException(QueryPlugin.Event.TEIID30312, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30312, new Object[]{"right", criteria}));
        }
        if (rightValue == null) {
            return null;
        }
        return Evaluator.compare(criteria.getOperator(), leftValue, rightValue);
    }

    private Boolean evaluate(MatchCriteria criteria, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        boolean result = false;
        Object value = null;
        try {
            value = this.evaluate(criteria.getLeftExpression(), tuple);
        }
        catch (ExpressionEvaluationException e) {
            throw new ExpressionEvaluationException(QueryPlugin.Event.TEIID30312, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30312, new Object[]{"left", criteria}));
        }
        if (value == null) {
            return null;
        }
        CharSequence leftValue = null;
        if (value instanceof CharSequence) {
            leftValue = (CharSequence)value;
        } else {
            try {
                leftValue = ((Sequencable)value).getCharSequence();
            }
            catch (SQLException err) {
                throw new ExpressionEvaluationException(QueryPlugin.Event.TEIID30316, err, err.getMessage());
            }
        }
        String rightValue = null;
        try {
            rightValue = (String)this.evaluate(criteria.getRightExpression(), tuple);
        }
        catch (ExpressionEvaluationException e) {
            throw new ExpressionEvaluationException(QueryPlugin.Event.TEIID30312, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30312, new Object[]{"right", criteria}));
        }
        if (rightValue == null) {
            return null;
        }
        result = this.match(rightValue, criteria.getEscapeChar(), leftValue, criteria.getMode());
        return result ^ criteria.isNegated();
    }

    private boolean match(String pattern, char escape, CharSequence search, Like.MatchMode mode) throws ExpressionEvaluationException {
        Pattern patternRegex = null;
        switch (mode) {
            case LIKE: {
                patternRegex = LIKE_TO_REGEX.translate(pattern, escape);
                break;
            }
            case SIMILAR: {
                patternRegex = SIMILAR_TO_REGEX.translate(pattern, escape);
                break;
            }
            case REGEX: {
                patternRegex = MatchCriteria.getPattern(pattern, pattern, 0);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        Matcher matcher = patternRegex.matcher(search);
        return matcher.find();
    }

    private Boolean evaluate(AbstractSetCriteria criteria, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        Object leftValue = null;
        try {
            leftValue = this.evaluate(criteria.getExpression(), tuple);
        }
        catch (ExpressionEvaluationException e) {
            throw new ExpressionEvaluationException(QueryPlugin.Event.TEIID30323, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30323, new Object[]{criteria}));
        }
        Boolean result = Boolean.FALSE;
        ValueIterator valueIter = null;
        if (criteria instanceof SetCriteria) {
            SetCriteria set = (SetCriteria)criteria;
            if (leftValue == null) {
                if (!set.getValues().isEmpty()) {
                    return null;
                }
                return criteria.isNegated();
            }
            if (set.isAllConstants()) {
                boolean exists = set.getValues().contains(new Constant(leftValue, criteria.getExpression().getType()));
                if (!exists) {
                    if (set.getValues().contains(Constant.NULL_CONSTANT)) {
                        return null;
                    }
                    return criteria.isNegated();
                }
                return !criteria.isNegated();
            }
            valueIter = new CollectionValueIterator(((SetCriteria)criteria).getValues());
        } else {
            if (criteria instanceof DependentSetCriteria) {
                Set<Object> values;
                DependentSetCriteria ref = (DependentSetCriteria)criteria;
                VariableContext vc = this.getContext(criteria).getVariableContext();
                ValueIteratorSource vis = (ValueIteratorSource)vc.getGlobalValue(ref.getContextSymbol());
                if (leftValue == null) {
                    return null;
                }
                try {
                    values = vis.getCachedSet(ref.getValueExpression());
                }
                catch (TeiidProcessingException e) {
                    throw new ExpressionEvaluationException(e);
                }
                if (values != null) {
                    return values.contains(leftValue);
                }
                vis.setUnused(true);
                return true;
            }
            if (criteria instanceof SubquerySetCriteria) {
                try {
                    valueIter = this.evaluateSubquery((SubquerySetCriteria)criteria, tuple);
                }
                catch (TeiidProcessingException e) {
                    throw new ExpressionEvaluationException(e);
                }
            } else {
                throw new AssertionError((Object)"unknown set criteria type");
            }
        }
        while (valueIter.hasNext()) {
            if (leftValue == null) {
                return null;
            }
            Object possibleValue = valueIter.next();
            Object value = null;
            if (possibleValue instanceof Expression) {
                try {
                    value = this.evaluate((Expression)possibleValue, tuple);
                }
                catch (ExpressionEvaluationException e) {
                    throw new ExpressionEvaluationException(QueryPlugin.Event.TEIID30323, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30323, new Object[]{possibleValue}));
                }
            } else {
                value = possibleValue;
            }
            if (value != null) {
                if (Constant.COMPARATOR.compare(leftValue, value) != 0) continue;
                return !criteria.isNegated();
            }
            result = null;
        }
        if (result == null) {
            return null;
        }
        return criteria.isNegated();
    }

    private boolean evaluate(IsNullCriteria criteria, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        Object value = null;
        try {
            value = this.evaluate(criteria.getExpression(), tuple);
        }
        catch (ExpressionEvaluationException e) {
            throw new ExpressionEvaluationException(QueryPlugin.Event.TEIID30323, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30323, new Object[]{criteria}));
        }
        return value == null ^ criteria.isNegated();
    }

    private Boolean evaluate(SubqueryCompareCriteria criteria, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        ValueIterator valueIter;
        Object leftValue = null;
        try {
            leftValue = this.evaluate(criteria.getLeftExpression(), tuple);
        }
        catch (ExpressionEvaluationException e) {
            throw new ExpressionEvaluationException(QueryPlugin.Event.TEIID30323, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30323, new Object[]{criteria}));
        }
        Boolean result = Boolean.FALSE;
        if (criteria.getPredicateQuantifier() == 4) {
            result = Boolean.TRUE;
        }
        if (criteria.getCommand() != null) {
            try {
                valueIter = this.evaluateSubquery(criteria, tuple);
            }
            catch (TeiidProcessingException e) {
                throw new ExpressionEvaluationException(e);
            }
        } else {
            Object[] vals;
            Object array = this.evaluate(criteria.getArrayExpression(), tuple);
            if (array instanceof Object[]) {
                vals = (Object[])array;
            } else if (array != null) {
                ArrayImpl arrayImpl = (ArrayImpl)array;
                vals = arrayImpl.getValues();
            } else {
                return result;
            }
            valueIter = new ValueIterator(){
                int index = 0;

                @Override
                public void reset() {
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.index < vals.length;
                }

                @Override
                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return vals[this.index++];
                }
            };
        }
        block12: while (valueIter.hasNext()) {
            Object value = valueIter.next();
            if (leftValue == null) {
                return null;
            }
            if (value != null) {
                Boolean comp = Evaluator.compare(criteria.getOperator(), leftValue, value);
                switch (criteria.getPredicateQuantifier()) {
                    case 4: {
                        if (!Boolean.FALSE.equals(comp)) continue block12;
                        return Boolean.FALSE;
                    }
                    case 2: {
                        if (!Boolean.TRUE.equals(comp)) continue block12;
                        return Boolean.TRUE;
                    }
                    default: {
                        throw new ExpressionEvaluationException((BundleUtil.Event)QueryPlugin.Event.TEIID30326, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30326, new Object[]{criteria.getPredicateQuantifier()}));
                    }
                }
            }
            switch (criteria.getPredicateQuantifier()) {
                case 4: {
                    if (!Boolean.TRUE.equals(result)) continue block12;
                    result = null;
                    continue block12;
                }
                case 2: {
                    if (!Boolean.FALSE.equals(result)) continue block12;
                    result = null;
                    continue block12;
                }
            }
            throw new ExpressionEvaluationException((BundleUtil.Event)QueryPlugin.Event.TEIID30326, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30326, new Object[]{criteria.getPredicateQuantifier()}));
        }
        return result;
    }

    public static Boolean compare(int operator, Object leftValue, Object value) throws AssertionError {
        int compare = 0;
        if (leftValue instanceof ArrayImpl) {
            ArrayImpl av = (ArrayImpl)leftValue;
            try {
                compare = av.compareTo((ArrayImpl)value, true, Constant.COMPARATOR);
            }
            catch (ArrayImpl.NullException e) {
                return null;
            }
        } else {
            compare = Constant.COMPARATOR.compare(leftValue, value);
        }
        Boolean result = null;
        switch (operator) {
            case 1: {
                result = compare == 0;
                break;
            }
            case 2: {
                result = compare != 0;
                break;
            }
            case 3: {
                result = compare < 0;
                break;
            }
            case 5: {
                result = compare <= 0;
                break;
            }
            case 4: {
                result = compare > 0;
                break;
            }
            case 6: {
                result = compare >= 0;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return result;
    }

    private boolean evaluate(ExistsCriteria criteria, List<?> tuple) throws BlockedException, TeiidComponentException, ExpressionEvaluationException {
        ValueIterator valueIter;
        try {
            valueIter = this.evaluateSubquery(criteria, tuple);
        }
        catch (TeiidProcessingException e) {
            throw new ExpressionEvaluationException(e);
        }
        if (valueIter.hasNext()) {
            return !criteria.isNegated();
        }
        return criteria.isNegated();
    }

    public Object evaluate(Expression expression, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        try {
            return this.internalEvaluate(expression, tuple);
        }
        catch (ExpressionEvaluationException e) {
            throw new ExpressionEvaluationException(QueryPlugin.Event.TEIID30328, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30328, new Object[]{expression, e.getMessage()}));
        }
    }

    protected Object internalEvaluate(Expression expression, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        if (expression instanceof DerivedExpression) {
            Integer index;
            if (this.elements != null && (index = (Integer)this.elements.get(expression)) != null) {
                return tuple.get(index);
            }
            if (expression instanceof ExpressionSymbol) {
                ExpressionSymbol exprSyb = (ExpressionSymbol)expression;
                Expression expr = exprSyb.getExpression();
                return this.internalEvaluate(expr, tuple);
            }
            return this.getContext(expression).getFromContext(expression);
        }
        if (expression instanceof Constant) {
            Constant c = (Constant)expression;
            if (c.isMultiValued()) {
                throw new AssertionError((Object)"Multi-valued constant not allowed to be directly evaluated");
            }
            return c.getValue();
        }
        if (expression instanceof Function) {
            return this.evaluate((Function)expression, tuple);
        }
        if (expression instanceof CaseExpression) {
            return this.evaluate((CaseExpression)expression, tuple);
        }
        if (expression instanceof SearchedCaseExpression) {
            return this.evaluate((SearchedCaseExpression)expression, tuple);
        }
        if (expression instanceof Reference) {
            Reference ref = (Reference)expression;
            if (ref.isPositional() && ref.getExpression() == null) {
                return this.getContext(ref).getVariableContext().getGlobalValue(ref.getContextSymbol());
            }
            Object result = this.getContext(ref.getExpression()).getFromContext(ref.getExpression());
            if (ref.getConstraint() != null) {
                try {
                    ref.getConstraint().validate(result);
                }
                catch (QueryValidatorException e) {
                    throw new ExpressionEvaluationException((Throwable)((Object)e));
                }
            }
            return result;
        }
        if (expression instanceof Criteria) {
            return this.evaluate((Criteria)expression, tuple);
        }
        if (expression instanceof ScalarSubquery) {
            return this.evaluate((ScalarSubquery)expression, tuple);
        }
        if (expression instanceof Criteria) {
            return this.evaluate((Criteria)expression, tuple);
        }
        if (expression instanceof TextLine) {
            return this.evaluateTextLine(tuple, (TextLine)expression);
        }
        if (expression instanceof XMLElement) {
            return this.evaluateXMLElement(tuple, (XMLElement)expression);
        }
        if (expression instanceof XMLForest) {
            return this.evaluateXMLForest(tuple, (XMLForest)expression);
        }
        if (expression instanceof JSONObject) {
            return this.evaluateJSONObject(tuple, (JSONObject)expression, null);
        }
        if (expression instanceof XMLSerialize) {
            return this.evaluateXMLSerialize(tuple, (XMLSerialize)expression);
        }
        if (expression instanceof XMLQuery) {
            return this.evaluateXMLQuery(tuple, (XMLQuery)expression, false);
        }
        if (expression instanceof QueryString) {
            return this.evaluateQueryString(tuple, (QueryString)expression);
        }
        if (expression instanceof XMLParse) {
            return this.evaluateXMLParse(tuple, (XMLParse)expression);
        }
        if (expression instanceof Array) {
            Array array = (Array)expression;
            List<Expression> exprs = array.getExpressions();
            Object[] result = (Object[])java.lang.reflect.Array.newInstance(array.getComponentType(), exprs.size());
            for (int i = 0; i < exprs.size(); ++i) {
                Object[] eval = this.internalEvaluate(exprs.get(i), tuple);
                if (eval instanceof ArrayImpl) {
                    eval = ((ArrayImpl)eval).getValues();
                }
                result[i] = eval;
            }
            return new ArrayImpl(result);
        }
        if (expression instanceof ExceptionExpression) {
            return this.evaluate(tuple, (ExceptionExpression)expression);
        }
        if (expression instanceof XMLCast) {
            return this.evaluate(tuple, (XMLCast)expression);
        }
        throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30329, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30329, new Object[]{expression.getClass().getName()}));
    }

    private Object evaluate(List<?> tuple, XMLCast expression) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        Object val = this.internalEvaluate(expression.getExpression(), tuple);
        if (val == null) {
            return new Constant(null, expression.getType());
        }
        return XMLHelper.getInstance().evaluate((XMLType)val, expression, this.context);
    }

    private Object evaluate(List<?> tuple, ExceptionExpression ee) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        String msg = (String)this.internalEvaluate(ee.getMessage(), tuple);
        String sqlState = ee.getDefaultSQLState();
        if (ee.getSqlState() != null) {
            sqlState = (String)this.internalEvaluate(ee.getSqlState(), tuple);
        }
        Integer errorCode = null;
        if (ee.getErrorCode() != null) {
            errorCode = (Integer)this.internalEvaluate(ee.getErrorCode(), tuple);
        }
        Exception parent = null;
        if (ee.getParent() != null) {
            parent = (Exception)this.internalEvaluate(ee.getParent(), tuple);
        }
        TeiidSQLException result = new TeiidSQLException((Throwable)parent, msg, sqlState, errorCode != null ? errorCode : 0);
        result.setStackTrace(SourceWarning.EMPTY_STACK_TRACE);
        return result;
    }

    private Object evaluateXMLParse(List<?> tuple, XMLParse xp) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        Object value = this.internalEvaluate(xp.getExpression(), tuple);
        if (value == null) {
            return null;
        }
        XMLType.Type type = XMLType.Type.DOCUMENT;
        SQLXMLImpl result = null;
        try {
            String string;
            if (value instanceof String) {
                string = (String)value;
                result = new SQLXMLImpl(string);
                result.setCharset(Streamable.CHARSET);
                if (!xp.isWellFormed()) {
                    StringReader r = new StringReader(string);
                    type = this.validate(xp, r);
                }
            } else if (value instanceof BinaryType) {
                string = (BinaryType)value;
                result = new SQLXMLImpl(string.getBytesDirect());
                result.setCharset(Streamable.CHARSET);
                if (!xp.isWellFormed()) {
                    Reader r = result.getCharacterStream();
                    type = this.validate(xp, r);
                }
            } else {
                InputStreamFactory isf = null;
                Streamable s = (Streamable)value;
                isf = Evaluator.getInputStreamFactory(s);
                result = new SQLXMLImpl(isf);
                if (!xp.isWellFormed()) {
                    Reader r = result.getCharacterStream();
                    type = this.validate(xp, r);
                }
            }
        }
        catch (TransformationException e) {
            throw new ExpressionEvaluationException(e);
        }
        catch (SQLException e) {
            throw new ExpressionEvaluationException(QueryPlugin.Event.TEIID30331, e, e.getMessage());
        }
        if (!xp.isDocument()) {
            type = XMLType.Type.CONTENT;
        }
        XMLType xml = new XMLType((SQLXML)result);
        xml.setType(type);
        return xml;
    }

    public static InputStreamFactory getInputStreamFactory(Streamable<?> s) {
        if (s.getReference() instanceof Streamable) {
            return Evaluator.getInputStreamFactory((Streamable)s.getReference());
        }
        if (s.getReference() instanceof BaseLob) {
            BaseLob bl = (BaseLob)s.getReference();
            try {
                InputStreamFactory isf = bl.getStreamFactory();
                if (isf != null) {
                    return isf;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (s instanceof BaseClobType) {
            return new InputStreamFactory.ClobInputStreamFactory((Clob)s.getReference());
        }
        if (s instanceof BlobType) {
            return new InputStreamFactory.BlobInputStreamFactory((Blob)s.getReference());
        }
        return new InputStreamFactory.SQLXMLInputStreamFactory((SQLXML)s.getReference());
    }

    private XMLType.Type validate(XMLParse xp, Reader r) throws TransformationException {
        if (!xp.isDocument()) {
            LinkedList<Reader> readers = new LinkedList<Reader>();
            readers.add(new StringReader("<r>"));
            readers.add(r);
            readers.add(new StringReader("</r>"));
            r = new SequenceReader(readers);
        }
        return StringToSQLXMLTransform.isXml((Reader)r);
    }

    private Object evaluateQueryString(List<?> tuple, QueryString queryString) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        NameValuePair<Object>[] pairs = this.getNameValuePairs(tuple, queryString.getArgs(), false, true);
        String path = (String)this.internalEvaluate(queryString.getPath(), tuple);
        if (path == null) {
            path = "";
        }
        boolean appendedAny = false;
        StringBuilder result = new StringBuilder();
        for (NameValuePair<Object> nameValuePair : pairs) {
            if (nameValuePair.value == null) continue;
            if (appendedAny) {
                result.append('&');
            }
            appendedAny = true;
            result.append(WSUtil.httpURLEncode((String)nameValuePair.name)).append('=').append(WSUtil.httpURLEncode((String)((String)nameValuePair.value)));
        }
        if (!appendedAny) {
            return path;
        }
        result.insert(0, '?');
        result.insert(0, path);
        return result.toString();
    }

    private Object evaluateXMLQuery(List<?> tuple, XMLQuery xmlQuery, boolean exists) throws BlockedException, TeiidComponentException, FunctionExecutionException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        try {
            this.evaluateParameters(xmlQuery.getPassing(), tuple, parameters);
        }
        catch (ExpressionEvaluationException e) {
            throw new FunctionExecutionException(QueryPlugin.Event.TEIID30333, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30333, new Object[]{e.getMessage()}));
        }
        return XMLHelper.getInstance().evaluateXMLQuery(tuple, xmlQuery, exists, parameters, this.context);
    }

    private Object evaluateXMLSerialize(List<?> tuple, XMLSerialize xs) throws ExpressionEvaluationException, BlockedException, TeiidComponentException, FunctionExecutionException {
        XMLType value = (XMLType)this.internalEvaluate(xs.getExpression(), tuple);
        if (value == null) {
            return null;
        }
        try {
            if (!xs.isDocument()) {
                return XMLSystemFunctions.serialize(xs, value);
            }
            if (value.getType() == XMLType.Type.UNKNOWN) {
                XMLType.Type type = StringToSQLXMLTransform.isXml((Reader)value.getCharacterStream());
                value.setType(type);
            }
            if (value.getType() == XMLType.Type.DOCUMENT || value.getType() == XMLType.Type.ELEMENT) {
                return XMLSystemFunctions.serialize(xs, value);
            }
        }
        catch (SQLException e) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID30334, e);
        }
        catch (TransformationException e) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID30335, e);
        }
        throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID30336, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30336, new Object[0]));
    }

    private Object evaluateTextLine(List<?> tuple, TextLine function) throws ExpressionEvaluationException, BlockedException, TeiidComponentException, FunctionExecutionException {
        List<DerivedColumn> args = function.getExpressions();
        NameValuePair<Object>[] nameValuePairs = this.getNameValuePairs(tuple, args, false, true);
        try {
            return new ArrayImpl((Object[])TextLine.evaluate(Arrays.asList(nameValuePairs), defaultExtractor, function));
        }
        catch (TransformationException e) {
            throw new ExpressionEvaluationException(e);
        }
        catch (TeiidProcessingException e) {
            throw new ExpressionEvaluationException(e);
        }
    }

    private Object evaluateXMLForest(List<?> tuple, XMLForest function) throws ExpressionEvaluationException, BlockedException, TeiidComponentException, FunctionExecutionException {
        List<DerivedColumn> args = function.getArgs();
        NameValuePair[] nameValuePairs = this.getNameValuePairs(tuple, args, true, true);
        try {
            return XMLSystemFunctions.xmlForest(this.context, this.namespaces(function.getNamespaces()), nameValuePairs);
        }
        catch (TeiidProcessingException e) {
            throw new FunctionExecutionException(e);
        }
    }

    private JsonType evaluateJSONObject(List<?> tuple, JSONObject function, JSONFunctionMethods.JSONBuilder builder) throws ExpressionEvaluationException, BlockedException, TeiidComponentException, FunctionExecutionException {
        List<DerivedColumn> args = function.getArgs();
        NameValuePair<Object>[] nameValuePairs = this.getNameValuePairs(tuple, args, false, false);
        boolean returnValue = false;
        try {
            JsonType result;
            if (builder == null) {
                returnValue = true;
                for (SubqueryContainer subqueryContainer : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(function)) {
                    this.evaluateSubquery(subqueryContainer, tuple);
                }
                builder = new JSONFunctionMethods.JSONBuilder(this.context.getBufferManager());
            }
            builder.start(false);
            for (NameValuePair<Object> nameValuePair : nameValuePairs) {
                this.addValue(tuple, builder, nameValuePair.name, nameValuePair.value);
            }
            builder.end(false);
            if (returnValue) {
                result = builder.close(this.context);
                builder = null;
                JsonType jsonType = result;
                return jsonType;
            }
            result = null;
            return result;
        }
        catch (TeiidProcessingException e) {
            throw new FunctionExecutionException(e);
        }
        finally {
            if (returnValue && builder != null) {
                builder.remove();
            }
        }
    }

    private void addValue(List<?> tuple, JSONFunctionMethods.JSONBuilder builder, String name, Object value) throws TeiidProcessingException, ExpressionEvaluationException, BlockedException, TeiidComponentException, FunctionExecutionException {
        Function f;
        if (value instanceof JSONObject) {
            builder.startValue(name);
            this.evaluateJSONObject(tuple, (JSONObject)value, builder);
            return;
        }
        if (value instanceof Function && (f = (Function)value).getName().equalsIgnoreCase("jsonarray")) {
            builder.startValue(name);
            Evaluator.jsonArray(this.context, f, f.getArgs(), builder, this, tuple);
            return;
        }
        builder.addValue(name, this.internalEvaluate((Expression)value, tuple));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonType jsonArray(CommandContext context, Function f, Object[] vals, JSONFunctionMethods.JSONBuilder builder, Evaluator eval, List<?> tuple) throws TeiidProcessingException, BlockedException, TeiidComponentException {
        boolean returnValue = false;
        try {
            if (builder == null) {
                returnValue = true;
                if (eval != null) {
                    for (SubqueryContainer subqueryContainer : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(f)) {
                        eval.evaluateSubquery(subqueryContainer, tuple);
                    }
                }
                builder = new JSONFunctionMethods.JSONBuilder(context.getBufferManager());
            }
            builder.start(true);
            for (Object object : vals) {
                if (eval != null) {
                    eval.addValue(tuple, builder, null, object);
                    continue;
                }
                builder.addValue(object);
            }
            builder.end(true);
            if (returnValue) {
                JsonType result = builder.close(context);
                builder = null;
                JsonType jsonType = result;
                return jsonType;
            }
            Object var7_7 = null;
            return var7_7;
        }
        finally {
            if (returnValue && builder != null) {
                builder.remove();
            }
        }
    }

    private Object evaluateXMLElement(List<?> tuple, XMLElement function) throws ExpressionEvaluationException, BlockedException, TeiidComponentException, FunctionExecutionException {
        List<Expression> content = function.getContent();
        ArrayList<Object> values = new ArrayList<Object>(content.size());
        for (Expression exp : content) {
            values.add(this.internalEvaluate(exp, tuple));
        }
        try {
            NameValuePair<Object>[] attributes = null;
            if (function.getAttributes() != null) {
                attributes = this.getNameValuePairs(tuple, function.getAttributes().getArgs(), true, true);
            }
            return XMLSystemFunctions.xmlElement(this.context, function.getName(), this.namespaces(function.getNamespaces()), attributes, values);
        }
        catch (TeiidProcessingException e) {
            throw new FunctionExecutionException(e);
        }
    }

    public void evaluateParameters(List<DerivedColumn> cols, List<?> tuple, Map<String, Object> parameters) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        for (DerivedColumn passing : cols) {
            Object value = this.evaluateParameter(tuple, passing);
            if (passing.getAlias() == null) {
                parameters.put(null, value);
                continue;
            }
            parameters.put(passing.getAlias(), value);
        }
    }

    private Object evaluateParameter(List<?> tuple, DerivedColumn passing) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        if (passing.getExpression() instanceof Function) {
            Function f = (Function)passing.getExpression();
            if (f.getName().equalsIgnoreCase("jsontoxml")) {
                String rootName = (String)this.evaluate(f.getArg(0), tuple);
                Object lob = this.evaluate(f.getArg(1), tuple);
                if (rootName == null || lob == null) {
                    return null;
                }
                try {
                    if (lob instanceof Blob) {
                        return XMLSystemFunctions.jsonToXml(this.context, rootName, (Blob)lob, true);
                    }
                    return XMLSystemFunctions.jsonToXml(this.context, rootName, (Clob)lob, true);
                }
                catch (IOException e) {
                    throw new FunctionExecutionException(QueryPlugin.Event.TEIID30384, e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30384, new Object[]{f.getFunctionDescriptor().getName()}));
                }
                catch (SQLException e) {
                    throw new FunctionExecutionException(QueryPlugin.Event.TEIID30384, e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30384, new Object[]{f.getFunctionDescriptor().getName()}));
                }
                catch (TeiidProcessingException e) {
                    throw new FunctionExecutionException(QueryPlugin.Event.TEIID30384, e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30384, new Object[]{f.getFunctionDescriptor().getName()}));
                }
            }
        } else if (passing.getExpression() instanceof XMLParse) {
            XMLParse xmlParse = (XMLParse)passing.getExpression();
            xmlParse.setWellFormed(true);
        }
        Object value = this.evaluate(passing.getExpression(), tuple);
        return value;
    }

    private NameValuePair<Object>[] getNameValuePairs(List<?> tuple, List<DerivedColumn> args, boolean xmlNames, boolean eval) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        NameValuePair[] nameValuePairs = new NameValuePair[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            DerivedColumn symbol = args.get(i);
            String name = symbol.getAlias();
            Expression ex = symbol.getExpression();
            if (name == null && ex instanceof ElementSymbol) {
                name = ((ElementSymbol)ex).getShortName();
            }
            if (name != null) {
                if (xmlNames) {
                    name = XMLHelper.getInstance().escapeName(name, true);
                }
            } else if (!xmlNames) {
                name = "expr" + (i + 1);
            }
            nameValuePairs[i] = new NameValuePair<Expression>(name, (Expression)(eval ? this.internalEvaluate(ex, tuple) : ex));
        }
        return nameValuePairs;
    }

    private NameValuePair<String>[] namespaces(XMLNamespaces namespaces) {
        if (namespaces == null) {
            return null;
        }
        List<XMLNamespaces.NamespaceItem> args = namespaces.getNamespaceItems();
        NameValuePair[] nameValuePairs = new NameValuePair[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            XMLNamespaces.NamespaceItem item = args.get(i);
            nameValuePairs[i] = new NameValuePair<String>(item.getPrefix(), item.getUri());
        }
        return nameValuePairs;
    }

    private Object evaluate(CaseExpression expr, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        Object exprVal = this.internalEvaluate(expr.getExpression(), tuple);
        for (int i = 0; i < expr.getWhenCount(); ++i) {
            if (!EquivalenceUtil.areEqual((Object)exprVal, (Object)this.internalEvaluate(expr.getWhenExpression(i), tuple))) continue;
            return this.internalEvaluate(expr.getThenExpression(i), tuple);
        }
        if (expr.getElseExpression() != null) {
            return this.internalEvaluate(expr.getElseExpression(), tuple);
        }
        return null;
    }

    private Object evaluate(SearchedCaseExpression expr, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        for (int i = 0; i < expr.getWhenCount(); ++i) {
            if (!this.evaluate(expr.getWhenCriteria(i), tuple)) continue;
            return this.internalEvaluate(expr.getThenExpression(i), tuple);
        }
        if (expr.getElseExpression() != null) {
            return this.internalEvaluate(expr.getElseExpression(), tuple);
        }
        return null;
    }

    private Object evaluate(Function function, List<?> tuple) throws BlockedException, TeiidComponentException, ExpressionEvaluationException {
        FunctionDescriptor fd = function.getFunctionDescriptor();
        Expression[] args = function.getArgs();
        Object[] values = null;
        int start = 0;
        if (fd.requiresContext()) {
            values = new Object[args.length + 1];
            values[0] = this.context;
            start = 1;
        } else {
            values = new Object[args.length];
        }
        for (int i = 0; i < args.length; ++i) {
            values[i + start] = this.internalEvaluate(args[i], tuple);
            if (values[i + start] instanceof Constant) {
                throw new AssertionError((Object)"Multi-valued constant not allowed to be directly evaluated");
            }
        }
        if (fd.getPushdown() == FunctionMethod.PushDown.MUST_PUSHDOWN) {
            try {
                return this.evaluatePushdown(function, tuple, values);
            }
            catch (TeiidProcessingException e) {
                throw new ExpressionEvaluationException(e);
            }
        }
        if (fd.getProcedure() != null) {
            try {
                return this.evaluateProcedure(function, tuple, values);
            }
            catch (TeiidProcessingException e) {
                throw new ExpressionEvaluationException(e);
            }
        }
        if (function.getName().equalsIgnoreCase("lookup")) {
            if (this.dataMgr == null) {
                throw new ComponentNotFoundException((BundleUtil.Event)QueryPlugin.Event.TEIID30342, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30342, new Object[0]));
            }
            String codeTableName = (String)values[0];
            String returnElementName = (String)values[1];
            String keyElementName = (String)values[2];
            try {
                return this.dataMgr.lookupCodeValue(this.context, codeTableName, returnElementName, keyElementName, values[3]);
            }
            catch (TeiidProcessingException e) {
                throw new ExpressionEvaluationException(e);
            }
        }
        return fd.invokeFunction(values, this.context, null, function.isCalledWithVarArgArrayParam());
    }

    protected Object evaluatePushdown(Function function, List<?> tuple, Object[] values) throws FunctionExecutionException, TeiidComponentException, TeiidProcessingException {
        throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID30341, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30341, new Object[]{function.getFunctionDescriptor().getFullName()}));
    }

    private Object evaluate(ScalarSubquery scalarSubquery, List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        ValueIterator valueIter;
        Object result = null;
        try {
            valueIter = this.evaluateSubquery(scalarSubquery, tuple);
        }
        catch (TeiidProcessingException e) {
            throw new ExpressionEvaluationException(e);
        }
        if (valueIter.hasNext()) {
            result = valueIter.next();
            if (valueIter.hasNext()) {
                throw new ExpressionEvaluationException((BundleUtil.Event)QueryPlugin.Event.TEIID30345, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30345, new Object[]{scalarSubquery.getCommand()}));
            }
        }
        return result;
    }

    protected ValueIterator evaluateSubquery(SubqueryContainer<?> container, List<?> tuple) throws TeiidProcessingException, BlockedException, TeiidComponentException {
        throw new UnsupportedOperationException("Subquery evaluation not possible with a base Evaluator");
    }

    private CommandContext getContext(LanguageObject expression) throws TeiidComponentException {
        if (this.context == null) {
            throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30328, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30328, new Object[]{expression, QueryPlugin.Util.getString("Evaluator.no_value")}));
        }
        return this.context;
    }

    protected Object evaluateProcedure(Function function, List<?> tuple, Object[] values) throws TeiidComponentException, TeiidProcessingException {
        throw new UnsupportedOperationException("Procedure evaluation not possible with a base Evaluator");
    }

    private static interface RowValue {
        public Object get(int var1) throws ExpressionEvaluationException, BlockedException, TeiidComponentException;

        public int length();
    }

    public static class NameValuePair<T> {
        public String name;
        public T value;

        public NameValuePair(String name, T value) {
            this.name = name;
            this.value = value;
        }
    }

    private final class SequenceReader
    extends Reader {
        private LinkedList<Reader> readers;
        private Reader current = null;

        public SequenceReader(LinkedList<Reader> readers) {
            this.readers = readers;
        }

        @Override
        public void close() throws IOException {
            for (Reader reader : this.readers) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int nextRead;
            if (this.current == null && !this.readers.isEmpty()) {
                this.current = this.readers.removeFirst();
            }
            if (this.current == null) {
                return -1;
            }
            int read = this.current.read(cbuf, off, len);
            if (read == -1) {
                this.current.close();
                this.current = null;
                read = 0;
            }
            if (read < len && (nextRead = this.read(cbuf, off + read, len - read)) > 0) {
                read += nextRead;
            }
            return read;
        }
    }
}

