/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.RulePushLimit;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.MergeJoinStrategy;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.util.CommandContext;

public class RulePlanSorts
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        return this.optimizeSorts(false, plan, plan, metadata, capabilitiesFinder, analysisRecord, context);
    }

    private PlanNode optimizeSorts(boolean parentBlocking, PlanNode node, PlanNode root, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord record, CommandContext context) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        if ((node = NodeEditor.findNodePreOrder((PlanNode)node, 422, 1)) == null) {
            return root;
        }
        switch (((PlanNode)node).getType()) {
            case 32: {
                parentBlocking = true;
                if (((PlanNode)node).hasBooleanProperty(NodeConstants.Info.IS_DUP_REMOVAL)) break;
                if (this.mergeSortWithDupRemoval((PlanNode)node)) {
                    ((PlanNode)node).setProperty(NodeConstants.Info.IS_DUP_REMOVAL, true);
                } else {
                    root = RulePlanSorts.checkForProjectOptimization((PlanNode)node, root, metadata, capFinder, record, context);
                    if (NodeEditor.findParent((PlanNode)node, 1) != null) {
                        return root;
                    }
                }
                OrderBy orderBy = (OrderBy)((PlanNode)node).getProperty(NodeConstants.Info.SORT_ORDER);
                List<Expression> orderColumns = orderBy.getSortKeys();
                ArrayList<Expression> sortExpressions = new ArrayList<Expression>(orderColumns.size());
                PlanNode possibleSort = NodeEditor.findNodePreOrder((PlanNode)node, 128, 65);
                if (possibleSort == null || possibleSort.hasBooleanProperty(NodeConstants.Info.ROLLUP)) break;
                boolean otherExpression = false;
                SymbolMap groupMap = (SymbolMap)possibleSort.getProperty(NodeConstants.Info.SYMBOL_MAP);
                for (Expression singleElementSymbol : orderColumns) {
                    Expression ex = SymbolMap.getExpression(singleElementSymbol);
                    if (ex instanceof ElementSymbol) {
                        sortExpressions.add(groupMap.getMappedExpression((ElementSymbol)ex));
                        continue;
                    }
                    otherExpression = true;
                    break;
                }
                List exprs = (List)possibleSort.getProperty(NodeConstants.Info.GROUP_COLS);
                if (otherExpression || exprs == null || !exprs.containsAll(sortExpressions)) break;
                exprs.removeAll(sortExpressions);
                exprs.addAll(0, sortExpressions);
                if (((PlanNode)node).getParent() == null) {
                    root = ((PlanNode)node).getFirstChild();
                    root.removeFromParent();
                    Object cols = ((PlanNode)node).getProperty(NodeConstants.Info.OUTPUT_COLS);
                    root.setProperty(NodeConstants.Info.OUTPUT_COLS, cols);
                    if (root.getType() == 8) {
                        root.setProperty(NodeConstants.Info.PROJECT_COLS, cols);
                    }
                    node = root;
                } else {
                    PlanNode nextNode = ((PlanNode)node).getFirstChild();
                    NodeEditor.removeChildNode(((PlanNode)node).getParent(), (PlanNode)node);
                    node = nextNode;
                }
                possibleSort.setProperty(NodeConstants.Info.SORT_ORDER, orderBy);
                break;
            }
            case 2: {
                if (!parentBlocking) break;
                ((PlanNode)node).setType(32);
                ((PlanNode)node).setProperty(NodeConstants.Info.IS_DUP_REMOVAL, true);
                break;
            }
            case 128: {
                if (!((PlanNode)node).hasCollectionProperty(NodeConstants.Info.GROUP_COLS)) break;
                SymbolMap map = (SymbolMap)((PlanNode)node).getProperty(NodeConstants.Info.SYMBOL_MAP);
                boolean cardinalityDependent = false;
                boolean canOptimize = true;
                for (Expression ex : map.asMap().values()) {
                    if (ex instanceof AggregateSymbol) {
                        AggregateSymbol agg = (AggregateSymbol)ex;
                        if (!agg.isCardinalityDependent()) continue;
                        cardinalityDependent = true;
                        break;
                    }
                    if (ex instanceof ElementSymbol) continue;
                    canOptimize = false;
                    break;
                }
                if (canOptimize && this.mergeSortWithDupRemovalAcrossSource((PlanNode)node, false)) {
                    ((PlanNode)node).setProperty(NodeConstants.Info.IS_DUP_REMOVAL, true);
                    if (cardinalityDependent) {
                        PlanNode source = NodeEditor.findNodePreOrder((PlanNode)node, 64);
                        List sourceOutput = (List)source.getProperty(NodeConstants.Info.OUTPUT_COLS);
                        for (PlanNode child = ((PlanNode)node).getFirstChild(); child != source; child = child.getFirstChild()) {
                            child.setProperty(NodeConstants.Info.OUTPUT_COLS, sourceOutput);
                        }
                    }
                }
                parentBlocking = true;
                break;
            }
            case 4: {
                if (((PlanNode)node).getProperty(NodeConstants.Info.JOIN_STRATEGY) == JoinNode.JoinStrategyType.NESTED_LOOP || ((PlanNode)node).getProperty(NodeConstants.Info.JOIN_STRATEGY) == JoinNode.JoinStrategyType.NESTED_TABLE) break;
                parentBlocking = true;
                PlanNode toTest = ((PlanNode)node).getFirstChild();
                if (this.mergeSortWithDupRemovalAcrossSource(toTest, true)) {
                    ((PlanNode)node).setProperty(NodeConstants.Info.SORT_LEFT, (Object)MergeJoinStrategy.SortOption.SORT_DISTINCT);
                    if (((PlanNode)node).getProperty(NodeConstants.Info.SORT_RIGHT) != MergeJoinStrategy.SortOption.SORT) {
                        ((PlanNode)node).setProperty(NodeConstants.Info.JOIN_STRATEGY, (Object)JoinNode.JoinStrategyType.MERGE);
                    }
                }
                if (!this.mergeSortWithDupRemovalAcrossSource(toTest = ((PlanNode)node).getLastChild(), true)) break;
                ((PlanNode)node).setProperty(NodeConstants.Info.SORT_RIGHT, (Object)MergeJoinStrategy.SortOption.SORT_DISTINCT);
                if (((PlanNode)node).getProperty(NodeConstants.Info.SORT_LEFT) == MergeJoinStrategy.SortOption.SORT) break;
                ((PlanNode)node).setProperty(NodeConstants.Info.JOIN_STRATEGY, (Object)JoinNode.JoinStrategyType.MERGE);
                break;
            }
            case 256: {
                if (((PlanNode)node).getProperty(NodeConstants.Info.SET_OPERATION) != SetQuery.Operation.UNION) {
                    parentBlocking = true;
                    break;
                }
                if (((PlanNode)node).hasBooleanProperty(NodeConstants.Info.USE_ALL) || parentBlocking) break;
                ((PlanNode)node).setProperty(NodeConstants.Info.IS_DUP_REMOVAL, true);
            }
        }
        for (PlanNode child : ((PlanNode)node).getChildren()) {
            root = this.optimizeSorts(parentBlocking, child, root, metadata, capFinder, record, context);
        }
        return root;
    }

    static PlanNode checkForProjectOptimization(PlanNode node, PlanNode root, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord record, CommandContext context) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        PlanNode accessNode;
        PlanNode newRoot;
        PlanNode projectNode = node.getFirstChild();
        PlanNode parent = node.getParent();
        boolean raiseAccess = false;
        if (projectNode.getType() == 1 && RuleRaiseAccess.canRaiseOverSort(projectNode, metadata, capFinder, node, record, true, context)) {
            if ((projectNode = NodeEditor.findNodePreOrder(projectNode, 8, 320)) == null) {
                return root;
            }
            raiseAccess = true;
        } else if (projectNode.getType() == 8 && projectNode.getFirstChild() != null) {
            boolean bl = raiseAccess = projectNode.getFirstChild().getType() == 1 && RuleRaiseAccess.canRaiseOverSort(projectNode.getFirstChild(), metadata, capFinder, node, record, false, context);
            if (!(raiseAccess || parent != null && parent.getType() == 1024)) {
                return root;
            }
        } else {
            return root;
        }
        ArrayList childOutputCols = (ArrayList)projectNode.getFirstChild().getProperty(NodeConstants.Info.OUTPUT_COLS);
        OrderBy orderBy = (OrderBy)node.getProperty(NodeConstants.Info.SORT_ORDER);
        List<Expression> orderByKeys = orderBy.getSortKeys();
        LinkedHashSet<Expression> toProject = new LinkedHashSet<Expression>();
        Iterator<Expression> iterator = orderByKeys.iterator();
        while (iterator.hasNext()) {
            Expression ss;
            Expression original = ss = iterator.next();
            if (ss instanceof AliasSymbol) {
                ss = ((AliasSymbol)ss).getSymbol();
            }
            if (ss instanceof ExpressionSymbol && !raiseAccess) {
                return root;
            }
            if (childOutputCols.contains(ss)) continue;
            if (!raiseAccess) {
                return root;
            }
            toProject.add(original);
        }
        PlanNode toRepair = projectNode.getParent();
        if (!toProject.isEmpty()) {
            ArrayList projectCols;
            PlanNode intermediateProject = NodeFactory.getNewNode(8);
            toProject.addAll(childOutputCols);
            childOutputCols = projectCols = new ArrayList(toProject);
            intermediateProject.setProperty(NodeConstants.Info.PROJECT_COLS, projectCols);
            intermediateProject.setProperty(NodeConstants.Info.OUTPUT_COLS, new ArrayList(projectCols));
            toRepair.getFirstChild().addAsParent(intermediateProject);
        }
        NodeEditor.removeChildNode(projectNode.getParent(), projectNode);
        if (parent != null && parent.getType() == 1024 && parent.getParent() != null) {
            parent.addAsParent(projectNode);
        } else {
            if (parent == null) {
                root = projectNode;
            }
            if (parent != null && parent.getType() == 1024) {
                if (root == parent) {
                    root = projectNode;
                }
                projectNode.addFirstChild(parent);
            } else {
                projectNode.addFirstChild(node);
            }
        }
        List orderByOutputSymbols = (List)node.getProperty(NodeConstants.Info.OUTPUT_COLS);
        boolean unrelated = false;
        if (node.hasBooleanProperty(NodeConstants.Info.UNRELATED_SORT)) {
            node.setProperty(NodeConstants.Info.UNRELATED_SORT, false);
            unrelated = true;
        }
        for (OrderByItem item : orderBy.getOrderByItems()) {
            if (unrelated || !toProject.isEmpty()) {
                int index = childOutputCols.indexOf(item.getSymbol());
                item.setExpressionPosition(index);
            }
            if (!toProject.isEmpty() || !(item.getSymbol() instanceof AliasSymbol)) continue;
            item.setSymbol(((AliasSymbol)item.getSymbol()).getSymbol());
        }
        while (toRepair != node) {
            toRepair.setProperty(NodeConstants.Info.OUTPUT_COLS, childOutputCols);
            toRepair = toRepair.getParent();
        }
        projectNode.setProperty(NodeConstants.Info.OUTPUT_COLS, orderByOutputSymbols);
        projectNode.setProperty(NodeConstants.Info.PROJECT_COLS, orderByOutputSymbols);
        node.setProperty(NodeConstants.Info.OUTPUT_COLS, childOutputCols);
        if (parent != null) {
            parent.setProperty(NodeConstants.Info.OUTPUT_COLS, childOutputCols);
        }
        if (raiseAccess && (newRoot = RuleRaiseAccess.raiseAccessNode(root, accessNode = NodeEditor.findNodePreOrder(node, 1), metadata, capFinder, true, record, context)) != null) {
            accessNode.setProperty(NodeConstants.Info.OUTPUT_COLS, childOutputCols);
            root = newRoot;
            if (!toProject.isEmpty()) {
                newRoot = RuleRaiseAccess.raiseAccessNode(root, accessNode, metadata, capFinder, true, record, context);
            }
            if (newRoot != null) {
                root = newRoot;
                if (accessNode.getParent().getType() == 1024) {
                    newRoot = RulePushLimit.raiseAccessOverLimit(root, accessNode, metadata, capFinder, accessNode.getParent(), record);
                }
                if (newRoot != null) {
                    root = newRoot;
                }
            }
        }
        return root;
    }

    private boolean mergeSortWithDupRemovalAcrossSource(PlanNode toTest, boolean join) {
        List sourceCols;
        PlanNode rootNode;
        List cols;
        boolean result;
        PlanNode source = NodeEditor.findNodePreOrder(toTest, 64, 5);
        boolean bl = result = source != null && this.mergeSortWithDupRemoval(source);
        if (result && !(cols = (List)(rootNode = join ? toTest : toTest.getFirstChild()).getProperty(NodeConstants.Info.OUTPUT_COLS)).containsAll(sourceCols = (List)source.getProperty(NodeConstants.Info.OUTPUT_COLS))) {
            while (rootNode != source) {
                LinkedHashSet allCols = new LinkedHashSet((List)rootNode.getProperty(NodeConstants.Info.OUTPUT_COLS));
                allCols.addAll(sourceCols);
                rootNode.setProperty(NodeConstants.Info.OUTPUT_COLS, new ArrayList(allCols));
                rootNode = rootNode.getFirstChild();
            }
        }
        return result;
    }

    private boolean mergeSortWithDupRemoval(PlanNode node) {
        PlanNode parentProject;
        PlanNode source;
        if (node.getFirstChild() == null) {
            return false;
        }
        switch (node.getFirstChild().getType()) {
            case 256: {
                if (node.getFirstChild().getProperty(NodeConstants.Info.SET_OPERATION) != SetQuery.Operation.UNION || node.getFirstChild().hasBooleanProperty(NodeConstants.Info.USE_ALL)) break;
                node.getFirstChild().setProperty(NodeConstants.Info.USE_ALL, true);
                return true;
            }
            case 2: {
                NodeEditor.removeChildNode(node, node.getFirstChild());
                return true;
            }
        }
        if (node.hasBooleanProperty(NodeConstants.Info.UNRELATED_SORT) && (source = NodeEditor.findNodePreOrder(node, 64)) != null && (parentProject = NodeEditor.findParent(source, 8)) != null && parentProject.getProperty(NodeConstants.Info.PROJECT_COLS).equals(source.getProperty(NodeConstants.Info.OUTPUT_COLS))) {
            return this.mergeSortWithDupRemoval(source);
        }
        return false;
    }

    public String toString() {
        return "PlanSorts";
    }
}

