/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.sql.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.function.FunctionMethods;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.ArrayTable;
import org.teiid.query.sql.lang.TableFunctionReference;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.util.CommandContext;

public class ArrayTableNode
extends SubqueryAwareRelationalNode {
    private ArrayTable table;
    private int[] projectionIndexes;
    private int index;
    private int length;
    private Object array;

    public ArrayTableNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        super.initialize(context, bufferManager, dataMgr);
        if (this.projectionIndexes != null) {
            return;
        }
        Map<Expression, Integer> elementMap = ArrayTableNode.createLookupMap(this.table.getProjectedSymbols());
        this.projectionIndexes = ArrayTableNode.getProjectionIndexes(elementMap, this.getElements());
    }

    @Override
    public void reset() {
        super.reset();
        this.array = null;
        this.length = 0;
        this.index = 0;
    }

    @Override
    public void closeDirect() {
        super.closeDirect();
        this.reset();
    }

    public void setTable(ArrayTable table) {
        this.table = table;
    }

    @Override
    public ArrayTableNode clone() {
        ArrayTableNode clone = new ArrayTableNode(this.getID());
        this.copyTo(clone);
        clone.setTable(this.table);
        return clone;
    }

    @Override
    protected TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.array == null) {
            this.array = this.getEvaluator(Collections.emptyMap()).evaluate(this.table.getArrayValue(), null);
        }
        if (this.array != null) {
            if (!Boolean.FALSE.equals(this.table.getSingleRow())) {
                this.createRow(this.array);
            } else {
                try {
                    if (this.length == 0) {
                        this.length = FunctionMethods.array_length(this.array);
                        this.index = 0;
                    }
                    while (this.index < this.length) {
                        if (this.isBatchFull()) {
                            return this.pullBatch();
                        }
                        Object rowArray = FunctionMethods.array_get(this.array, this.index + 1);
                        if (rowArray != null) {
                            if (!(rowArray instanceof Array) && !rowArray.getClass().isArray()) {
                                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID31297, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31297, new Object[0]));
                            }
                            this.createRow(rowArray);
                        }
                        ++this.index;
                    }
                }
                catch (SQLException e) {
                    throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30188, (Throwable)e);
                }
            }
        }
        this.array = null;
        this.terminateBatches();
        return this.pullBatch();
    }

    private void createRow(Object arrayValue) throws FunctionExecutionException, TeiidProcessingException {
        ArrayList<Object> tuple = new ArrayList<Object>(this.projectionIndexes.length);
        for (int output : this.projectionIndexes) {
            TableFunctionReference.ProjectedColumn col = this.table.getColumns().get(output);
            try {
                Object val = FunctionMethods.array_get(arrayValue, output + 1);
                tuple.add(DataTypeManager.transformValue((Object)val, this.table.getColumns().get(output).getSymbol().getType()));
            }
            catch (TransformationException e) {
                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30190, (Throwable)e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30190, new Object[]{col.getName()}));
            }
            catch (SQLException e) {
                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30188, (Throwable)e);
            }
        }
        this.addBatchRow(tuple);
    }

    @Override
    public Collection<? extends LanguageObject> getObjects() {
        return Arrays.asList(this.table.getArrayValue());
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        AnalysisRecord.addLanaguageObjects(props, "Table Function", Arrays.asList(this.table));
        return props;
    }
}

