/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.xquery.saxon;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.XMLEvent;
import org.teiid.xquery.saxon.AbstractXMLStreamReader;

class XMLEventStreamReader
extends AbstractXMLStreamReader {
    private XMLEvent event;
    private final XMLEventReader eventReader;
    private XMLEvent attributesEvent;
    List<Attribute> attributesList;
    private XMLEvent namespacesEvent;
    List<Namespace> namespacesList;

    XMLEventStreamReader(XMLEventReader eventReader) throws XMLStreamException {
        this.eventReader = eventReader;
        this.event = eventReader.nextEvent();
    }

    @Override
    public boolean isStandalone() {
        if (this.event.isStartDocument()) {
            return ((StartDocument)this.event).isStandalone();
        }
        throw new IllegalStateException();
    }

    @Override
    public String getVersion() {
        if (this.event.isStartDocument()) {
            return ((StartDocument)this.event).getVersion();
        }
        return null;
    }

    @Override
    public int getTextStart() {
        return 0;
    }

    @Override
    public String getText() {
        if (this.event.isCharacters()) {
            return this.event.asCharacters().getData();
        }
        if (this.event.getEventType() == 5) {
            return this.event.toString().substring(4, this.event.toString().length() - 3);
        }
        throw new IllegalStateException();
    }

    @Override
    public String getPITarget() {
        if (this.event.isProcessingInstruction()) {
            return ((ProcessingInstruction)this.event).getTarget();
        }
        throw new IllegalStateException();
    }

    @Override
    public String getPIData() {
        if (this.event.isProcessingInstruction()) {
            return ((ProcessingInstruction)this.event).getData();
        }
        throw new IllegalStateException();
    }

    @Override
    public int getNamespaceCount() {
        this.initNamespaces();
        return this.namespacesList.size();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        if (this.event.isStartElement()) {
            return this.event.asStartElement().getNamespaceContext();
        }
        throw new IllegalStateException();
    }

    @Override
    public QName getName() {
        if (this.event.isStartElement()) {
            return this.event.asStartElement().getName();
        }
        if (this.event.isEndElement()) {
            return this.event.asEndElement().getName();
        }
        throw new IllegalStateException();
    }

    @Override
    public Location getLocation() {
        return this.event.getLocation();
    }

    @Override
    public int getEventType() {
        return this.event.getEventType();
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public String getCharacterEncodingScheme() {
        return null;
    }

    @Override
    public int getAttributeCount() {
        this.initAttributes();
        return this.attributesList.size();
    }

    @Override
    public void close() throws XMLStreamException {
        this.eventReader.close();
    }

    @Override
    public QName getAttributeName(int index) {
        return this.getAttribute(index).getName();
    }

    @Override
    public String getAttributeType(int index) {
        return this.getAttribute(index).getDTDType();
    }

    @Override
    public String getAttributeValue(int index) {
        return this.getAttribute(index).getValue();
    }

    @Override
    public String getNamespacePrefix(int index) {
        return this.getNamespace(index).getPrefix();
    }

    @Override
    public String getNamespaceURI(int index) {
        return this.getNamespace(index).getNamespaceURI();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.eventReader.getProperty(name);
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        return this.getAttribute(index).isSpecified();
    }

    @Override
    public int next() throws XMLStreamException {
        this.event = this.eventReader.nextEvent();
        return this.event.getEventType();
    }

    @Override
    public boolean standaloneSet() {
        if (this.event.isStartDocument()) {
            return ((StartDocument)this.event).standaloneSet();
        }
        throw new IllegalStateException();
    }

    private Attribute getAttribute(int index) {
        this.initAttributes();
        return this.attributesList.get(index);
    }

    private void initAttributes() {
        if (!this.event.isStartElement()) {
            throw new IllegalStateException();
        }
        if (this.event != this.attributesEvent) {
            this.attributesEvent = this.event;
            this.attributesList = new ArrayList<Attribute>();
            Iterator<Attribute> attributes = this.event.asStartElement().getAttributes();
            while (attributes.hasNext()) {
                Attribute attribute = attributes.next();
                this.attributesList.add(attribute);
            }
        }
    }

    private Namespace getNamespace(int index) {
        this.initNamespaces();
        return this.namespacesList.get(index);
    }

    private void initNamespaces() {
        if (this.event != this.namespacesEvent) {
            Iterator<Namespace> namespaces;
            this.namespacesEvent = this.event;
            if (this.event.isStartElement()) {
                namespaces = this.event.asStartElement().getNamespaces();
            } else if (this.event.isEndElement()) {
                namespaces = this.event.asEndElement().getNamespaces();
            } else {
                throw new IllegalStateException();
            }
            this.namespacesList = new ArrayList<Namespace>();
            while (namespaces.hasNext()) {
                Namespace namespace = namespaces.next();
                this.namespacesList.add(namespace);
            }
        }
    }
}

