/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.common;

import java.io.Serializable;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.Translator;

public class ExternalSource
implements Serializable {
    private static final long serialVersionUID = -5069489555166011459L;
    private static final String DEFAULT_PREFIX = "spring.teiid.data.";
    private String name;
    private String[] driverNames;
    private String[] datasourceNames;
    private String translatorName;
    private String dialect;
    private String[] gav;
    private String springBootPropertyPrefix;
    private boolean jdbc;

    public ExternalSource(String name, String[] driverNames, String[] datasourceNames, String translatorName, String dialect, String[] gav, String prefix, boolean jdbc) {
        this(name, driverNames, datasourceNames, translatorName, dialect, gav, prefix);
        this.jdbc = jdbc;
    }

    public ExternalSource(String name, String[] driverNames, String[] datasourceNames, String translatorName, String dialect, String[] gav, String prefix) {
        this.name = name;
        this.driverNames = driverNames;
        this.datasourceNames = datasourceNames;
        this.translatorName = translatorName;
        this.dialect = dialect;
        this.gav = gav;
        this.springBootPropertyPrefix = prefix;
    }

    public String getName() {
        return this.name;
    }

    public String[] getDriverNames() {
        return this.driverNames;
    }

    public String getTranslatorName() {
        return this.translatorName;
    }

    public String getDialect() {
        return this.dialect;
    }

    public String[] getGav() {
        return this.gav;
    }

    public String getSpringBootPropertyPrefix() {
        if (this.springBootPropertyPrefix == null) {
            return DEFAULT_PREFIX + this.getName();
        }
        return this.springBootPropertyPrefix;
    }

    public static Class<? extends ExecutionFactory<?, ?>> translatorClass(String translatorName, String basePackage) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Translator.class));
        Class<? extends ExecutionFactory<?, ?>> clazz = ExternalSource.findTranslatorInPackage(translatorName, provider, "org.teiid.translator");
        if (clazz == null) {
            clazz = ExternalSource.findTranslatorInPackage(translatorName, provider, basePackage);
        }
        return clazz;
    }

    static Class<? extends ExecutionFactory<?, ?>> findTranslatorInPackage(String translatorName, ClassPathScanningCandidateComponentProvider provider, String packageName) {
        Set components = provider.findCandidateComponents(packageName);
        for (BeanDefinition c : components) {
            try {
                Class<?> clazz = Class.forName(c.getBeanClassName());
                String name = clazz.getAnnotation(Translator.class).name();
                if (!name.equals(translatorName)) continue;
                return clazz;
            }
            catch (ClassNotFoundException | IllegalArgumentException | SecurityException e) {
                throw new IllegalStateException("Error loading translators", e);
            }
        }
        return null;
    }

    public String[] getDatasourceNames() {
        return this.datasourceNames;
    }

    public void setDatasourceNames(String[] datasourceNames) {
        this.datasourceNames = datasourceNames;
    }

    public boolean isJdbc() {
        return this.jdbc;
    }
}

