/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.autoconfigure;

import com.zaxxer.hikari.HikariDataSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.sql.XADataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.dialect.Dialect;
import org.hibernate.service.ServiceRegistry;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.teiid.PreParser;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dialect.TeiidDialect;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Schema;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.metadata.VDBResources;
import org.teiid.query.parser.QueryParser;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.spring.annotations.ExcelTable;
import org.teiid.spring.annotations.JsonTable;
import org.teiid.spring.annotations.SelectQuery;
import org.teiid.spring.annotations.TextTable;
import org.teiid.spring.annotations.UserDefinedFunctions;
import org.teiid.spring.autoconfigure.PlatformTransactionManagerAdapter;
import org.teiid.spring.autoconfigure.RedirectionSchemaBuilder;
import org.teiid.spring.autoconfigure.RedirectionSchemaInitializer;
import org.teiid.spring.autoconfigure.SchemaBuilderUtility;
import org.teiid.spring.common.ExternalSource;
import org.teiid.spring.common.ExternalSources;
import org.teiid.spring.data.BaseConnectionFactory;
import org.teiid.spring.data.ConnectionFactoryConfiguration;
import org.teiid.spring.views.EntityBaseView;
import org.teiid.spring.views.ExcelTableView;
import org.teiid.spring.views.JsonTableView;
import org.teiid.spring.views.SimpleView;
import org.teiid.spring.views.TextTableView;
import org.teiid.spring.views.UDFProcessor;
import org.teiid.spring.views.ViewBuilder;
import org.teiid.spring.xa.XADataSourceBuilder;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TeiidServer
extends EmbeddedServer {
    static final String DIALECT = "dialect";
    private static final Log logger = LogFactory.getLog(TeiidServer.class);
    private MetadataSources metadataSources = new MetadataSources();
    private PlatformTransactionManagerAdapter platformTransactionManagerAdapter;
    private ConcurrentHashMap<String, EmbeddedServer.ConnectionFactoryProvider<?>> connectionFactoryProviders = new ConcurrentHashMap();
    private ExternalSources externalSources;

    public TeiidServer(ExternalSources es) {
        this.cmr = new SBConnectorManagerRepository();
        this.externalSources = es;
    }

    public void addDataSource(VDBMetaData vdb, String sourceBeanName, Object source, ApplicationContext context) {
        if (Boolean.valueOf(vdb.getPropertyValue("implicit")).booleanValue()) {
            boolean redirectUpdates = this.isRedirectUpdatesEnabled(context);
            String redirectedDSName = this.getRedirectedDataSource(context);
            this.addConnectionFactoryProvider(sourceBeanName, new SBConnectionFactoryProvider(source));
            ModelMetaData model = null;
            if (source instanceof javax.sql.DataSource) {
                String driverName = this.getDriverName(source);
                if (driverName == null) {
                    throw new IllegalStateException("Failed to determine the type of data source defined with bean name " + sourceBeanName + " use Tomcat/Hikari based DataSource and XA DataSources are supported. Add the following to your pom.xml\n  <dependency>\n      <groupId>org.apache.tomcat</groupId>\n      <artifactId>tomcat-jdbc</artifactId>\n    </dependency>");
                }
                try {
                    model = this.buildModelFromDataSource(vdb, sourceBeanName, driverName, context, redirectUpdates && sourceBeanName.equals(redirectedDSName));
                }
                catch (AdminException e) {
                    throw new IllegalStateException("Error adding the source, cause: " + e.getMessage());
                }
            } else if (source instanceof BaseConnectionFactory) {
                try {
                    model = this.buildModelFromConnectionFactory(vdb, sourceBeanName, (BaseConnectionFactory)source, context);
                }
                catch (AdminException e) {
                    throw new IllegalStateException("Error adding the source, cause: " + e.getMessage());
                }
            } else {
                throw new IllegalStateException("Unknown source type is being added");
            }
            try {
                Admin admin = this.getAdmin();
                VDBMetaData previous = (VDBMetaData)admin.getVDB("spring", "1.0.0");
                for (Map.Entry entry : previous.getModelMetaDatas().entrySet()) {
                    String metadata = admin.getSchema("spring", "1.0.0", (String)entry.getKey(), null, null);
                    if (!vdb.getModel((String)entry.getKey()).getSourceMetadataType().isEmpty()) continue;
                    vdb.getModel((String)entry.getKey()).addSourceMetadata("DDL", metadata);
                }
            }
            catch (AdminException admin) {
                // empty catch block
            }
            if (model != null) {
                model.setVisible(false);
                vdb.addModel(model);
                logger.info((Object)("Added " + sourceBeanName + " to the Teiid Database"));
            }
            this.undeployVDB(vdb.getName(), vdb.getVersion());
            this.deployVDB(vdb, false, context);
        } else {
            block7: for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
                for (SourceMappingMetadata smm : model.getSourceMappings()) {
                    if (smm.getConnectionJndiName() == null || !smm.getName().equalsIgnoreCase(sourceBeanName)) continue;
                    this.addConnectionFactory(smm.getConnectionJndiName(), source);
                    continue block7;
                }
            }
        }
    }

    void addOverrideTranslator(VDBTranslatorMetaData translator, ApplicationContext context) {
        try {
            String type = translator.getType();
            ExternalSource es = this.externalSources.find(type);
            this.addTranslator(es, context);
            this.addTranslator(translator.getName(), type, translator.getPropertiesMap());
        }
        catch (TranslatorException e) {
            throw new IllegalStateException("Failed to load translator " + translator.getName(), e);
        }
    }

    void addTranslator(ExternalSource source, ApplicationContext context) {
        block3: {
            try {
                if (this.getExecutionFactory(source.getTranslatorName()) != null) break block3;
                String basePackage = this.getBasePackage(context, true);
                Class clazz = ExternalSource.translatorClass((String)source.getTranslatorName(), (String)basePackage);
                if (clazz != null) {
                    this.addTranslator(clazz);
                    break block3;
                }
                throw new IllegalStateException("Failed to load translator " + source.getName() + ". Check to make sure @Translator annotation is added on your custom translator and also set the 'spring.teiid.model.package' set to package where the translator is defined. Otherwise, the following Dependencies are missing,\n" + source.getGav() + "\n\n in your pom.xml. Please add these dependencies. ");
            }
            catch (ConnectorManagerRepository.ConnectorManagerException | TranslatorException e) {
                throw new IllegalStateException("Failed to load translator " + source.getName(), e);
            }
        }
    }

    String getDriverName(Object source) {
        String driverName = null;
        if (source instanceof DataSource) {
            driverName = ((DataSource)source).getDriverClassName();
        } else if (source instanceof HikariDataSource) {
            driverName = ((HikariDataSource)source).getDriverClassName();
        } else if (source instanceof javax.sql.DataSource) {
            try {
                XADataSource xads = ((javax.sql.DataSource)source).unwrap(XADataSource.class);
                if (xads != null) {
                    driverName = xads instanceof XADataSourceBuilder ? ((XADataSourceBuilder)xads).dataSourceClassName() : xads.getClass().getName();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return driverName;
    }

    void deployVDB(VDBMetaData vdb, boolean last, ApplicationContext context) {
        try {
            if (Boolean.valueOf(vdb.getPropertyValue("implicit")).booleanValue()) {
                if (vdb.getModel("teiid") == null) {
                    for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
                        model.setVisible(true);
                    }
                } else {
                    for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
                        if (model.getName().equals("teiid")) continue;
                        model.setVisible(false);
                    }
                }
            }
            if (last && logger.isDebugEnabled()) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                VDBMetadataParser.marshall((VDBMetaData)vdb, (OutputStream)out);
                logger.debug((Object)("XML Form of VDB:\n" + TeiidServer.prettyFormat(new String(out.toByteArray()))));
            }
            for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
                for (SourceMappingMetadata smm : model.getSourceMappings()) {
                    VDBTranslatorMetaData translator = vdb.getTranslator(smm.getTranslatorName());
                    if (translator != null) {
                        this.addOverrideTranslator(translator, context);
                    } else {
                        ExternalSource es = this.externalSources.find(smm.getTranslatorName());
                        this.addTranslator(es, context);
                    }
                    if (smm.getConnectionJndiName() == null || this.connectionFactoryProviders.get(smm.getConnectionJndiName()) != null) continue;
                    throw new IllegalStateException("A Data source with JNDI name " + smm.getConnectionJndiName() + " is used but not configured, check your DataSources.java file and configure it.");
                }
            }
            this.deployVDB(vdb, (VDBResources)vdb.getAttachment(VDBResources.class));
        }
        catch (IOException | XMLStreamException | VirtualDatabaseException | ConnectorManagerRepository.ConnectorManagerException | TranslatorException e) {
            throw new IllegalStateException("Failed to deploy the VDB file", e);
        }
    }

    private static String prettyFormat(String xml) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StreamResult result = new StreamResult(new StringWriter());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(xml));
            DOMSource source = new DOMSource(db.parse(is));
            transformer.transform(source, result);
            return result.getWriter().toString();
        }
        catch (IOException | IllegalArgumentException | ParserConfigurationException | TransformerException | TransformerFactoryConfigurationError | SAXException e) {
            return xml;
        }
    }

    private ModelMetaData buildModelFromDataSource(VDBMetaData vdb, String dsBeanName, String driverName, ApplicationContext context, boolean createInitTable) throws AdminException {
        ModelMetaData model = new ModelMetaData();
        model.setName(dsBeanName);
        model.setModelType(Model.Type.PHYSICAL);
        model.addProperty("importer.useQualifiedName", "false");
        model.addProperty("importer.tableTypes", "TABLE,VIEW");
        SourceMappingMetadata source = new SourceMappingMetadata();
        source.setName(dsBeanName);
        source.setConnectionJndiName(dsBeanName);
        ExternalSource es = this.externalSources.findByDriverName(driverName);
        source.setTranslatorName(es.getTranslatorName());
        String dialect = es.getDialect();
        if (dialect != null) {
            model.addProperty(DIALECT, dialect);
        }
        this.addTranslator(es, context);
        Properties overrideProperties = this.getTranslatorProperties(context, source.getTranslatorName(), dsBeanName, Admin.TranlatorPropertyType.OVERRIDE, new String[]{"spring.datasource", "spring.xa.datasource"});
        if (!overrideProperties.isEmpty()) {
            source.setTranslatorName(dsBeanName);
            VDBTranslatorMetaData t = new VDBTranslatorMetaData();
            t.setName(dsBeanName);
            t.setType(es.getTranslatorName());
            t.setProperties(overrideProperties);
            vdb.addOverideTranslator(t);
        }
        Properties importProperties = this.getTranslatorProperties(context, source.getTranslatorName(), dsBeanName, Admin.TranlatorPropertyType.IMPORT, new String[]{"spring.datasource", "spring.xa.datasource"});
        for (String k : importProperties.stringPropertyNames()) {
            model.addProperty(k, importProperties.getProperty(k));
        }
        model.addSourceMapping(source);
        if (createInitTable) {
            model.addSourceMetadata("NATIVE", "");
            model.addSourceMetadata("DDL", "create foreign table dual(id integer);");
        }
        return model;
    }

    Properties getTranslatorProperties(ApplicationContext context, String translatorName, String beanName, Admin.TranlatorPropertyType propertyType, String[] propertyPrefix) throws AdminException {
        Properties read = new Properties();
        Collection importProperties = this.getAdmin().getTranslatorPropertyDefinitions(translatorName, propertyType);
        importProperties.forEach(prop -> {
            String key = prop.getName();
            for (String prefix : propertyPrefix) {
                String envKey = prefix + "." + beanName + "." + key;
                String value = context.getEnvironment().getProperty(envKey.toLowerCase());
                if (value == null) continue;
                read.setProperty(key, value);
                break;
            }
        });
        return read;
    }

    private ModelMetaData buildModelFromConnectionFactory(VDBMetaData vdb, String sourceBeanName, BaseConnectionFactory factory, ApplicationContext context) throws AdminException {
        ModelMetaData model = new ModelMetaData();
        model.setName(sourceBeanName);
        model.setModelType(Model.Type.PHYSICAL);
        SourceMappingMetadata source = new SourceMappingMetadata();
        source.setName(sourceBeanName);
        source.setConnectionJndiName(sourceBeanName);
        ExternalSource es = this.externalSources.find(factory.getAlias());
        source.setTranslatorName(es.getTranslatorName());
        try {
            if (this.getExecutionFactory(es.getTranslatorName()) == null) {
                this.addTranslator(es, context);
            }
        }
        catch (ConnectorManagerRepository.ConnectorManagerException e) {
            throw new IllegalStateException("Failed to load translator " + es.getTranslatorName() + ", make sure maven dependency \n" + es.getGav() + "\n\n is available in your pom.xml file", e);
        }
        Properties overrideProperties = this.getTranslatorProperties(context, source.getTranslatorName(), sourceBeanName, Admin.TranlatorPropertyType.OVERRIDE, new String[]{es.getSpringBootPropertyPrefix()});
        if (!overrideProperties.isEmpty()) {
            source.setTranslatorName(sourceBeanName);
            VDBTranslatorMetaData t = new VDBTranslatorMetaData();
            t.setName(sourceBeanName);
            t.setType(source.getTranslatorName());
            t.setProperties(overrideProperties);
            vdb.addOverideTranslator(t);
        }
        Properties importProperties = this.getTranslatorProperties(context, source.getTranslatorName(), sourceBeanName, Admin.TranlatorPropertyType.IMPORT, new String[]{es.getSpringBootPropertyPrefix()});
        for (String k : importProperties.stringPropertyNames()) {
            model.addProperty(k, importProperties.getProperty(k));
        }
        model.addSourceMapping(source);
        return model;
    }

    boolean findAndConfigureViews(VDBMetaData vdb, ApplicationContext context, PhysicalNamingStrategy namingStrategy) {
        Class<?> clazz;
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Entity.class));
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Embeddable.class));
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(SelectQuery.class));
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(UserDefinedFunctions.class));
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(ConnectionFactoryConfiguration.class));
        String basePackage = this.getBasePackage(context, false);
        boolean load = false;
        Set components = provider.findCandidateComponents(basePackage);
        for (BeanDefinition c : components) {
            try {
                clazz = Class.forName(c.getBeanClassName());
                ConnectionFactoryConfiguration cfc = clazz.getAnnotation(ConnectionFactoryConfiguration.class);
                if (cfc == null) continue;
                this.externalSources.addSource(cfc, c.getBeanClassName());
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)"Error loading entity classes");
            }
        }
        for (BeanDefinition c : components) {
            try {
                clazz = Class.forName(c.getBeanClassName());
                ExcelTable excelAnnotation = clazz.getAnnotation(ExcelTable.class);
                if (excelAnnotation == null) continue;
                this.addExcelModel(vdb, clazz, excelAnnotation, context);
                load = true;
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)"Error loading entity classes");
            }
        }
        ModelMetaData model = new ModelMetaData();
        model.setName("teiid");
        model.setModelType(Model.Type.VIRTUAL);
        MetadataFactory mf = new MetadataFactory("spring", (Object)"1.0.0", SystemMetadata.getInstance().getRuntimeTypeMap(), model);
        if (components.isEmpty()) {
            if (this.isRedirectUpdatesEnabled(context)) {
                this.buildVirtualBaseLayer(vdb, context, mf);
            } else {
                return false;
            }
        }
        Metadata metadata = this.getMetadata(components, namingStrategy, mf);
        UDFProcessor udfProcessor = new UDFProcessor(metadata, vdb);
        for (BeanDefinition c : components) {
            try {
                Class<?> clazz2 = Class.forName(c.getBeanClassName());
                Entity entityAnnotation = clazz2.getAnnotation(Entity.class);
                SelectQuery selectAnnotation = clazz2.getAnnotation(SelectQuery.class);
                TextTable textAnnotation = clazz2.getAnnotation(TextTable.class);
                JsonTable jsonAnnotation = clazz2.getAnnotation(JsonTable.class);
                ExcelTable excelAnnotation = clazz2.getAnnotation(ExcelTable.class);
                UserDefinedFunctions udfAnnotation = clazz2.getAnnotation(UserDefinedFunctions.class);
                if (textAnnotation != null && entityAnnotation != null) {
                    new TextTableView(metadata).buildView(clazz2, mf, textAnnotation, context);
                } else if (jsonAnnotation != null && entityAnnotation != null) {
                    new JsonTableView(metadata).buildView(clazz2, mf, jsonAnnotation, context);
                } else if (selectAnnotation != null && entityAnnotation != null) {
                    new SimpleView(metadata).buildView(clazz2, mf, selectAnnotation, context);
                } else if (excelAnnotation != null && entityAnnotation != null) {
                    new ExcelTableView(metadata).buildView(clazz2, mf, excelAnnotation, context);
                } else if (udfAnnotation != null) {
                    udfProcessor.buildFunctions(clazz2, mf, udfAnnotation);
                } else if (selectAnnotation == null && entityAnnotation != null) {
                    new EntityBaseView(metadata, vdb, this).buildView(clazz2, mf, entityAnnotation, context);
                }
                if (entityAnnotation == null) continue;
                udfProcessor.buildSequence(clazz2, mf, entityAnnotation);
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)"Error loading entity classes");
            }
        }
        udfProcessor.finishProcessing();
        if (this.isRedirectUpdatesEnabled(context)) {
            String redirectedDSName = this.getRedirectedDataSource(context);
            try {
                model.setName("internal");
                model.setVisible(false);
                javax.sql.DataSource redirectedDS = (javax.sql.DataSource)((SBConnectionFactoryProvider)this.getConnectionFactoryProviders().get(redirectedDSName)).getBean();
                String driverName = this.getDriverName(redirectedDS);
                if (driverName == null) {
                    throw new IllegalStateException("Redirection of updates enabled, however datasource configured for redirection is not recognized.");
                }
                RedirectionSchemaBuilder mg = new RedirectionSchemaBuilder(context, redirectedDSName);
                if (mf.getSchema().getTables().isEmpty()) {
                    throw new IllegalStateException("Redirection of updates enabled, however there are no @Entity found. There must be atleast one @Entity for this feature to work.");
                }
                ModelMetaData exposedModel = mg.buildRedirectionLayer(mf, "teiid");
                vdb.addModel(exposedModel);
                ModelMetaData redirectedModel = vdb.getModel(redirectedDSName);
                assert (redirectedModel != null);
                String dialect = redirectedModel.getPropertyValue(DIALECT);
                if (dialect == null) {
                    throw new IllegalStateException("Redirection is enabled, however data source named \"" + redirectedDSName + "\" cannot be used with schema initialization, choose a different data sourceas there are no schema generation facilities for this data source.");
                }
                new RedirectionSchemaInitializer(redirectedDS, redirectedDSName, this.getDialect(dialect), metadata, this.metadataSources.getServiceRegistry(), mf.getSchema(), context).init();
                try {
                    vdb.addModel(this.buildModelFromDataSource(vdb, redirectedDSName, driverName, context, false));
                }
                catch (AdminException e) {
                    throw new IllegalStateException("Error adding the source, cause: " + e.getMessage());
                }
                load = true;
            }
            catch (BeansException e) {
                throw new IllegalStateException("Redirection is enabled, however data source named \"" + redirectedDSName + "\" is not configured. Please configure a data source.");
            }
        }
        if (!mf.getSchema().getTables().isEmpty()) {
            load = true;
            String ddl = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null);
            model.addSourceMetadata("DDL", ddl);
            vdb.addModel(model);
        }
        return load;
    }

    private String getBasePackage(ApplicationContext context, boolean translator) {
        String basePackage = context.getEnvironment().getProperty("spring.teiid.model.package");
        if (basePackage == null) {
            if (translator) {
                logger.warn((Object)"***************************************************************");
                logger.warn((Object)"\"spring.teiid.model.package\" is NOT set, If you are using any custom translators, it is advised to that this property is set. ");
                logger.warn((Object)"consider setting this property to avoid time consuming scanning");
                logger.warn((Object)"***************************************************************");
            } else {
                logger.warn((Object)"***************************************************************");
                logger.warn((Object)"\"spring.teiid.model.package\" is NOT set, scanning entire classpath for @Entity classes.");
                logger.warn((Object)"consider setting this property to avoid time consuming scanning");
                logger.warn((Object)"***************************************************************");
            }
            basePackage = "*";
        }
        return basePackage;
    }

    boolean isRedirectUpdatesEnabled(ApplicationContext context) {
        return Boolean.parseBoolean(context.getEnvironment().getProperty("spring.teiid.redirected"));
    }

    private void buildVirtualBaseLayer(VDBMetaData vdb, ApplicationContext context, MetadataFactory target) {
        String redirectedDSName = this.getRedirectedDataSource(context);
        SchemaBuilderUtility builder = new SchemaBuilderUtility();
        for (ModelMetaData m : vdb.getModelMetaDatas().values()) {
            if (ViewBuilder.isBuiltInModel(m.getName()) || m.getModelType() != Model.Type.PHYSICAL || m.getName().equals(redirectedDSName)) continue;
            String dialect = m.getPropertyValue(DIALECT);
            MetadataFactory source = new MetadataFactory("x", (Object)1, m.getName(), SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
            for (String ddl : m.getSourceMetadataText()) {
                QueryParser.getQueryParser().parseDDL(source, ddl);
            }
            builder.generateVBLSchema(context, source, target, this.getDialect(dialect), this.metadataSources);
        }
    }

    public String getRedirectedDataSource(ApplicationContext context) {
        return context.getEnvironment().getProperty("spring.teiid.redirected.datasource", "redirected");
    }

    private Metadata getMetadata(Set<BeanDefinition> components, PhysicalNamingStrategy namingStrategy, MetadataFactory mf) {
        ServiceRegistry registry = this.metadataSources.getServiceRegistry();
        StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder((BootstrapServiceRegistry)registry).applySetting("hibernate.dialect", TeiidDialect.class).build();
        for (BeanDefinition c : components) {
            try {
                Class<?> clazz = Class.forName(c.getBeanClassName());
                this.metadataSources.addAnnotatedClass(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return this.metadataSources.getMetadataBuilder(serviceRegistry).applyPhysicalNamingStrategy(namingStrategy).build();
    }

    private void addExcelModel(VDBMetaData vdb, Class<?> clazz, ExcelTable excelAnnotation, ApplicationContext context) {
        ModelMetaData model = new ModelMetaData();
        model.setName(clazz.getSimpleName().toLowerCase());
        model.setModelType(Model.Type.PHYSICAL);
        model.addProperty("importer.DataRowNumber", String.valueOf(excelAnnotation.dataRowStartsAt()));
        model.addProperty("importer.ExcelFileName", excelAnnotation.file());
        model.addProperty("importer.IgnoreEmptyHeaderCells", String.valueOf(excelAnnotation.ignoreEmptyCells()));
        if (excelAnnotation.headerRow() != -1) {
            model.addProperty("importer.HeaderRowNumber", String.valueOf(excelAnnotation.headerRow()));
        }
        SourceMappingMetadata source = new SourceMappingMetadata();
        source.setName(clazz.getSimpleName().toLowerCase());
        source.setConnectionJndiName(excelAnnotation.source());
        source.setTranslatorName("excel");
        try {
            if (this.getExecutionFactory("excel") == null) {
                this.addTranslator(this.externalSources.find("excel"), context);
            }
        }
        catch (ConnectorManagerRepository.ConnectorManagerException e) {
            throw new IllegalStateException("Failed to load translator excel", e);
        }
        model.addSourceMapping(source);
        vdb.addModel(model);
    }

    public Schema getSchema(VDBMetaData vdb, String modelName) {
        if (vdb == null) {
            return null;
        }
        TransformationMetadata metadata = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
        if (metadata == null) {
            return null;
        }
        Schema schema = metadata.getMetadataStore().getSchema(modelName);
        return schema;
    }

    private Dialect getDialect(String className) {
        try {
            return (Dialect)Dialect.class.cast(ReflectionHelper.create((String)className, null, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
        }
        catch (TeiidException e) {
            throw new TeiidRuntimeException(className + " could not be loaded. Add the dependecy required dependency to your classpath");
        }
    }

    public PlatformTransactionManagerAdapter getPlatformTransactionManagerAdapter() {
        return this.platformTransactionManagerAdapter;
    }

    public void addConnectionFactoryProvider(String jndiName, EmbeddedServer.ConnectionFactoryProvider<?> connectionFactoryProvider) {
        this.connectionFactoryProviders.put(jndiName, connectionFactoryProvider);
    }

    public void addConnectionFactory(String jndiName, Object connectionFactory) {
        this.connectionFactoryProviders.put(jndiName, (EmbeddedServer.ConnectionFactoryProvider<?>)new EmbeddedServer.SimpleConnectionFactoryProvider(connectionFactory));
    }

    public EmbeddedServer.ConnectionFactoryProvider<?> removeConnectionFactoryProvider(String jndiName) {
        return this.connectionFactoryProviders.remove(jndiName);
    }

    protected boolean allowOverrideTranslators() {
        return true;
    }

    public void setPreParser(PreParser bean) {
        this.getConfiguration().setPreParser(bean);
    }

    public boolean isUsingPlatformTransactionManager() {
        return this.platformTransactionManagerAdapter != null;
    }

    public void setPlatformTransactionManagerAdapter(PlatformTransactionManagerAdapter platformTransactionManagerAdapter) {
        this.platformTransactionManagerAdapter = platformTransactionManagerAdapter;
    }

    public void registerSource(Object bean, ApplicationContext context) {
        if (bean.getClass().isAnnotationPresent(ConnectionFactoryConfiguration.class)) {
            ConnectionFactoryConfiguration annotation = bean.getClass().getAnnotation(ConnectionFactoryConfiguration.class);
            this.externalSources.addSource(annotation, bean.getClass().getName());
        }
    }

    protected class SBConnectorManagerRepository
    extends ConnectorManagerRepository {
        public SBConnectorManagerRepository() {
            super(true);
        }

        protected ConnectorManager createConnectorManager(String translatorName, String connectionName, ExecutionFactory<Object, Object> ef) throws ConnectorManagerRepository.ConnectorManagerException {
            return new ConnectorManager(translatorName, connectionName, ef){

                public Object getConnectionFactory() throws TranslatorException {
                    if (this.getConnectionName() == null) {
                        return null;
                    }
                    EmbeddedServer.ConnectionFactoryProvider connectionFactoryProvider = (EmbeddedServer.ConnectionFactoryProvider)TeiidServer.this.connectionFactoryProviders.get(this.getConnectionName());
                    if (connectionFactoryProvider != null) {
                        return connectionFactoryProvider.getConnectionFactory();
                    }
                    return super.getConnectionFactory();
                }
            };
        }
    }

    static class SBConnectionFactoryProvider
    implements EmbeddedServer.ConnectionFactoryProvider<Object> {
        private Object bean;

        SBConnectionFactoryProvider(Object bean) {
            this.bean = bean;
        }

        public Object getConnectionFactory() throws TranslatorException {
            if (this.bean instanceof javax.sql.DataSource) {
                return new TransactionAwareDataSourceProxy((javax.sql.DataSource)this.bean);
            }
            return this.bean;
        }

        public Object getBean() {
            return this.bean;
        }
    }
}

