/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.views;

import java.util.List;
import org.hibernate.boot.Metadata;
import org.springframework.context.ApplicationContext;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.language.DerivedColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.spring.annotations.DeleteQuery;
import org.teiid.spring.annotations.InsertQuery;
import org.teiid.spring.annotations.SelectQuery;
import org.teiid.spring.annotations.UpdateQuery;
import org.teiid.spring.views.ViewBuilder;

public class SimpleView
extends ViewBuilder<SelectQuery> {
    public SimpleView(Metadata metadata) {
        super(metadata);
    }

    @Override
    void onFinish(Table view, MetadataFactory mf, Class<?> entityClazz, SelectQuery annotation, ApplicationContext context) {
        DeleteQuery deleteAnnotation;
        UpdateQuery updateAnnotation;
        String select = annotation.value();
        this.validateOrderingOfColumns(select, view, entityClazz);
        view.setSelectTransformation(annotation.value());
        InsertQuery insertAnnotation = entityClazz.getAnnotation(InsertQuery.class);
        if (insertAnnotation != null) {
            view.setInsertPlan(insertAnnotation.value());
            view.setSupportsUpdate(true);
        }
        if ((updateAnnotation = entityClazz.getAnnotation(UpdateQuery.class)) != null) {
            view.setUpdatePlan(updateAnnotation.value());
            view.setSupportsUpdate(true);
        }
        if ((deleteAnnotation = entityClazz.getAnnotation(DeleteQuery.class)) != null) {
            view.setDeletePlan(deleteAnnotation.value());
            view.setSupportsUpdate(true);
        }
    }

    private void validateOrderingOfColumns(String select, Table view, Class<?> entityClazz) {
        try {
            QueryParser parser = QueryParser.getQueryParser();
            QueryCommand cmd = (QueryCommand)parser.parseCommand(select);
            List expressions = cmd.getProjectedSymbols();
            List columns = view.getColumns();
            if (expressions.size() != columns.size()) {
                String msg = "On enity " + entityClazz.getName() + " in @SelectQuery annotation defined wrong number of projected columns than what are defined as entity attributes.";
                throw new IllegalStateException(msg);
            }
            for (int i = 0; i < columns.size(); ++i) {
                Expression es = (Expression)expressions.get(i);
                Column column = (Column)columns.get(i);
                if (!(es instanceof AliasSymbol) || ((AliasSymbol)es).getName().equals(column.getName())) continue;
                String msg = "On enity " + entityClazz.getName() + " in @SelectQuery annotation column " + ((DerivedColumn)es).getAlias() + "defined at wrong position. Please note View's columns order is " + columns;
                throw new IllegalStateException(msg);
            }
        }
        catch (QueryParserException queryParserException) {
            // empty catch block
        }
    }
}

