/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.views;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import org.hibernate.boot.Metadata;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.springframework.context.ApplicationContext;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.dialect.TeiidDialect;
import org.teiid.hibernate.types.BigDecimalArrayType;
import org.teiid.hibernate.types.BigIntegerArrayType;
import org.teiid.hibernate.types.BooleanArrayType;
import org.teiid.hibernate.types.DateArrayType;
import org.teiid.hibernate.types.DoubleArrayType;
import org.teiid.hibernate.types.FloatArrayType;
import org.teiid.hibernate.types.IntArrayType;
import org.teiid.hibernate.types.LongArrayType;
import org.teiid.hibernate.types.ShortArrayType;
import org.teiid.hibernate.types.StringArrayType;
import org.teiid.hibernate.types.TimeArrayType;
import org.teiid.hibernate.types.TimestampArrayType;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;

public class ViewBuilder<T> {
    public static final TeiidDialect dialect = new TeiidDialect();
    protected Metadata metadata;

    public ViewBuilder(Metadata metadata) {
        this.metadata = metadata;
    }

    public void buildView(Class<?> entityClazz, MetadataFactory mf, T annotation, ApplicationContext context) {
        javax.persistence.Table tableAnnotation;
        PersistentClass hibernateClass = this.metadata.getEntityBinding(entityClazz.getName());
        Table ormTable = hibernateClass.getTable();
        String tableName = ormTable.getQuotedName();
        Entity entityAnnotation = entityClazz.getAnnotation(Entity.class);
        if (entityAnnotation != null && !entityAnnotation.name().isEmpty()) {
            tableName = entityAnnotation.name();
        }
        if ((tableAnnotation = entityClazz.getAnnotation(javax.persistence.Table.class)) != null && !tableAnnotation.name().isEmpty()) {
            tableName = tableAnnotation.name();
        }
        org.teiid.metadata.Table view = mf.addTable(tableName);
        view.setVirtual(true);
        view.setSupportsUpdate(true);
        this.onTableCreate(view, mf, entityClazz, annotation);
        Iterator it = ormTable.getColumnIterator();
        while (it.hasNext()) {
            Column ormColumn = (Column)it.next();
            FieldInfo attribute = this.getAttributeField(entityClazz, hibernateClass, ormColumn.getName(), new FieldInfo());
            this.addColumn(ormTable, ormColumn, attribute.path, attribute.field, view, mf, !it.hasNext(), annotation);
        }
        this.addPrimaryKey(ormTable, view, mf);
        this.addForeignKeys(ormTable, view, mf);
        this.addIndexKeys(ormTable, view, mf);
        this.onFinish(view, mf, entityClazz, annotation, context);
    }

    void onFinish(org.teiid.metadata.Table view, MetadataFactory mf, Class<?> entityClazz, T annotation, ApplicationContext context) {
    }

    void onColumnCreate(org.teiid.metadata.Table view, org.teiid.metadata.Column column, MetadataFactory mf, Field field, String parent, boolean last, T annotation) {
    }

    void onTableCreate(org.teiid.metadata.Table view, MetadataFactory mf, Class<?> entityClazz, T annotation) {
    }

    protected Class<?> normalizeType(Class<?> clazz) {
        if (clazz.isAssignableFrom(Integer.TYPE)) {
            return Integer.class;
        }
        if (clazz.isAssignableFrom(Byte.TYPE)) {
            return Byte.class;
        }
        if (clazz.isAssignableFrom(Short.TYPE)) {
            return Short.class;
        }
        if (clazz.isAssignableFrom(Float.TYPE)) {
            return Float.class;
        }
        if (clazz.isAssignableFrom(Double.TYPE)) {
            return Double.class;
        }
        if (clazz.isAssignableFrom(Long.TYPE)) {
            return Long.class;
        }
        if (clazz.isAssignableFrom(int[].class)) {
            return Integer[].class;
        }
        if (clazz.isAssignableFrom(byte[].class)) {
            return Byte[].class;
        }
        if (clazz.isAssignableFrom(short[].class)) {
            return Short[].class;
        }
        if (clazz.isAssignableFrom(float[].class)) {
            return Float[].class;
        }
        if (clazz.isAssignableFrom(double[].class)) {
            return Double[].class;
        }
        if (clazz.isAssignableFrom(long[].class)) {
            return Long[].class;
        }
        return clazz;
    }

    protected boolean isArray(Class<?> clazz) {
        return clazz.isArray();
    }

    private void addPrimaryKey(Table ormTable, org.teiid.metadata.Table view, MetadataFactory mf) {
        PrimaryKey pk = ormTable.getPrimaryKey();
        ArrayList<String> pkColumns = new ArrayList<String>();
        if (pk != null) {
            Iterator it = pk.getColumnIterator();
            while (it.hasNext()) {
                Column c = (Column)it.next();
                org.teiid.metadata.Column col = view.getColumnByName(c.getName());
                if (pk.isGenerated((Dialect)dialect)) {
                    col.setAutoIncremented(true);
                }
                pkColumns.add(c.getName());
            }
            mf.addPrimaryKey("PK", pkColumns, view);
        }
    }

    private void addIndexKeys(Table ormTable, org.teiid.metadata.Table view, MetadataFactory mf) {
        Iterator keys = ormTable.getUniqueKeyIterator();
        while (keys.hasNext()) {
            UniqueKey uk = (UniqueKey)keys.next();
            ArrayList<String> columns = new ArrayList<String>();
            for (Column c : uk.getColumns()) {
                columns.add(c.getName());
            }
            mf.addIndex(uk.getName(), false, columns, view);
        }
        Iterator iit = ormTable.getIndexIterator();
        while (iit.hasNext()) {
            Index idx = (Index)iit.next();
            ArrayList<String> columns = new ArrayList<String>();
            Iterator it = idx.getColumnIterator();
            while (it.hasNext()) {
                Column c = (Column)it.next();
                columns.add(c.getName());
            }
            mf.addIndex(idx.getName(), true, columns, view);
        }
    }

    private void addForeignKeys(Table ormTable, org.teiid.metadata.Table view, MetadataFactory mf) {
        Collection fks = ormTable.getForeignKeys().values();
        for (ForeignKey fk : fks) {
            List columns;
            ArrayList<String> fkColumns = new ArrayList<String>();
            ArrayList<String> refColumns = new ArrayList<String>();
            Iterator it = fk.getColumnIterator();
            while (it.hasNext()) {
                Column c = (Column)it.next();
                fkColumns.add(c.getName());
            }
            if (fk.isReferenceToPrimaryKey()) {
                columns = fk.getReferencedTable().getPrimaryKey().getColumns();
                for (Column c : columns) {
                    refColumns.add(c.getName());
                }
            } else {
                columns = fk.getReferencedColumns();
                for (Column c : columns) {
                    refColumns.add(c.getName());
                }
            }
            mf.addForeignKey(fk.getName(), fkColumns, refColumns, fk.getReferencedTable().getName(), view);
        }
    }

    private void addColumn(Table ormTable, Column ormColumn, String parent, Field attributeField, org.teiid.metadata.Table view, MetadataFactory mf, boolean last, T annotation) {
        String columnName = ormColumn.getName();
        String type = JDBCSQLTypeInfo.getTypeName((int)ormColumn.getSqlTypeCode((Mapping)this.metadata));
        if (type.equals("ARRAY")) {
            type = this.getArrayType(ormColumn);
        }
        org.teiid.metadata.Column column = mf.addColumn(columnName, type, (ColumnSet)view);
        column.setUpdatable(true);
        column.setLength(ormColumn.getLength());
        column.setScale(ormColumn.getScale());
        column.setPrecision(ormColumn.getPrecision());
        column.setNullType(ormColumn.isNullable() ? BaseColumn.NullType.Nullable : BaseColumn.NullType.No_Nulls);
        column.setDefaultValue(ormColumn.getDefaultValue());
        this.onColumnCreate(view, column, mf, attributeField, parent, last, annotation);
    }

    private String getArrayType(Column ormColumn) {
        if (ormColumn.getValue().getType() instanceof StringArrayType) {
            return "string[]";
        }
        if (ormColumn.getValue().getType() instanceof ShortArrayType) {
            return "short[]";
        }
        if (ormColumn.getValue().getType() instanceof LongArrayType) {
            return "long[]";
        }
        if (ormColumn.getValue().getType() instanceof IntArrayType) {
            return "integer[]";
        }
        if (ormColumn.getValue().getType() instanceof FloatArrayType) {
            return "float[]";
        }
        if (ormColumn.getValue().getType() instanceof DoubleArrayType) {
            return "double[]";
        }
        if (ormColumn.getValue().getType() instanceof BigDecimalArrayType) {
            return "bigdecimal[]";
        }
        if (ormColumn.getValue().getType() instanceof BooleanArrayType) {
            return "boolean[]";
        }
        if (ormColumn.getValue().getType() instanceof BigIntegerArrayType) {
            return "biginteger[]";
        }
        if (ormColumn.getValue().getType() instanceof DateArrayType) {
            return "date[]";
        }
        if (ormColumn.getValue().getType() instanceof TimeArrayType) {
            return "time[]";
        }
        if (ormColumn.getValue().getType() instanceof TimestampArrayType) {
            return "timestamp[]";
        }
        return ormColumn.getSqlType();
    }

    String propertyName(Iterator<Property> it, Property identifierProperty, String colName) {
        if (identifierProperty != null && this.propertyMatches(identifierProperty, colName)) {
            return identifierProperty.getName();
        }
        while (it.hasNext()) {
            Property property = it.next();
            if (!this.propertyMatches(property, colName)) continue;
            if (property.isComposite()) {
                Component comp = (Component)property.getValue();
                Iterator compIt = comp.getPropertyIterator();
                return this.propertyName(compIt, null, colName);
            }
            return property.getName();
        }
        return null;
    }

    boolean propertyMatches(Property property, String colName) {
        if (property.isComposite()) {
            Component comp = (Component)property.getValue();
            Iterator compIt = comp.getPropertyIterator();
            while (compIt.hasNext()) {
                property = (Property)compIt.next();
                if (!this.propertyMatches(property, colName)) continue;
                return true;
            }
            return false;
        }
        Iterator columnIterator = property.getColumnIterator();
        if (columnIterator.hasNext()) {
            Column col = (Column)columnIterator.next();
            assert (!columnIterator.hasNext());
            if (col.getName().equals(colName)) {
                return true;
            }
        }
        return false;
    }

    private FieldInfo getAttributeField(Class<?> entityClazz, PersistentClass hibernateClass, String columnName, FieldInfo fieldInfo) {
        String propertyName = this.propertyName(hibernateClass.getPropertyIterator(), hibernateClass.getIdentifierProperty(), columnName);
        FieldInfo attribute = new FieldInfo();
        if (propertyName != null) {
            try {
                attribute.field = entityClazz.getDeclaredField(propertyName);
            }
            catch (NoSuchFieldException | SecurityException e) {
                for (Field field : entityClazz.getDeclaredFields()) {
                    Embedded embedded = field.getAnnotation(Embedded.class);
                    if (embedded == null) continue;
                    attribute = this.getAttributeField(field.getType(), hibernateClass, columnName, fieldInfo);
                    if (attribute.field == null) continue;
                    fieldInfo.field = attribute.field;
                    fieldInfo.path = fieldInfo.path == null ? field.getName() : field.getName() + "/" + fieldInfo.path;
                    attribute = fieldInfo;
                    break;
                }
            }
        }
        return attribute;
    }

    public static boolean isBuiltInModel(String name) {
        return name.equals("file") || name.equals("rest");
    }

    static class FieldInfo {
        Field field;
        String path;

        FieldInfo() {
        }
    }
}

