/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.autoconfigure;

import com.zaxxer.hikari.pool.ProxyConnection;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.sql.Driver;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.transaction.jta.JtaAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.Scope;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;
import org.springframework.jdbc.datasource.embedded.ConnectionProperties;
import org.springframework.jdbc.datasource.embedded.DataSourceFactory;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseConfigurer;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseFactory;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.caffeine.CaffeineCacheFactory;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.deployers.VDBRepository;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.metadatastore.DeploymentBasedDatabaseStore;
import org.teiid.net.socket.SocketUtil;
import org.teiid.query.metadata.NioVirtualFile;
import org.teiid.query.metadata.NioZipFileSystem;
import org.teiid.query.metadata.VDBResources;
import org.teiid.query.metadata.VirtualFile;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.security.SecurityHelper;
import org.teiid.spring.autoconfigure.PlatformTransactionManagerAdapter;
import org.teiid.spring.autoconfigure.TeiidDatabaseConfigurer;
import org.teiid.spring.autoconfigure.TeiidInitializer;
import org.teiid.spring.autoconfigure.TeiidPostProcessor;
import org.teiid.spring.autoconfigure.TeiidProperties;
import org.teiid.spring.autoconfigure.TeiidServer;
import org.teiid.spring.autoconfigure.TeiidSpringDriver;
import org.teiid.spring.autoconfigure.TransactionManagerConfiguration;
import org.teiid.spring.common.ExternalSources;
import org.teiid.spring.data.file.FileConnectionFactory;
import org.teiid.spring.identity.SpringSecurityHelper;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;
import org.teiid.transport.SocketConfiguration;
import org.teiid.transport.WireProtocol;
import org.xml.sax.SAXException;

@Configuration
@ConditionalOnClass(value={EmbeddedServer.class, ExecutionFactory.class})
@EnableConfigurationProperties(value={TeiidProperties.class})
@Import(value={TeiidPostProcessor.Registrar.class, TransactionManagerConfiguration.class})
@PropertySource(value={"classpath:teiid.properties"})
@AutoConfigureAfter(value={JtaAutoConfiguration.class})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
public class TeiidAutoConfiguration {
    static final String IMPLICIT_VDB = "implicit";
    public static ThreadLocal<TeiidServer> serverContext = new ThreadLocal();
    private static final Log logger = LogFactory.getLog(TeiidAutoConfiguration.class);
    @Autowired(required=false)
    private EmbeddedConfiguration embeddedConfiguration;
    @Autowired(required=false)
    private PlatformTransactionManagerAdapter platformTransactionManagerAdapter;
    @Autowired
    private TeiidProperties properties;
    @Autowired
    ApplicationContext context;
    @Value(value="${spring.jpa.hibernate.naming.physical-strategy:org.springframework.boot.orm.jpa.hibernate.SpringPhysicalNamingStrategy}")
    private String hibernateNamingClass;

    @Bean
    @ConditionalOnMissingBean
    public TeiidInitializer teiidInitializer(ApplicationContext applicationContext) {
        return new TeiidInitializer(applicationContext);
    }

    @Bean(name={"dataSource"})
    @Primary
    @ConfigurationProperties(prefix="spring.datasource")
    public DataSource getDataSource(final TeiidServer server, final VDBMetaData vdb) {
        EmbeddedDatabaseFactory edf = new EmbeddedDatabaseFactory();
        edf.setDatabaseConfigurer((EmbeddedDatabaseConfigurer)new TeiidDatabaseConfigurer(server));
        edf.setDataSourceFactory(new DataSourceFactory(){

            public DataSource getDataSource() {
                String url = TeiidAutoConfiguration.this.context.getEnvironment().getProperty("spring.datasource.teiid.url");
                return new SimpleDriverDataSource((Driver)new TeiidSpringDriver((Driver)server.getDriver(), server, vdb), url);
            }

            public ConnectionProperties getConnectionProperties() {
                return new ConnectionProperties(){

                    public void setDriverClass(Class<? extends Driver> driverClass) {
                    }

                    public void setUrl(String url) {
                    }

                    public void setUsername(String username) {
                    }

                    public void setPassword(String password) {
                    }
                };
            }
        });
        return edf.getDatabase();
    }

    @Bean
    @ConditionalOnMissingBean
    public VDBMetaData teiidVDB() {
        List<Resource> resources = null;
        if (this.properties.getVdbFile() != null) {
            resources = TeiidInitializer.getClasspathResources(this.context, this.properties.getVdbFile());
            if (resources.isEmpty()) {
                throw new IllegalStateException("Failed to find" + this.properties.getVdbFile());
            }
        } else {
            resources = TeiidInitializer.getClasspathResources(this.context, "teiid.ddl", "teiid.vdb");
        }
        VDBMetaData vdb = null;
        if (!resources.isEmpty()) {
            Resource resource = resources.iterator().next();
            if (resource.getFilename().endsWith(".ddl")) {
                try {
                    DeploymentBasedDatabaseStore store = new DeploymentBasedDatabaseStore(new VDBRepository());
                    String db = ObjectConverterUtil.convertToString((InputStream)resources.get(0).getInputStream());
                    vdb = store.getVDBMetadata(db);
                    VDBResources vdbResources = this.buildVdbResources(resource.getFile().getParent());
                    vdb.addAttachment(VDBResources.class, (Object)vdbResources);
                    logger.info((Object)("Predefined VDB found = " + resource.getFilename()));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to parse the VDB defined");
                }
            }
            if (resource.getFilename().endsWith("-vdb.xml")) {
                try {
                    vdb = VDBMetadataParser.unmarshall((InputStream)resource.getInputStream());
                    VDBResources vdbResources = this.buildVdbResources(resource.getFile().getParent());
                    vdb.addAttachment(VDBResources.class, (Object)vdbResources);
                    logger.info((Object)("Predefined VDB found = " + resource.getFilename()));
                }
                catch (IOException | XMLStreamException e) {
                    throw new IllegalStateException("Failed to load the VDB defined", e);
                }
            }
            if (resource.getFilename().endsWith(".vdb")) {
                try {
                    vdb = this.loadVDB(resource);
                    logger.info((Object)("Predefined VDB found = " + resource.getFilename()));
                }
                catch (IOException | URISyntaxException | VirtualDatabaseException | ConnectorManagerRepository.ConnectorManagerException | TranslatorException e) {
                    throw new IllegalStateException("Failed to load the VDB defined", e);
                }
            }
        }
        if (vdb == null) {
            vdb = new VDBMetaData();
            vdb.addProperty(IMPLICIT_VDB, "true");
            vdb.setName("spring");
            vdb.setVersion("1.0.0");
        }
        return vdb;
    }

    private VDBResources buildVdbResources(String curdir) throws IOException {
        List<Resource> resources = TeiidInitializer.getClasspathResources(this.context, "*.ddl", "*.sql", "*/*.ddl", "*/*.sql");
        LinkedHashMap<String, VDBResources.Resource> files = new LinkedHashMap<String, VDBResources.Resource>();
        for (Resource r : resources) {
            Path p = r.getFile().toPath();
            String path = p.toString().replace(curdir, "");
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            files.put(path, new VDBResources.Resource((VirtualFile)new NioVirtualFile(p)));
        }
        VDBResources vdbResources = new VDBResources((VirtualFile)new NioVirtualFile(Paths.get("application.properties", new String[0])));
        vdbResources.getEntriesPlusVisibilities().putAll(files);
        return vdbResources;
    }

    private VDBMetaData loadVDB(Resource resource) throws VirtualDatabaseException, ConnectorManagerRepository.ConnectorManagerException, TranslatorException, IOException, URISyntaxException {
        VDBMetaData metadata;
        File f = File.createTempFile("temp", null);
        ObjectConverterUtil.write((InputStream)resource.getInputStream(), (File)f);
        f.deleteOnExit();
        NioVirtualFile root = NioZipFileSystem.mount((URL)f.toURI().toURL());
        VirtualFile vdbMetadata = root.getChild("/vdb.xml");
        if (!vdbMetadata.exists()) {
            vdbMetadata = root.getChild("/META-INF/vdb.xml");
        }
        if (vdbMetadata.exists()) {
            try {
                VDBMetadataParser.validate((InputStream)vdbMetadata.openStream());
            }
            catch (SAXException e) {
                throw new VirtualDatabaseException((Exception)e);
            }
            InputStream is = vdbMetadata.openStream();
            try {
                metadata = VDBMetadataParser.unmarshall((InputStream)is);
            }
            catch (XMLStreamException e) {
                throw new VirtualDatabaseException((Exception)e);
            }
        }
        vdbMetadata = root.getChild("/vdb.ddl");
        if (!vdbMetadata.exists()) {
            vdbMetadata = root.getChild("/META-INF/vdb.ddl");
        }
        DeploymentBasedDatabaseStore store = new DeploymentBasedDatabaseStore(new VDBRepository());
        try {
            metadata = store.getVDBMetadata(ObjectConverterUtil.convertToString((InputStream)vdbMetadata.openStream()));
        }
        catch (IOException e) {
            throw new VirtualDatabaseException("Could not find a vdb.xml or vdb.ddl file in " + resource.getFilename());
        }
        metadata.addAttachment(VirtualFile.class, (Object)root);
        VDBResources resources = new VDBResources((VirtualFile)root);
        metadata.addAttachment(VDBResources.class, (Object)resources);
        return metadata;
    }

    @Bean(name={"teiid"})
    @ConditionalOnMissingBean
    @Scope(value="singleton")
    public TeiidServer teiidServer(SpringSecurityHelper securityHelper, TransactionManager transactionManager, ExternalSources sources) {
        logger.info((Object)"Starting Teiid Server.");
        System.setProperty("org.teiid.addPGMetadata", Boolean.toString(this.properties.isPgEnable() || this.properties.isPgSecureEnable()));
        System.setProperty("org.teiid.hiddenMetadataResolvable", "false");
        System.setProperty("org.teiid.allowAlter", Boolean.toString(this.properties.isAllowAlter()));
        TeiidServer server = new TeiidServer(sources);
        if (this.embeddedConfiguration == null) {
            SocketConfiguration sc;
            this.embeddedConfiguration = new EmbeddedConfiguration();
            this.embeddedConfiguration.setCacheFactory((CacheFactory)new CaffeineCacheFactory());
            if (this.properties.getNodeName() != null) {
                String nodeName = this.properties.getNodeName();
                if (this.properties.getPodName() != null) {
                    nodeName = this.properties.getPodName();
                }
                this.embeddedConfiguration.setNodeName(nodeName);
            }
            if (this.properties.isJdbcEnable()) {
                sc = new SocketConfiguration();
                sc.setBindAddress(this.properties.getHostName());
                sc.setPortNumber(this.properties.getJdbcPort());
                sc.setProtocol(WireProtocol.teiid);
                this.embeddedConfiguration.addTransport(sc);
                logger.info((Object)("JDBC is opened on = " + this.properties.getHostName() + ":" + this.properties.getJdbcPort()));
            }
            if (this.properties.isJdbcSecureEnable()) {
                sc = new SocketConfiguration();
                sc.setBindAddress(this.properties.getHostName());
                sc.setPortNumber(this.properties.getJdbcSecurePort());
                sc.setProtocol(WireProtocol.teiid);
                sc.setSSLConfiguration(this.properties.getSsl());
                this.embeddedConfiguration.addTransport(sc);
                logger.info((Object)("Secure JDBC is opened on = " + this.properties.getHostName() + ":" + this.properties.getJdbcSecurePort()));
            }
            if (this.properties.isPgEnable()) {
                sc = new SocketConfiguration();
                sc.setBindAddress(this.properties.getHostName());
                sc.setPortNumber(this.properties.getPgPort());
                sc.setProtocol(WireProtocol.pg);
                this.embeddedConfiguration.addTransport(sc);
                logger.info((Object)("PG is opened on = " + this.properties.getHostName() + ":" + this.properties.getPgPort()));
            }
            if (this.properties.isPgSecureEnable()) {
                sc = new SocketConfiguration();
                sc.setBindAddress(this.properties.getHostName());
                sc.setPortNumber(this.properties.getPgSecurePort());
                sc.setProtocol(WireProtocol.pg);
                sc.setSSLConfiguration(this.properties.getSsl());
                this.embeddedConfiguration.addTransport(sc);
                logger.info((Object)("Secure PG is opened on = " + this.properties.getHostName() + ":" + this.properties.getPgSecurePort()));
            }
        }
        if (this.embeddedConfiguration.getTransactionManager() == null) {
            this.embeddedConfiguration.setTransactionManager(transactionManager);
            if (transactionManager == this.platformTransactionManagerAdapter) {
                server.setPlatformTransactionManagerAdapter(this.platformTransactionManagerAdapter);
            } else {
                logger.info((Object)"Transaction Manager found and being registed into Teiid.");
            }
        } else if (transactionManager != null && transactionManager != this.embeddedConfiguration.getTransactionManager()) {
            throw new IllegalStateException("TransactionManager defined in both Spring and on the EmbeddedConfiguration.  Only one is expected.");
        }
        if (this.embeddedConfiguration.getSecurityHelper() == null) {
            this.embeddedConfiguration.setSecurityDomain("spring-security");
            this.embeddedConfiguration.setSecurityHelper((SecurityHelper)securityHelper);
        }
        server.start(this.embeddedConfiguration);
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("spring");
        vdb.setVersion("1.0.0");
        server.deployVDB(vdb, false, this.context);
        serverContext.set(server);
        return server;
    }

    @Bean
    @ConditionalOnMissingBean
    @Scope(value="singleton")
    public SpringSecurityHelper securityHelper() {
        return new SpringSecurityHelper();
    }

    @Bean(name={"file"})
    @ConditionalOnMissingBean
    @ConfigurationProperties(prefix="spring.teiid.file")
    public FileConnectionFactory fileConnectionFactory() {
        return new FileConnectionFactory();
    }

    @Bean(name={"teiidNamingStrategy"})
    public PhysicalNamingStrategy teiidNamingStrategy() {
        try {
            return (PhysicalNamingStrategy)Class.forName(this.hibernateNamingClass).getDeclaredConstructors()[0].newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            return null;
        }
    }

    @PostConstruct
    private void applyErrorStateHack() {
        try {
            Field field = ProxyConnection.class.getDeclaredField("ERROR_STATES");
            field.setAccessible(true);
            Set errorStates = (Set)field.get(null);
            errorStates.remove("0A000");
        }
        catch (Exception sqle) {
            logger.warn((Object)"Unable to apply error state hack", (Throwable)sqle);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public KeyManager keyManager() throws IOException {
        try {
            KeyManager[] km = this.properties.getSsl().getKeyManagers();
            if (km != null && km.length > 0) {
                return km[0];
            }
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
        return null;
    }

    @Bean
    @ConditionalOnMissingBean
    public TrustManager trustManager() throws IOException {
        try {
            TrustManager[] tm = this.properties.getSsl().getTrustManagers();
            if (tm != null && tm.length > 0) {
                return tm[0];
            }
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
        return SocketUtil.getTrustAllManagers()[0];
    }

    @Bean
    @ConditionalOnMissingBean
    public ExternalSources externalSources() {
        return new ExternalSources();
    }
}

