/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.identity;

import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.teiid.security.Credentials;
import org.teiid.security.GSSResult;
import org.teiid.security.SecurityHelper;
import org.teiid.spring.identity.SimpleGroup;
import org.teiid.spring.identity.SimplePrincipal;

public class SpringSecurityHelper
implements SecurityHelper {
    private static final String ANONYMOUS = "anonymous";
    private static final Log logger = LogFactory.getLog(SpringSecurityHelper.class);
    private AuthenticationManager authenticationManager;

    public Object associateSecurityContext(Object newContext) {
        Authentication context = SecurityContextHolder.getContext().getAuthentication();
        if (newContext != context) {
            SecurityContextHolder.getContext().setAuthentication((Authentication)newContext);
        }
        return context;
    }

    public void clearSecurityContext() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public Object getSecurityContext(String securityDomain) {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    public Subject getSubjectInContext(Object context) {
        if (!(context instanceof Authentication)) {
            return null;
        }
        Authentication sc = (Authentication)context;
        return this.buildSubject(sc);
    }

    public Object authenticate(String securityDomain, String baseUserName, Credentials credentials, String applicationName) throws LoginException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (this.authenticationManager != null) {
            if (authentication == null) {
                UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)baseUserName, credentials == null ? null : credentials.getCredentials());
                try {
                    authentication = this.authenticationManager.authenticate((Authentication)token);
                }
                catch (AuthenticationException e) {
                    throw new LoginException(e.getMessage());
                }
            }
        } else {
            return null;
        }
        baseUserName = authentication.getName();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Logged in user: " + baseUserName));
        }
        return authentication;
    }

    public GSSResult negotiateGssLogin(String securityDomain, byte[] serviceTicket) throws LoginException {
        return null;
    }

    private Subject buildSubject(Authentication authentication) {
        Subject s = new Subject();
        s.getPrincipals().add(new SimplePrincipal(authentication == null ? ANONYMOUS : authentication.getName()));
        if (authentication != null) {
            SimpleGroup g = new SimpleGroup("Roles");
            for (GrantedAuthority ga : authentication.getAuthorities()) {
                String role = ga.getAuthority();
                g.addMember(new SimplePrincipal(role));
            }
            s.getPrincipals().add(g);
        }
        return s;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }
}

