/*
 * Decompiled with CFR 0.152.
 */
package org.teiid;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.VDBImportMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;

@Mojo(name="vdb", requiresDependencyResolution=ResolutionScope.COMPILE)
public class VdbMojo
extends AbstractMojo {
    private static final String SLASH = "/";
    @Parameter(defaultValue="${basedir}/src/main/vdb/META-INF/vdb.xml")
    private File vdbXmlFile;
    @Parameter(defaultValue="${basedir}/src/main/vdb")
    private File vdbFolder;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="project.build.directory", readonly=true)
    private File outputDirectory;
    @Parameter(property="project.build.finalName", readonly=true)
    private String finalName;
    @Parameter
    private File[] includes;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classesDirectory;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        VDBMetaData top;
        LinkedHashSet<File> directories;
        ArchiveOutputStream archive;
        block25: {
            Iterator iterator;
            ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
            ClassLoader pluginClassloader = this.getClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(pluginClassloader);
                File artifact = new File(this.outputDirectory, this.finalName + ".vdb");
                this.project.getArtifact().setFile(artifact);
                try {
                    File vdb;
                    block24: {
                        archive = this.getStream(artifact);
                        vdb = this.getVDBFile();
                        if (vdb == null) {
                            throw new MojoExecutionException("No VDB File found in directory" + this.vdbFolder);
                        }
                        directories = new LinkedHashSet<File>();
                        this.gatherContents(this.classesDirectory, directories);
                        this.gatherContents(this.vdbFolder, directories);
                        if (this.includes != null) {
                            this.add(archive, "", this.includes);
                        }
                        if (!vdb.getName().endsWith("-vdb.ddl")) break block24;
                        this.addFile(archive, "META-INF/vdb.ddl", vdb);
                        if (archive == null) return;
                        archive.close();
                        return;
                    }
                    top = VDBMetadataParser.unmarshell((InputStream)new FileInputStream(vdb));
                    if (top.getVDBImports().isEmpty()) break block25;
                    Set dependencies = this.project.getDependencyArtifacts();
                    iterator = dependencies.iterator();
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Exception when creating artifact archive.", e);
                }
            }
            catch (MojoExecutionException e) {
                throw new MojoExecutionException("Error running the vdb-maven-plugin.", (Exception)((Object)e));
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
            while (iterator.hasNext()) {
                Artifact d = (Artifact)iterator.next();
                if (d.getFile() == null || !d.getFile().getName().endsWith(".vdb")) continue;
                File vdbDir = this.unzipContents(d);
                File childFile = new File(vdbDir, "META-INF/vdb.xml");
                this.getLog().info((CharSequence)("Merging VDB " + childFile.getCanonicalPath()));
                VDBMetaData child = VDBMetadataParser.unmarshell((InputStream)new FileInputStream(childFile));
                if (!child.getVDBImports().isEmpty()) {
                    throw new MojoExecutionException("Nested VDB imports are not supported" + d.getArtifactId());
                }
                VDBImportMetadata matched = null;
                for (VDBImportMetadata importee : top.getVDBImports()) {
                    if (!child.getName().equals(importee.getName()) || !child.getVersion().equals(importee.getVersion())) continue;
                    this.gatherContents(vdbDir, directories);
                    top.getVisibilityOverrides().putAll(child.getVisibilityOverrides());
                    child.getModelMetaDatas().forEach((k, v) -> {
                        top.addModel(v);
                        String visibilityOverride = top.getPropertyValue(v.getName() + ".visible");
                        if (visibilityOverride != null) {
                            boolean visible = Boolean.valueOf(visibilityOverride);
                            top.setVisibilityOverride(v.getName(), visible);
                        }
                    });
                    child.getOverrideTranslatorsMap().forEach((k, v) -> top.addOverideTranslator(v));
                    if (importee.isImportDataPolicies()) {
                        for (DataPolicy dp : child.getDataPolicies()) {
                            DataPolicyMetadata role = (DataPolicyMetadata)dp;
                            if (top.addDataPolicy(role) != null) {
                                throw new MojoExecutionException(top.getName() + "." + top.getVersion() + " imports a conflicting role " + role.getName() + " from " + child.getName() + "." + child.getVersion());
                            }
                            if (!role.isGrantAll()) continue;
                            role.setSchemas(child.getModelMetaDatas().keySet());
                        }
                    }
                    matched = importee;
                    break;
                }
                if (matched == null) continue;
                top.getVDBImports().remove(matched);
            }
        }
        this.add(archive, "", directories.toArray(new File[0]));
        File finalVDB = new File(this.outputDirectory.getPath(), "vdb.xml");
        finalVDB.getParentFile().mkdirs();
        VDBMetadataParser.marshell((VDBMetaData)top, (OutputStream)new FileOutputStream(finalVDB));
        this.addFile(archive, "META-INF/vdb.xml", finalVDB);
        return;
        finally {
            if (archive != null) {
                archive.close();
            }
        }
    }

    private void gatherContents(File f, Set<File> directories) {
        if (f.exists() && f.isDirectory()) {
            File[] list = f.listFiles();
            for (File l : Objects.requireNonNull(list)) {
                if (l.isDirectory()) {
                    directories.add(l);
                }
                if (l.getName().endsWith("vdb.xml")) continue;
                directories.add(l);
            }
        }
    }

    private File unzipContents(Artifact d) throws IOException {
        File f = new File(this.outputDirectory.getPath(), d.getArtifactId());
        f.mkdirs();
        this.getLog().info((CharSequence)("unzipping " + d.getArtifactId() + " to directory " + f.getCanonicalPath()));
        byte[] buffer = new byte[1024];
        ZipInputStream zis = new ZipInputStream(new FileInputStream(d.getFile()));
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            int len;
            String fileName = ze.getName();
            this.getLog().info((CharSequence)("\t" + fileName));
            File newFile = new File(f, fileName);
            new File(newFile.getParent()).mkdirs();
            FileOutputStream fos = new FileOutputStream(newFile);
            while ((len = zis.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.close();
            zis.closeEntry();
            ze = zis.getNextEntry();
        }
        zis.close();
        return f;
    }

    private File getVDBFile() {
        File[] list;
        if (this.vdbXmlFile.exists()) {
            this.getLog().info((CharSequence)("Found VDB = " + this.vdbXmlFile));
            return this.vdbXmlFile;
        }
        if (this.vdbFolder.exists() && this.vdbFolder.isDirectory() && ((list = this.vdbFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("-vdb.xml") || name.endsWith("-vdb.ddl");
            }
        })) != null ? list.length : 0) != 0) {
            this.getLog().info((CharSequence)("Found VDB = " + list[0].getName()));
            return list[0];
        }
        return null;
    }

    private void addFile(ArchiveOutputStream archive, String name, File file) throws IOException {
        this.getLog().info((CharSequence)("Adding file = " + name + " from " + file.getCanonicalPath()));
        ArchiveEntry entry = this.entry(file, name);
        archive.putArchiveEntry(entry);
        IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)archive);
        archive.closeArchiveEntry();
    }

    private void add(ArchiveOutputStream archive, String path, File ... files) throws IOException {
        for (File file : files) {
            if (!file.exists()) {
                throw new FileNotFoundException("Folder or file not found: " + file.getPath());
            }
            String name = path + file.getName();
            if (file.isDirectory()) {
                this.add(archive, name + SLASH, Objects.requireNonNull(file.listFiles()));
                continue;
            }
            if (name.endsWith("vdb.xml") || name.endsWith("vdb.ddl")) continue;
            this.addFile(archive, name, file);
        }
    }

    private ClassLoader getClassLoader() throws MojoExecutionException {
        try {
            ArrayList<URL> pathUrls = new ArrayList<URL>();
            for (String mavenCompilePath : this.project.getCompileClasspathElements()) {
                pathUrls.add(new File(mavenCompilePath).toURI().toURL());
            }
            URL[] urlsForClassLoader = pathUrls.toArray(new URL[pathUrls.size()]);
            this.getLog().debug((CharSequence)("urls for URLClassLoader: " + Arrays.asList(urlsForClassLoader)));
            return new URLClassLoader(urlsForClassLoader, VdbMojo.class.getClassLoader());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Couldn't create a classloader.", e);
        }
    }

    protected ArchiveOutputStream getStream(File artifact) throws IOException {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        FileOutputStream output = new FileOutputStream(artifact);
        try {
            return new ArchiveStreamFactory().createArchiveOutputStream("zip", (OutputStream)output);
        }
        catch (ArchiveException e) {
            throw new IOException(e);
        }
    }

    protected ArchiveEntry entry(File file, String name) {
        return new ZipArchiveEntry(file, name);
    }
}

