/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.abilitybots.api.objects;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Arrays;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.api.objects.User;

public class MessageContext {
    private final User user;
    private final Long chatId;
    private final String[] arguments;
    private final Update update;

    private MessageContext(Update update, User user, Long chatId, String[] arguments) {
        this.user = user;
        this.chatId = chatId;
        this.update = update;
        this.arguments = arguments;
    }

    public static MessageContext newContext(Update update, User user, Long chatId, String ... arguments) {
        return new MessageContext(update, user, chatId, arguments);
    }

    public User user() {
        return this.user;
    }

    public Long chatId() {
        return this.chatId;
    }

    public String[] arguments() {
        return this.arguments;
    }

    public String firstArg() {
        this.checkLength();
        return this.arguments[0];
    }

    public String secondArg() {
        this.checkLength();
        return this.arguments[1 % this.arguments.length];
    }

    public String thirdArg() {
        this.checkLength();
        return this.arguments[2 % this.arguments.length];
    }

    public Update update() {
        return this.update;
    }

    private void checkLength() {
        if (this.arguments.length == 0) {
            throw new IllegalStateException("This message has no arguments");
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("user", (Object)this.user).add("chatId", (Object)this.chatId).add("arguments", (Object)this.arguments).add("update", (Object)this.update).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageContext that = (MessageContext)o;
        return Objects.equal((Object)this.user, (Object)that.user) && Objects.equal((Object)this.chatId, (Object)that.chatId) && Arrays.equals(this.arguments, that.arguments) && Objects.equal((Object)this.update, (Object)that.update);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.user, this.chatId, Arrays.hashCode(this.arguments), this.update});
    }
}

