/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.abilitybots.api.util;

import com.google.common.base.Strings;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.telegram.abilitybots.api.db.DBContext;
import org.telegram.abilitybots.api.objects.Flag;
import org.telegram.abilitybots.api.objects.MessageContext;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.api.objects.User;

public final class AbilityUtils {
    public static User EMPTY_USER = new User(Integer.valueOf(0), "", Boolean.valueOf(false), "", "", "");

    private AbilityUtils() {
    }

    public static String stripTag(String username) {
        String lowerCase = username.toLowerCase();
        return lowerCase.startsWith("@") ? lowerCase.substring(1, lowerCase.length()) : lowerCase;
    }

    public static Consumer<MessageContext> commitTo(DBContext db) {
        return ctx -> db.commit();
    }

    public static User getUser(Update update) {
        if (Flag.MESSAGE.test(update)) {
            return update.getMessage().getFrom();
        }
        if (Flag.CALLBACK_QUERY.test(update)) {
            return update.getCallbackQuery().getFrom();
        }
        if (Flag.INLINE_QUERY.test(update)) {
            return update.getInlineQuery().getFrom();
        }
        if (Flag.CHANNEL_POST.test(update)) {
            return update.getChannelPost().getFrom();
        }
        if (Flag.EDITED_CHANNEL_POST.test(update)) {
            return update.getEditedChannelPost().getFrom();
        }
        if (Flag.EDITED_MESSAGE.test(update)) {
            return update.getEditedMessage().getFrom();
        }
        if (Flag.CHOSEN_INLINE_QUERY.test(update)) {
            return update.getChosenInlineQuery().getFrom();
        }
        if (Flag.SHIPPING_QUERY.test(update)) {
            return update.getShippingQuery().getFrom();
        }
        if (Flag.PRECHECKOUT_QUERY.test(update)) {
            return update.getPreCheckoutQuery().getFrom();
        }
        if (Flag.POLL_ANSWER.test(update)) {
            return update.getPollAnswer().getUser();
        }
        if (Flag.POLL.test(update)) {
            return EMPTY_USER;
        }
        throw new IllegalStateException("Could not retrieve originating user from update");
    }

    public static boolean isGroupUpdate(Update update) {
        if (Flag.MESSAGE.test(update)) {
            return update.getMessage().isGroupMessage();
        }
        if (Flag.CALLBACK_QUERY.test(update)) {
            return update.getCallbackQuery().getMessage().isGroupMessage();
        }
        if (Flag.CHANNEL_POST.test(update)) {
            return update.getChannelPost().isGroupMessage();
        }
        if (Flag.EDITED_CHANNEL_POST.test(update)) {
            return update.getEditedChannelPost().isGroupMessage();
        }
        if (Flag.EDITED_MESSAGE.test(update)) {
            return update.getEditedMessage().isGroupMessage();
        }
        return false;
    }

    public static boolean isSuperGroupUpdate(Update update) {
        if (Flag.MESSAGE.test(update)) {
            return update.getMessage().isSuperGroupMessage();
        }
        if (Flag.CALLBACK_QUERY.test(update)) {
            return update.getCallbackQuery().getMessage().isSuperGroupMessage();
        }
        if (Flag.CHANNEL_POST.test(update)) {
            return update.getChannelPost().isSuperGroupMessage();
        }
        if (Flag.EDITED_CHANNEL_POST.test(update)) {
            return update.getEditedChannelPost().isSuperGroupMessage();
        }
        if (Flag.EDITED_MESSAGE.test(update)) {
            return update.getEditedMessage().isSuperGroupMessage();
        }
        return false;
    }

    public static Long getChatId(Update update) {
        if (Flag.MESSAGE.test(update)) {
            return update.getMessage().getChatId();
        }
        if (Flag.CALLBACK_QUERY.test(update)) {
            return update.getCallbackQuery().getMessage().getChatId();
        }
        if (Flag.INLINE_QUERY.test(update)) {
            return (long)update.getInlineQuery().getFrom().getId();
        }
        if (Flag.CHANNEL_POST.test(update)) {
            return update.getChannelPost().getChatId();
        }
        if (Flag.EDITED_CHANNEL_POST.test(update)) {
            return update.getEditedChannelPost().getChatId();
        }
        if (Flag.EDITED_MESSAGE.test(update)) {
            return update.getEditedMessage().getChatId();
        }
        if (Flag.CHOSEN_INLINE_QUERY.test(update)) {
            return (long)update.getChosenInlineQuery().getFrom().getId();
        }
        if (Flag.SHIPPING_QUERY.test(update)) {
            return (long)update.getShippingQuery().getFrom().getId();
        }
        if (Flag.PRECHECKOUT_QUERY.test(update)) {
            return (long)update.getPreCheckoutQuery().getFrom().getId();
        }
        if (Flag.POLL_ANSWER.test(update)) {
            return (long)update.getPollAnswer().getUser().getId();
        }
        if (Flag.POLL.test(update)) {
            return (long)EMPTY_USER.getId();
        }
        throw new IllegalStateException("Could not retrieve originating chat ID from update");
    }

    public static boolean isUserMessage(Update update) {
        if (Flag.MESSAGE.test(update)) {
            return update.getMessage().isUserMessage();
        }
        if (Flag.CALLBACK_QUERY.test(update)) {
            return update.getCallbackQuery().getMessage().isUserMessage();
        }
        if (Flag.CHANNEL_POST.test(update)) {
            return update.getChannelPost().isUserMessage();
        }
        if (Flag.EDITED_CHANNEL_POST.test(update)) {
            return update.getEditedChannelPost().isUserMessage();
        }
        if (Flag.EDITED_MESSAGE.test(update)) {
            return update.getEditedMessage().isUserMessage();
        }
        return true;
    }

    public static String addTag(String username) {
        return "@" + username;
    }

    public static Predicate<Update> isReplyTo(String msg) {
        return update -> update.getMessage().getReplyToMessage().getText().equals(msg);
    }

    public static String getLocalizedMessage(String messageCode, Locale locale, Object ... arguments) {
        ResourceBundle bundle;
        if (locale == null) {
            bundle = ResourceBundle.getBundle("messages", Locale.ROOT);
        } else {
            try {
                bundle = ResourceBundle.getBundle("messages", locale, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES));
            }
            catch (MissingResourceException e) {
                bundle = ResourceBundle.getBundle("messages", Locale.ROOT);
            }
        }
        String message = bundle.getString(messageCode);
        return MessageFormat.format(message, arguments);
    }

    public static String getLocalizedMessage(String messageCode, String languageCode, Object ... arguments) {
        Locale locale = Strings.isNullOrEmpty((String)languageCode) ? null : Locale.forLanguageTag(languageCode);
        return AbilityUtils.getLocalizedMessage(messageCode, locale, arguments);
    }

    public static String shortName(User user) {
        if (!StringUtils.isEmpty((CharSequence)user.getFirstName())) {
            return user.getFirstName();
        }
        if (!StringUtils.isEmpty((CharSequence)user.getLastName())) {
            return user.getLastName();
        }
        return user.getUserName();
    }

    public static String fullName(User user) {
        StringJoiner name = new StringJoiner(" ");
        if (!StringUtils.isEmpty((CharSequence)user.getFirstName())) {
            name.add(user.getFirstName());
        }
        if (!StringUtils.isEmpty((CharSequence)user.getLastName())) {
            name.add(user.getLastName());
        }
        return name.toString();
    }

    public static String escape(String username) {
        return username.replace("_", "\\_");
    }
}

