/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.abilitybots.api.objects;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.telegram.abilitybots.api.bot.BaseAbilityBot;
import org.telegram.abilitybots.api.db.DBContext;
import org.telegram.abilitybots.api.objects.Reply;
import org.telegram.abilitybots.api.util.AbilityUtils;
import org.telegram.telegrambots.meta.api.objects.Update;

public class ReplyFlow
extends Reply {
    private final Set<Reply> nextReplies;

    private ReplyFlow(List<Predicate<Update>> conditions, BiConsumer<BaseAbilityBot, Update> action, Set<Reply> nextReplies, String name) {
        super(conditions, action, name);
        this.nextReplies = nextReplies;
    }

    public static ReplyFlowBuilder builder(DBContext db) {
        return new ReplyFlowBuilder(db);
    }

    public static ReplyFlowBuilder builder(DBContext db, int id) {
        return new ReplyFlowBuilder(db, id);
    }

    public Set<Reply> nextReplies() {
        return this.nextReplies;
    }

    @Override
    public Stream<Reply> stream() {
        return Stream.concat(Stream.of(this), this.nextReplies.stream().flatMap(Reply::stream));
    }

    public static class ReplyFlowBuilder {
        public static final String STATES = "user_state_replies";
        private static AtomicInteger replyCounter = new AtomicInteger();
        private final DBContext db;
        private final int id;
        private List<Predicate<Update>> conds = new ArrayList<Predicate<Update>>();
        private BiConsumer<BaseAbilityBot, Update> action;
        private Set<Reply> nextReplies = new HashSet<Reply>();
        private String name;

        private ReplyFlowBuilder(DBContext db, int id) {
            this.db = db;
            this.id = id;
        }

        private ReplyFlowBuilder(DBContext db) {
            this(db, replyCounter.getAndIncrement());
        }

        public ReplyFlowBuilder action(BiConsumer<BaseAbilityBot, Update> action) {
            this.action = action;
            return this;
        }

        public ReplyFlowBuilder enableStats(String name) {
            this.name = name;
            return this;
        }

        public ReplyFlowBuilder onlyIf(Predicate<Update> pred) {
            this.conds.add(pred);
            return this;
        }

        public ReplyFlowBuilder next(Reply nextReply) {
            List<Predicate<Update>> statefulConditions = this.toStateful(nextReply.conditions());
            BiConsumer<BaseAbilityBot, Update> statefulAction = nextReply.action().andThen((unused, upd) -> {
                Long chatId = AbilityUtils.getChatId(upd);
                this.db.getMap(STATES).remove(chatId);
            });
            Reply statefulReply = new Reply(statefulConditions, statefulAction, nextReply.name());
            this.nextReplies.add(statefulReply);
            return this;
        }

        public ReplyFlowBuilder next(ReplyFlow nextReplyFlow) {
            List<Predicate<Update>> statefulConditions = this.toStateful(nextReplyFlow.conditions());
            ReplyFlow statefulReplyFlow = new ReplyFlow(statefulConditions, nextReplyFlow.action(), nextReplyFlow.nextReplies(), nextReplyFlow.name());
            this.nextReplies.add(statefulReplyFlow);
            return this;
        }

        public ReplyFlow build() {
            if (this.action == null) {
                this.action = (bot, upd) -> {};
            }
            BiConsumer<BaseAbilityBot, Update> statefulAction = this.nextReplies.size() > 0 ? this.action.andThen((bot, upd) -> {
                Long chatId = AbilityUtils.getChatId(upd);
                this.db.getMap(STATES).put(chatId, this.id);
            }) : this.action.andThen((bot, upd) -> {
                Long chatId = AbilityUtils.getChatId(upd);
                this.db.getMap(STATES).remove(chatId);
            });
            return new ReplyFlow(this.conds, statefulAction, this.nextReplies, this.name);
        }

        @NotNull
        private List<Predicate<Update>> toStateful(List<Predicate<Update>> conditions) {
            ArrayList statefulConditions = Lists.newArrayList(conditions);
            statefulConditions.add(0, upd -> {
                Long chatId = AbilityUtils.getChatId(upd);
                int stateId = this.db.getMap(STATES).getOrDefault(chatId, -1);
                return this.id == stateId;
            });
            return statefulConditions;
        }
    }
}

