/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.client.okhttp;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.telegram.telegrambots.meta.api.methods.botapimethods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;

class OkHttpFutureCallback<T extends Serializable, Method extends PartialBotApiMethod<T>>
extends CompletableFuture<T>
implements Callback {
    private final Method method;

    OkHttpFutureCallback(Method method) {
        this.method = method;
    }

    public void onFailure(@NonNull Call call, @NonNull IOException exception) {
        if (call == null) {
            throw new NullPointerException("call is marked non-null but is null");
        }
        if (exception == null) {
            throw new NullPointerException("exception is marked non-null but is null");
        }
        this.completeExceptionally(exception);
    }

    public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
        if (call == null) {
            throw new NullPointerException("call is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        try (ResponseBody body = response.body();){
            if (body == null) {
                this.completeExceptionally(new TelegramApiException("Telegram api returned empty response"));
            } else {
                try {
                    this.complete(this.method.deserializeResponse(body.string()));
                }
                catch (TelegramApiRequestException e) {
                    this.completeExceptionally(e);
                }
            }
        }
    }
}

