/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.extensions.bots.commandbot;

import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.telegram.telegrambots.extensions.bots.commandbot.CommandBot;
import org.telegram.telegrambots.extensions.bots.commandbot.commands.CommandRegistry;
import org.telegram.telegrambots.extensions.bots.commandbot.commands.IBotCommand;
import org.telegram.telegrambots.extensions.bots.commandbot.commands.ICommandRegistry;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.api.objects.message.Message;
import org.telegram.telegrambots.meta.generics.TelegramClient;
import org.telegram.telegrambots.webhook.DefaultTelegramWebhookBot;

public abstract class TelegramWebhookCommandBot
extends DefaultTelegramWebhookBot
implements CommandBot,
ICommandRegistry {
    private final CommandRegistry commandRegistry;

    public TelegramWebhookCommandBot(TelegramClient telegramClient, boolean allowCommandsWithUsername, Supplier<String> botUsernameSupplier, String botPath, Runnable setWebhook, Runnable deleteWebhook) {
        super(botPath, null, setWebhook, deleteWebhook);
        this.commandRegistry = new CommandRegistry(telegramClient, allowCommandsWithUsername, botUsernameSupplier);
    }

    public BotApiMethod<?> consumeUpdate(Update update) {
        Message message;
        if (update.hasMessage() && (message = update.getMessage()).isCommand() && !this.filter(message)) {
            if (!this.commandRegistry.executeCommand(message)) {
                this.processInvalidCommandUpdate(update);
            }
            return null;
        }
        this.processNonCommandUpdate(update);
        return null;
    }

    @Override
    public final boolean register(IBotCommand botCommand) {
        return this.commandRegistry.register(botCommand);
    }

    @Override
    public final Map<IBotCommand, Boolean> registerAll(IBotCommand ... botCommands) {
        return this.commandRegistry.registerAll(botCommands);
    }

    @Override
    public final boolean deregister(IBotCommand botCommand) {
        return this.commandRegistry.deregister(botCommand);
    }

    @Override
    public final Map<IBotCommand, Boolean> deregisterAll(IBotCommand ... botCommands) {
        return this.commandRegistry.deregisterAll(botCommands);
    }

    @Override
    public final Collection<IBotCommand> getRegisteredCommands() {
        return this.commandRegistry.getRegisteredCommands();
    }

    @Override
    public void registerDefaultAction(BiConsumer<TelegramClient, Message> defaultConsumer) {
        this.commandRegistry.registerDefaultAction(defaultConsumer);
    }

    @Override
    public final IBotCommand getRegisteredCommand(String commandIdentifier) {
        return this.commandRegistry.getRegisteredCommand(commandIdentifier);
    }
}

