/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.longpolling;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.telegram.telegrambots.longpolling.BotSession;
import org.telegram.telegrambots.longpolling.interfaces.BackOff;
import org.telegram.telegrambots.longpolling.interfaces.LongPollingUpdateConsumer;
import org.telegram.telegrambots.longpolling.util.DefaultGetUpdatesGenerator;
import org.telegram.telegrambots.longpolling.util.ExponentialBackOff;
import org.telegram.telegrambots.longpolling.util.TelegramOkHttpClientFactory;
import org.telegram.telegrambots.meta.TelegramUrl;
import org.telegram.telegrambots.meta.api.methods.updates.GetUpdates;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;

public class TelegramBotsLongPollingApplication
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelegramBotsLongPollingApplication.class);
    private final AtomicBoolean isAppRunning = new AtomicBoolean(true);
    private final Supplier<ObjectMapper> objectMapperSupplier;
    private final Supplier<OkHttpClient> okHttpClientCreator;
    private final Supplier<ScheduledExecutorService> executorSupplier;
    private final Supplier<BackOff> backOffSupplier;
    private final ConcurrentHashMap<String, BotSession> botSessions = new ConcurrentHashMap();

    public TelegramBotsLongPollingApplication() {
        this(ObjectMapper::new);
    }

    public TelegramBotsLongPollingApplication(Supplier<ObjectMapper> objectMapperSupplier) {
        this(objectMapperSupplier, new TelegramOkHttpClientFactory.DefaultOkHttpClientCreator());
    }

    public TelegramBotsLongPollingApplication(Supplier<ObjectMapper> objectMapperSupplier, Supplier<OkHttpClient> okHttpClientCreator) {
        this(objectMapperSupplier, okHttpClientCreator, Executors::newSingleThreadScheduledExecutor);
    }

    public TelegramBotsLongPollingApplication(Supplier<ObjectMapper> objectMapperSupplier, Supplier<OkHttpClient> okHttpClientCreator, Supplier<ScheduledExecutorService> executorSupplier) {
        this(objectMapperSupplier, okHttpClientCreator, executorSupplier, ExponentialBackOff::new);
    }

    public TelegramBotsLongPollingApplication(Supplier<ObjectMapper> objectMapperSupplier, Supplier<OkHttpClient> okHttpClientCreator, Supplier<ScheduledExecutorService> executorSupplier, Supplier<BackOff> backOffSupplier) {
        this.objectMapperSupplier = objectMapperSupplier;
        this.okHttpClientCreator = okHttpClientCreator;
        this.executorSupplier = executorSupplier;
        this.backOffSupplier = backOffSupplier;
    }

    public BotSession registerBot(String botToken, LongPollingUpdateConsumer updatesConsumer) throws TelegramApiException {
        return this.registerBot(botToken, () -> TelegramUrl.DEFAULT_URL, new DefaultGetUpdatesGenerator(), updatesConsumer);
    }

    public BotSession registerBot(String botToken, Supplier<TelegramUrl> telegramUrlSupplier, Function<Integer, GetUpdates> getUpdatesGenerator, LongPollingUpdateConsumer updatesConsumer) throws TelegramApiException {
        if (this.botSessions.containsKey(botToken)) {
            throw new TelegramApiException("Bot is already registered");
        }
        BotSession botSession = new BotSession(this.objectMapperSupplier.get(), this.okHttpClientCreator.get(), this.executorSupplier.get(), botToken, telegramUrlSupplier, getUpdatesGenerator, this.backOffSupplier, updatesConsumer);
        this.botSessions.put(botToken, botSession);
        if (this.isAppRunning.get()) {
            botSession.start();
        }
        return botSession;
    }

    public void unregisterBot(String botToken) throws TelegramApiException {
        if (!this.botSessions.containsKey(botToken)) {
            throw new TelegramApiException("Bot is not registered");
        }
        BotSession botSession = this.botSessions.remove(botToken);
        botSession.stop();
    }

    public boolean isRunning() {
        return this.isAppRunning.get() && this.botSessions.values().stream().allMatch(BotSession::isRunning);
    }

    public void start() throws TelegramApiException {
        if (this.isAppRunning.get()) {
            throw new TelegramApiException("App is already running");
        }
        if (!this.botSessions.isEmpty() && this.botSessions.values().stream().allMatch(BotSession::isRunning)) {
            throw new TelegramApiException("All bots already running");
        }
        this.isAppRunning.set(true);
        for (BotSession botSession : this.botSessions.values()) {
            if (botSession.isRunning()) continue;
            botSession.start();
        }
    }

    public void stop() throws TelegramApiException {
        if (!this.isAppRunning.get()) {
            throw new TelegramApiException("App is not running");
        }
        if (!this.botSessions.isEmpty() && this.botSessions.values().stream().noneMatch(BotSession::isRunning)) {
            throw new TelegramApiException("All bots already stopped");
        }
        this.isAppRunning.set(false);
        for (BotSession botSession : this.botSessions.values()) {
            if (!botSession.isRunning()) continue;
            botSession.stop();
        }
    }

    @Override
    public void close() throws Exception {
        this.isAppRunning.set(false);
        for (BotSession botSession : this.botSessions.values()) {
            if (botSession == null) continue;
            botSession.close();
        }
    }
}

